/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.typho.vibrancy.Vibrancy;
import org.apache.commons.lang3.tuple.ImmutablePair;

public interface BlockStateFunction<T> {
    public T apply(BlockState var1);

    public static <T> BlockStateFunction<T> parse(Map<Predicate<BlockState>, Supplier<T>> map, Supplier<T> def) {
        return state -> map.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(state)).map(Map.Entry::getValue).findAny().orElse(def).get();
    }

    public static <T> BlockStateFunction<T> parseJson(Block block, JsonElement json, Function<JsonElement, T> toT, Supplier<T> def) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            JsonElement defElement = obj.get("default");
            if (defElement != null) {
                Object t = toT.apply(defElement);
                def = () -> t;
            }
            return BlockStateFunction.parse(obj.asMap().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("default")).map(entry -> {
                Object value = toT.apply((JsonElement)entry.getValue());
                return new ImmutablePair(Vibrancy.BLOCK_STATE_PREDICATE.apply((StateDefinition<Block, BlockState>)block.getStateDefinition(), (String)entry.getKey()), () -> value);
            }).collect(LinkedHashMap::new, (map, value) -> map.put((Predicate)value.getLeft(), (Supplier)value.getRight()), HashMap::putAll), def);
        }
        Object t = toT.apply(json);
        return state -> t;
    }
}

