/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.typho.vibrancy.Vibrancy;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL15;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

public interface RaytracedLight
extends NativeResource {
    public static final Set<BlockPos> DIRTY = new HashSet<BlockPos>();

    default public boolean isVisible() {
        return true;
    }

    public void updateDirty(Iterable<BlockPos> var1);

    public void init();

    public boolean render(boolean var1);

    public Vector3d getPosition();

    public AABB getBoundingBox();

    default public void getQuads(Iterable<BakedQuad> bakedQuads, BlockPos pos, Consumer<Quad> out, Vec3 offset) {
        for (BakedQuad quad : bakedQuads) {
            Vector3f[] positions = new Vector3f[4];
            Vector2f[] uvs = new Vector2f[4];
            int[] data = quad.getVertices();
            int len = data.length / 8;
            int i = 0;
            int j = 0;
            while (i < len) {
                positions[i] = new Vector3f(Float.intBitsToFloat(data[j]) + (float)pos.getX() + (float)offset.x, Float.intBitsToFloat(data[j + 1]) + (float)pos.getY() + (float)offset.y, Float.intBitsToFloat(data[j + 2]) + (float)pos.getZ() + (float)offset.z);
                uvs[i] = new Vector2f(Float.intBitsToFloat(data[j + 4]), Float.intBitsToFloat(data[j + 5]));
                ++i;
                j += 8;
            }
            out.accept(new Quad(pos, positions[0], positions[1], positions[2], positions[3], uvs[0], uvs[1], uvs[2], uvs[3]));
        }
    }

    default public void getQuads(ClientLevel world, BlockPos pos, Consumer<Quad> out, double sqDist, BlockPos lightBlockPos, boolean normalTest) {
        BlockState state = world.getBlockState(pos);
        if (!((Boolean)Vibrancy.TRANSPARENCY_TEST.get()).booleanValue() && state.propagatesSkylightDown((BlockGetter)world, pos)) {
            return;
        }
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        RandomSource random = RandomSource.create();
        Vec3 offset = state.getOffset((BlockGetter)world, pos);
        for (Direction direction : Direction.values()) {
            if (!(sqDist <= 4.0) && (!Block.shouldRenderFace((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)direction, (BlockPos)pos.relative(direction)) || normalTest && !Vibrancy.pointsToward(pos, direction, lightBlockPos))) continue;
            this.getQuads(model.getQuads(state, direction, random), pos, out, offset);
        }
        this.getQuads(model.getQuads(state, null, random), pos, out, offset);
    }

    default public void getVolumes(ClientLevel world, BlockPos pos, Consumer<ShadowVolume> out, double sqDist, BlockPos lightBlockPos, Vector3f lightPos, float radius, boolean normalTest) {
        this.getQuads(world, pos, quad -> out.accept(quad.toVolume(lightPos, radius)), sqDist, lightBlockPos, normalTest);
    }

    default public void upload(BufferBuilder builder, Collection<ShadowVolume> volumes, VertexBuffer geomVBO, int quadsSSBO, int usage) {
        geomVBO.bind();
        geomVBO.upload(builder.build());
        VertexBuffer.unbind();
        ByteBuffer buf = MemoryUtil.memAlloc((int)(volumes.size() * 160));
        for (ShadowVolume v : volumes) {
            v.caster().put(buf);
        }
        GL15.glBindBuffer((int)37074, (int)quadsSSBO);
        GL15.glBufferData((int)37074, (ByteBuffer)buf.flip(), (int)usage);
        GL15.glBindBuffer((int)37074, (int)0);
        MemoryUtil.memFree((Buffer)buf);
    }

    public record Quad(BlockPos blockPos, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4, Vector3f n, float d, Vector3f e1, Vector3f e2) {
        public static final int BYTES = 160;

        public Quad(BlockPos blockPos, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4) {
            this(blockPos, v1, v2, v3, v4, uv1, uv2, uv3, uv4, new Vector3f((Vector3fc)v2).sub((Vector3fc)v1).cross((Vector3fc)new Vector3f((Vector3fc)v4).sub((Vector3fc)v1)).normalize(), new Vector3f((Vector3fc)v2).sub((Vector3fc)v1).cross((Vector3fc)new Vector3f((Vector3fc)v4).sub((Vector3fc)v1)).normalize().dot((Vector3fc)v1), new Vector3f((Vector3fc)v2).sub((Vector3fc)v1), new Vector3f((Vector3fc)v4).sub((Vector3fc)v1));
        }

        public void put(ByteBuffer buf) {
            buf.putFloat(this.v1.x).putFloat(this.v1.y).putFloat(this.v1.z).putFloat(0.0f);
            buf.putFloat(this.v2.x).putFloat(this.v2.y).putFloat(this.v2.z).putFloat(0.0f);
            buf.putFloat(this.v3.x).putFloat(this.v3.y).putFloat(this.v3.z).putFloat(0.0f);
            buf.putFloat(this.v4.x).putFloat(this.v4.y).putFloat(this.v4.z).putFloat(0.0f);
            buf.putFloat(this.uv1.x).putFloat(this.uv1.y);
            buf.putFloat(this.uv2.x).putFloat(this.uv2.y);
            buf.putFloat(this.uv3.x).putFloat(this.uv3.y);
            buf.putFloat(this.uv4.x).putFloat(this.uv4.y);
            buf.putFloat(this.n.x).putFloat(this.n.y).putFloat(this.n.z).putFloat(this.d);
            buf.putFloat(this.e1.x).putFloat(this.e1.y).putFloat(this.e1.z).putFloat(this.e1.dot((Vector3fc)this.e1));
            buf.putFloat(this.e2.x).putFloat(this.e2.y).putFloat(this.e2.z).putFloat(this.e2.dot((Vector3fc)this.e2));
            float d11 = this.e1.dot((Vector3fc)this.e1);
            float d12 = this.e1.dot((Vector3fc)this.e2);
            float d22 = this.e2.dot((Vector3fc)this.e2);
            float invDet = 1.0f / (d11 * d22 - d12 * d12);
            float inv11 = d22 * invDet;
            float inv12 = -d12 * invDet;
            float inv21 = -d12 * invDet;
            float inv22 = d11 * invDet;
            buf.putFloat(inv11).putFloat(inv12).putFloat(inv21).putFloat(inv22);
        }

        public ShadowVolume toVolume(Vector3f origin, float radius) {
            float d0 = this.n.dot((Vector3fc)this.v1.sub((Vector3fc)origin, new Vector3f()));
            float t = radius - d0;
            Vector3f[] vertices = new Vector3f[]{this.v1, this.v2, this.v3, this.v4, null, null, null, null};
            for (int i = 0; i < 4; ++i) {
                Vector3f vertex = new Vector3f((Vector3fc)vertices[i]);
                Vector3f off = vertex.sub((Vector3fc)origin, new Vector3f());
                vertices[i + 4] = vertex.add((Vector3fc)off.normalize(t));
            }
            return new ShadowVolume(this, vertices);
        }
    }

    public record ShadowVolume(Quad caster, Vector3f[] vertices) {
        public void render(VertexConsumer consumer) {
            consumer.addVertex(this.vertices()[0]).addVertex(this.vertices()[1]).addVertex(this.vertices()[2]).addVertex(this.vertices()[3]);
            consumer.addVertex(this.vertices()[1]).addVertex(this.vertices()[5]).addVertex(this.vertices()[6]).addVertex(this.vertices()[2]);
            consumer.addVertex(this.vertices()[5]).addVertex(this.vertices()[4]).addVertex(this.vertices()[7]).addVertex(this.vertices()[6]);
            consumer.addVertex(this.vertices()[4]).addVertex(this.vertices()[0]).addVertex(this.vertices()[3]).addVertex(this.vertices()[7]);
            consumer.addVertex(this.vertices()[1]).addVertex(this.vertices()[0]).addVertex(this.vertices()[4]).addVertex(this.vertices()[5]);
            consumer.addVertex(this.vertices()[3]).addVertex(this.vertices()[2]).addVertex(this.vertices()[6]).addVertex(this.vertices()[7]);
        }
    }
}

