/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import foundry.veil.api.client.render.light.PointLight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.RaytracedPointLight;
import org.joml.Vector3dc;

public class RaytracedPointBlockLight
extends RaytracedPointLight {
    public final BlockPos blockPos;
    protected boolean render = false;

    public RaytracedPointBlockLight(BlockPos blockPos) {
        this.blockPos = blockPos;
        this.markDirty();
    }

    @Override
    public void init() {
        BlockState state;
        DynamicLightInfo info;
        this.render = false;
        boolean dirty = this.isDirty();
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && (info = DynamicLightInfo.get(state = world.getBlockState(this.blockPos))) != null) {
            Vec3 offset = info.offset().apply(state).orElse(new Vec3(0.5, 0.5, 0.5));
            this.position.set((double)this.blockPos.getX() + offset.x, (double)this.blockPos.getY() + offset.y, (double)this.blockPos.getZ() + offset.z);
            info.initLight(this, state);
            this.render = true;
        }
        if (!dirty) {
            this.clean();
        }
    }

    @Override
    public boolean render(boolean raytrace) {
        if (!this.render) {
            return false;
        }
        return super.render(raytrace);
    }

    public final PointLight setPosition(Vector3dc position) {
        throw new UnsupportedOperationException("Can't move a block light");
    }

    public final PointLight setPosition(double x, double y, double z) {
        throw new UnsupportedOperationException("Can't move a block light");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.blockPos.getX() + ", " + this.blockPos.getY() + ", " + this.blockPos.getZ() + "]";
    }
}

