/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.typho.vibrancy.AbstractMovingRaytracedPointLight;
import net.typho.vibrancy.DynamicLightInfo;

public class RaytracedPointEntityLight
extends AbstractMovingRaytracedPointLight {
    public final LivingEntity entity;

    public RaytracedPointEntityLight(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public void init() {
        float tickDelta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        Vec3 entityPos = this.entity.getEyePosition(tickDelta).add(this.entity.getViewVector(tickDelta));
        this.setPosition(entityPos.x, entityPos.y, entityPos.z);
    }

    @Override
    public boolean shouldRegenAll() {
        return !this.quadBox.contains(this.entity.blockPosition());
    }

    public boolean init(ItemStack stack) {
        BlockItem block;
        BlockState state;
        DynamicLightInfo info;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (info = DynamicLightInfo.get(state = (block = (BlockItem)item).getBlock().defaultBlockState())) != null) {
            info.initLight(this, state);
            this.hasLight = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean render(boolean raytrace) {
        if (!this.init(this.entity.getMainHandItem()) && !this.init(this.entity.getOffhandItem())) {
            return false;
        }
        return super.render(raytrace);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.entity) + "]";
    }
}

