/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.typho.vibrancy.AbstractRaytracedPointLight;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RaytracedPointLight
extends AbstractRaytracedPointLight {
    protected final List<BlockPos> dirty = new LinkedList<BlockPos>();
    protected boolean remove = false;
    protected List<RaytracedLight.ShadowVolume> volumes = new LinkedList<RaytracedLight.ShadowVolume>();
    protected CompletableFuture<List<RaytracedLight.ShadowVolume>> fullRebuildTask;

    public void regenQuads(ClientLevel world, BlockPos pos, Consumer<RaytracedLight.ShadowVolume> out, BlockPos lightBlockPos, Vector3f lightPos) {
        this.volumes.removeIf(v -> v.caster().blockPos().equals((Object)pos));
        this.getVolumes(world, pos, out, pos.distSqr((Vec3i)lightBlockPos), lightBlockPos, lightPos, this.radius, true);
    }

    @Override
    public void updateDirty(Iterable<BlockPos> it) {
        BlockBox box = this.getBox();
        for (BlockPos pos : it) {
            if (!box.contains(pos)) continue;
            this.dirty.add(pos);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public boolean render(boolean raytrace) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            BufferBuilder builder;
            BlockPos lightBlockPos = new BlockPos((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f((float)this.getPosition().x, (float)this.getPosition().y, (float)this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            BlockBox box = this.getBox();
            if (this.fullRebuildTask != null) {
                ++Vibrancy.NUM_LIGHT_TASKS;
            }
            if (!this.dirty.isEmpty()) {
                for (BlockPos blockPos : this.dirty) {
                    if (!blockPos.equals((Object)lightBlockPos)) {
                        this.regenQuads(world, blockPos, this.volumes::add, lightBlockPos, lightPos);
                    }
                    for (Direction dir : Direction.values()) {
                        BlockPos pos1 = blockPos.relative(dir);
                        if (pos1.equals((Object)lightBlockPos)) continue;
                        this.regenQuads(world, pos1, this.volumes::add, lightBlockPos, lightPos);
                    }
                }
                this.dirty.clear();
                builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                for (RaytracedLight.ShadowVolume volume : this.volumes) {
                    volume.render((VertexConsumer)builder);
                }
                this.upload(builder, this.volumes);
                this.shadowCount = this.volumes.size();
            }
            if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                try {
                    this.volumes = this.fullRebuildTask.get();
                    this.fullRebuildTask = null;
                    builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
                    for (RaytracedLight.ShadowVolume volume : this.volumes) {
                        volume.render((VertexConsumer)builder);
                    }
                    this.upload(builder, this.volumes);
                    this.shadowCount = this.volumes.size();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace) {
                if (blockRadius < 1) {
                    raytrace = false;
                } else if (this.isDirty()) {
                    this.clean();
                    this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                        LinkedList volumes = new LinkedList();
                        for (int x = box.min().getX(); x <= box.max().getX(); ++x) {
                            for (int y = box.min().getY(); y <= box.max().getY(); ++y) {
                                for (int z = box.min().getZ(); z <= box.max().getZ(); ++z) {
                                    double sqDist;
                                    BlockPos pos = new BlockPos(x, y, z);
                                    if (pos.equals((Object)lightBlockPos) || (sqDist = pos.distSqr((Vec3i)lightBlockPos)) == 0.0 || !(sqDist < (double)(blockRadius * blockRadius))) continue;
                                    this.getVolumes(world, pos, volumes::add, sqDist, lightBlockPos, lightPos, this.radius, true);
                                }
                            }
                        }
                        return volumes;
                    });
                }
            }
            if (this.isVisible()) {
                Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
                Matrix4f matrix4f = new Matrix4f().rotate((Quaternionfc)camera.rotation().invert(new Quaternionf())).translate((float)(-camera.getPosition().x), (float)(-camera.getPosition().y), (float)(-camera.getPosition().z));
                this.renderMask(raytrace, lightPos, matrix4f);
                this.renderLight(lightPos, matrix4f);
                return true;
            }
        }
        return false;
    }
}

