/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import net.typho.vibrancy.BlockStateFunction;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.light.AbstractPointLight;
import net.typho.vibrancy.light.BlockPointLight;
import net.typho.vibrancy.light.EntityPointLight;
import net.typho.vibrancy.light.RaytracedLight;
import net.typho.vibrancy.light.SkyLight;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;

public class Vibrancy {
    public static final String MOD_ID = "vibrancy";
    public static final OptionInstance<Boolean> TRANSPARENCY_TEST = OptionInstance.createBoolean((String)"options.vibrancy.transparency_test", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.transparency_test.tooltip")), (boolean)true);
    public static final OptionInstance<Boolean> BETTER_FOG = OptionInstance.createBoolean((String)"options.vibrancy.better_fog", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.better_fog.tooltip")), (boolean)true);
    public static final OptionInstance<Boolean> ELYTRA_TRAILS = OptionInstance.createBoolean((String)"options.vibrancy.elytra_trails", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.elytra_trails.tooltip")), (boolean)true);
    public static final OptionInstance<Integer> SKY_SHADOW_DISTANCE = new OptionInstance("options.vibrancy.sky_shadow_distance", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.sky_shadow_distance.tooltip")), (text, value) -> Options.genericValueLabel((Component)text, (Component)Component.translatable((String)"options.vibrancy.sky_shadow_distance.value", (Object[])new Object[]{value})), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 8, false), (Object)4, value -> {});
    public static final OptionInstance<Integer> RAYTRACE_DISTANCE = new OptionInstance("options.vibrancy.raytrace_distance", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.raytrace_distance.tooltip")), (text, value) -> Options.genericValueLabel((Component)text, (Component)Component.translatable((String)"options.vibrancy.raytrace_distance.value", (Object[])new Object[]{value * 16})), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 32, false), (Object)16, value -> {});
    public static final OptionInstance<Integer> LIGHT_CULL_DISTANCE = new OptionInstance("options.vibrancy.light_cull_distance", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.light_cull_distance.tooltip")), (text, value) -> Options.genericValueLabel((Component)text, (Component)Component.translatable((String)"options.vibrancy.light_cull_distance.value", (Object[])new Object[]{value * 16})), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 32, false), (Object)32, value -> {});
    public static final OptionInstance<Integer> MAX_RAYTRACED_LIGHTS = new OptionInstance("options.vibrancy.max_raytraced_lights", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.max_raytraced_lights.tooltip")), (text, value) -> Options.genericValueLabel((Component)text, (Component)(value > 100 ? Component.translatable((String)"options.vibrancy.max_raytraced_lights.max") : Component.translatable((String)"options.vibrancy.max_raytraced_lights.value", (Object[])new Object[]{value}))), (OptionInstance.ValueSet)new OptionInstance.IntRange(5, 105, false), (Object)60, value -> {});
    public static final OptionInstance<Integer> MAX_SHADOW_DISTANCE = new OptionInstance("options.vibrancy.max_shadow_distance", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.max_shadow_distance.tooltip")), (text, value) -> Options.genericValueLabel((Component)text, (Component)(value > 15 ? Component.translatable((String)"options.vibrancy.max_shadow_distance.max") : Component.translatable((String)"options.vibrancy.max_shadow_distance.value", (Object[])new Object[]{value}))), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 16, false), (Object)6, value -> {});
    public static final OptionInstance<Integer> MAX_LIGHT_RADIUS = new OptionInstance("options.vibrancy.max_light_radius", value -> Tooltip.create((Component)Component.translatable((String)"options.vibrancy.max_light_radius.tooltip")), (text, value) -> Options.genericValueLabel((Component)text, (Component)(value > 15 ? Component.translatable((String)"options.vibrancy.max_light_radius.max") : Component.translatable((String)"options.vibrancy.max_light_radius.value", (Object[])new Object[]{value}))), (OptionInstance.ValueSet)new OptionInstance.IntRange(1, 16, false), (Object)15, value -> {});
    public static boolean DEBUG_SKY_LIGHT_VIEW = false;
    public static boolean RENDER_SKY_LIGHT = true;
    public static boolean RENDER_BLOCK_LIGHT = true;
    public static boolean RENDER_ENTITY_LIGHT = true;
    public static boolean SEEN_ALPHA_TEXT = false;
    public static Supplier<SimpleParticleType> STEAM;
    public static final Map<ResourceKey<Block>, BlockStateFunction<Boolean>> EMISSIVE_OVERRIDES;
    public static final Map<BlockPos, BlockPointLight> BLOCK_LIGHTS;
    public static final Map<LivingEntity, EntityPointLight> ENTITY_LIGHTS;
    public static int NUM_LIGHT_TASKS;
    public static int NUM_RAYTRACED_LIGHTS;
    public static int NUM_VISIBLE_LIGHTS;
    public static int SHADOW_COUNT;
    public static VertexBuffer SCREEN_VBO;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static int maxLights() {
        int v = (Integer)MAX_RAYTRACED_LIGHTS.get();
        return v > 100 ? Integer.MAX_VALUE : v;
    }

    public static int capShadowDistance(int distance) {
        int v = (Integer)MAX_SHADOW_DISTANCE.get();
        return v > 15 ? distance : Math.min(distance, v);
    }

    public static boolean shouldRenderLight(RaytracedLight light) {
        Vec3 cam = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        boolean b = light.shouldRender(cam);
        if (b) {
            ++NUM_VISIBLE_LIGHTS;
        }
        return b;
    }

    public static double getLightSortDistance(RaytracedLight light) {
        return light.getSortDistance();
    }

    public static void renderLight(RaytracedLight light, int[] cap) {
        boolean raytrace;
        boolean bl = raytrace = cap[0] < Vibrancy.maxLights();
        if (light.render(raytrace)) {
            if (raytrace) {
                ++NUM_RAYTRACED_LIGHTS;
            }
            cap[0] = cap[0] + 1;
        }
    }

    public static boolean pointsToward(Direction face, Vector3f offset) {
        Vec3i normal = face.getNormal();
        return new Vector3f((float)normal.getX(), (float)normal.getY(), (float)normal.getZ()).dot((Vector3fc)offset) > 0.0f;
    }

    public static void elytraTrail(LivingEntity entity) {
        if (Math.random() < Math.min(entity.getDeltaMovement().length() - 0.75, (entity.getY() - 80.0) / 40.0)) {
            entity.level().addParticle((ParticleOptions)STEAM.get(), entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public static void updateBlock(BlockPos pos, BlockState state) {
        DynamicLightInfo info = DynamicLightInfo.get(state);
        if (info != null) {
            info.addBlockLight(pos, state);
        }
    }

    public static void registerReloadListeners(ReloadableResourceManager resourceManager) {
        resourceManager.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
            BufferedReader reader;
            DynamicLightInfo.MAP.clear();
            for (Resource resource : manager.getResourceStack(Vibrancy.id("dynamic_lights.json"))) {
                try {
                    reader = resource.openAsReader();
                    try {
                        JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                            if (key.startsWith("#")) {
                                TagKey tagKey = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)key.substring(1)));
                                DynamicLightInfo.MAP.put(state -> state.is(tagKey), Util.memoize(state -> new DynamicLightInfo.Builder().load((Block)state.getBlock().builtInRegistryHolder().value(), (JsonElement)value).build()));
                            } else {
                                ResourceKey regKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)key));
                                DynamicLightInfo info = new DynamicLightInfo.Builder().load((Block)BuiltInRegistries.BLOCK.get(regKey), (JsonElement)value).build();
                                DynamicLightInfo.MAP.put(state -> state.is(regKey), state -> info);
                            }
                        });
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            EMISSIVE_OVERRIDES.clear();
            for (Resource resource : manager.getResourceStack(Vibrancy.id("emissive_blocks.json"))) {
                try {
                    reader = resource.openAsReader();
                    try {
                        JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                            ResourceKey regKey = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)key));
                            EMISSIVE_OVERRIDES.put((ResourceKey<Block>)regKey, BlockStateFunction.parseJson((Block)BuiltInRegistries.BLOCK.get(regKey), value, JsonElement::getAsBoolean, () -> false));
                        });
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    public static void onChunkLoad(LevelChunk chunk) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkLoad(chunk.getPos());
        }
        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b = new ChunkPos(light.blockPos).equals((Object)chunk.getPos());
            if (b) {
                light.free();
            }
            return b;
        });
        for (int i = chunk.getMinSection(); i < chunk.getMaxSection(); ++i) {
            LevelChunkSection section = chunk.getSection(chunk.getSectionIndexFromSectionY(i));
            if (!section.maybeHas(state -> DynamicLightInfo.MAP.keySet().stream().anyMatch(p -> p.test(state)))) continue;
            BlockPos minPos = SectionPos.of((ChunkPos)chunk.getPos(), (int)i).origin();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        BlockState state2 = section.getBlockState(x, y, z);
                        DynamicLightInfo info = DynamicLightInfo.get(state2);
                        if (info == null) continue;
                        info.addBlockLight(new BlockPos(x + minPos.getX(), y + minPos.getY(), z + minPos.getZ()), state2);
                    }
                }
            }
        }
    }

    public static void onChunkUnload(LevelChunk chunk) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkUnload(chunk.getPos());
        }
        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b = new ChunkPos(light.blockPos).equals((Object)chunk.getPos());
            if (b) {
                light.free();
            }
            return b;
        });
    }

    public static void afterClientLevelChange(ClientLevel world) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.free();
        }
        if (world.dimension().equals(Level.OVERWORLD)) {
            SkyLight.INSTANCE = new SkyLight.Overworld();
            SkyLight.INSTANCE.markDirty();
        } else {
            SkyLight.INSTANCE = null;
        }
        BLOCK_LIGHTS.values().forEach(AbstractPointLight::free);
        BLOCK_LIGHTS.clear();
        ENTITY_LIGHTS.values().forEach(AbstractPointLight::free);
        ENTITY_LIGHTS.clear();
        for (AbstractClientPlayer player : world.players()) {
            ENTITY_LIGHTS.put((LivingEntity)player, new EntityPointLight((LivingEntity)player));
        }
    }

    public static void render() {
        NUM_LIGHT_TASKS = 0;
        ResourceLocation id = Vibrancy.id("ray_light");
        VeilRenderSystem.renderer().enableBuffers(id, new DynamicBufferType[]{DynamicBufferType.NORMAL, DynamicBufferType.ALBEDO, DynamicBufferType.LIGHT_UV});
        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(id).bind(true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b;
            boolean bl = b = light == null || light.shouldRemove();
            if (b && light != null) {
                light.free();
            }
            return b;
        });
        int[] cap = new int[]{0};
        NUM_RAYTRACED_LIGHTS = 0;
        NUM_VISIBLE_LIGHTS = 0;
        SHADOW_COUNT = 0;
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.init();
            SkyLight.INSTANCE.updateDirty(RaytracedLight.DIRTY);
        }
        for (BlockPointLight blockPointLight : BLOCK_LIGHTS.values()) {
            blockPointLight.init();
            blockPointLight.updateDirty(RaytracedLight.DIRTY);
        }
        for (EntityPointLight entityPointLight : ENTITY_LIGHTS.values()) {
            entityPointLight.init();
            entityPointLight.updateDirty(RaytracedLight.DIRTY);
        }
        if (SkyLight.INSTANCE != null && RENDER_SKY_LIGHT) {
            Vibrancy.renderLight(SkyLight.INSTANCE, cap);
        }
        if (RENDER_BLOCK_LIGHT) {
            ENTITY_LIGHTS.values().stream().sorted(Comparator.comparingDouble(Vibrancy::getLightSortDistance)).filter(Vibrancy::shouldRenderLight).forEachOrdered(light -> Vibrancy.renderLight(light, cap));
        }
        if (RENDER_ENTITY_LIGHT) {
            BLOCK_LIGHTS.values().stream().sorted(Comparator.comparingDouble(Vibrancy::getLightSortDistance)).filter(Vibrancy::shouldRenderLight).forEachOrdered(light -> Vibrancy.renderLight(light, cap));
        }
        RaytracedLight.DIRTY.clear();
    }

    public static boolean debugKey(int key) {
        switch (key) {
            case 57: {
                DEBUG_SKY_LIGHT_VIEW = !DEBUG_SKY_LIGHT_VIEW;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"debug.vibrancy.sky_light_view"), false);
                return true;
            }
            case 56: {
                RENDER_SKY_LIGHT = !RENDER_SKY_LIGHT;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"debug.vibrancy.render_sky_light"), false);
                return true;
            }
            case 55: {
                RENDER_BLOCK_LIGHT = !RENDER_BLOCK_LIGHT;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"debug.vibrancy.render_block_light"), false);
                return true;
            }
            case 54: {
                RENDER_ENTITY_LIGHT = !RENDER_ENTITY_LIGHT;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"debug.vibrancy.render_entity_light"), false);
                return true;
            }
        }
        return false;
    }

    public static void init() {
    }

    static {
        EMISSIVE_OVERRIDES = new LinkedHashMap<ResourceKey<Block>, BlockStateFunction<Boolean>>();
        BLOCK_LIGHTS = new LinkedHashMap<BlockPos, BlockPointLight>();
        ENTITY_LIGHTS = new LinkedHashMap<LivingEntity, EntityPointLight>();
        NUM_LIGHT_TASKS = 0;
        NUM_RAYTRACED_LIGHTS = 0;
        NUM_VISIBLE_LIGHTS = 0;
        SHADOW_COUNT = 0;
        RenderSystem.recordRenderCall(() -> {
            BufferBuilder builder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
            builder.addVertex(-1.0f, 1.0f, 0.0f);
            builder.addVertex(-1.0f, -1.0f, 0.0f);
            builder.addVertex(1.0f, 1.0f, 0.0f);
            builder.addVertex(1.0f, -1.0f, 0.0f);
            SCREEN_VBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
            SCREEN_VBO.bind();
            SCREEN_VBO.upload(builder.buildOrThrow());
            VertexBuffer.unbind();
        });
    }
}

