/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.AbstractPointLight;
import net.typho.vibrancy.light.RaytracedLight;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class AbstractMovingPointLight
extends AbstractPointLight {
    protected boolean hasLight = false;
    protected Map<BlockPos, List<RaytracedLight.Quad>> quads = new LinkedHashMap<BlockPos, List<RaytracedLight.Quad>>();
    protected final List<BlockPos> dirty = new LinkedList<BlockPos>();
    protected BlockBox quadBox;
    protected CompletableFuture<Map<BlockPos, List<RaytracedLight.Quad>>> fullRebuildTask;

    @Override
    public void updateDirty(Iterable<BlockPos> it) {
        BlockBox box = this.getBox();
        for (BlockPos pos : it) {
            if (!box.contains(pos)) continue;
            this.dirty.add(pos);
        }
    }

    @Override
    protected void upload(BufferBuilder builder, Collection<? extends RaytracedLight.IQuad> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35040);
        }
    }

    protected void regenQuadsSync(ClientLevel world, BlockPos pos, Consumer<RaytracedLight.Quad> out, BlockPos lightBlockPos) {
        this.quads.remove(pos);
        this.regenQuadsAsync(world, pos, out, lightBlockPos);
    }

    protected void regenQuadsAsync(ClientLevel world, BlockPos pos, Consumer<RaytracedLight.Quad> out, BlockPos lightBlockPos) {
        this.getQuads(world, pos, out, pos.distSqr((Vec3i)lightBlockPos) <= 4.0, lightBlockPos, false, (Direction dir) -> true);
    }

    protected void regenAll(ClientLevel world, BlockBox box, BlockPos lightBlockPos) {
        this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
            LinkedHashMap<BlockPos, List<RaytracedLight.Quad>> quads = new LinkedHashMap<BlockPos, List<RaytracedLight.Quad>>();
            for (int x = box.min().getX(); x <= box.max().getX(); ++x) {
                for (int y = box.min().getY(); y <= box.max().getY(); ++y) {
                    for (int z = box.min().getZ(); z <= box.max().getZ(); ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        List<RaytracedLight.Quad> existing = this.quads.get(pos);
                        if (existing != null && !existing.isEmpty()) {
                            quads.put(pos, existing);
                            continue;
                        }
                        LinkedList list = new LinkedList();
                        this.regenQuadsAsync(world, pos, list::add, lightBlockPos);
                        if (list.isEmpty()) continue;
                        quads.put(pos, list);
                    }
                }
            }
            return quads;
        });
    }

    @Override
    public void init() {
    }

    public abstract boolean shouldRegenAll();

    @Override
    public boolean render(boolean raytrace) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            BlockPos lightBlockPos = new BlockPos((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f(this.getPosition().x, this.getPosition().y, this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            BlockBox box = this.getBox();
            LinkedList volumes = new LinkedList();
            BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            if (this.isVisible()) {
                if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                    try {
                        this.quads = this.fullRebuildTask.get();
                        this.fullRebuildTask = null;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                } else if (this.hasLight) {
                    if (this.quadBox == null || this.shouldRegenAll()) {
                        this.dirty.clear();
                        this.regenAll(world, blockRadius > 1 ? new BlockBox(new BlockPos(box.min().getX() - blockRadius, box.min().getY() - blockRadius, box.min().getZ() - blockRadius), new BlockPos(box.max().getX() + blockRadius, box.max().getY() + blockRadius, box.max().getZ() + blockRadius)) : box, lightBlockPos);
                        this.quadBox = box;
                    } else if (!this.dirty.isEmpty()) {
                        for (BlockPos pos2 : this.dirty) {
                            LinkedList list2 = new LinkedList();
                            this.regenQuadsSync(world, pos2, list2::add, lightBlockPos);
                            for (Direction dir : Direction.values()) {
                                this.regenQuadsSync(world, pos2.relative(dir), list2::add, lightBlockPos);
                            }
                            if (!list2.isEmpty()) {
                                this.quads.put(pos2, list2);
                                continue;
                            }
                            this.quads.remove(pos2);
                        }
                    }
                }
                this.quads.forEach((pos, list) -> {
                    if (box.contains(pos)) {
                        for (RaytracedLight.Quad quad : list) {
                            RaytracedLight.ShadowVolume volume = quad.toVolumeSphere(lightPos, this.radius);
                            volume.render((VertexConsumer)builder);
                            volumes.add(volume);
                        }
                    }
                });
                this.upload(builder, volumes);
                this.shadowCount = volumes.size();
                Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
                Matrix4f view = new Matrix4f().rotate((Quaternionfc)camera.rotation().invert(new Quaternionf())).translate((float)(-camera.getPosition().x), (float)(-camera.getPosition().y), (float)(-camera.getPosition().z));
                this.renderMask(raytrace, lightPos, view);
                this.renderLight(lightPos, view);
                return true;
            }
        }
        return false;
    }
}

