/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.light.AbstractMovingPointLight;
import net.typho.vibrancy.mixin.LightTextureAccessor;

public class EntityPointLight
extends AbstractMovingPointLight {
    public final LivingEntity entity;

    public EntityPointLight(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public boolean shouldRemove() {
        return this.entity.isRemoved();
    }

    @Override
    public boolean shouldRender(Vec3 cam) {
        return super.shouldRender(cam) || this.entity == Minecraft.getInstance().cameraEntity;
    }

    @Override
    public void init() {
        float tickDelta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        Vec3 entityPos = this.entity.getEyePosition(tickDelta).add(this.entity.getViewVector(tickDelta));
        this.position.set(entityPos.x, entityPos.y, entityPos.z);
    }

    @Override
    public boolean shouldRegenAll() {
        return !this.quadBox.contains(this.entity.blockPosition());
    }

    public boolean init(ItemStack stack) {
        BlockItem block;
        BlockState state;
        DynamicLightInfo info;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (info = DynamicLightInfo.get(state = (block = (BlockItem)item).getBlock().defaultBlockState())) != null) {
            info.initLight(this, state);
            NativeImage lightmap = ((LightTextureAccessor)Minecraft.getInstance().gameRenderer.lightTexture()).getLightPixels();
            Color color = new Color(lightmap.getPixelRGBA(15, 0));
            this.color.add((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
            this.hasLight = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean render(boolean raytrace) {
        if (!this.init(this.entity.getMainHandItem()) && !this.init(this.entity.getOffhandItem())) {
            return false;
        }
        return super.render(raytrace);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.entity) + "]";
    }
}

