/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.client.render.VeilRenderSystem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.typho.vibrancy.Vibrancy;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL15;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

public interface RaytracedLight
extends NativeResource {
    public static final Set<BlockPos> DIRTY = new HashSet<BlockPos>();

    default public boolean isVisible() {
        return true;
    }

    public void updateDirty(Iterable<BlockPos> var1);

    public void init();

    public boolean render(boolean var1);

    default public boolean shouldRemove() {
        return false;
    }

    default public boolean shouldRender(Vec3 cam) {
        AABB box = this.getBoundingBox();
        if (box == null) {
            return true;
        }
        return VeilRenderSystem.getCullingFrustum().testAab(box);
    }

    default public double getSortDistance() {
        return this.getSortDistance(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition());
    }

    default public double getSortDistance(Vec3 cam) {
        return 0.0;
    }

    @Nullable
    default public AABB getBoundingBox() {
        return null;
    }

    default public void getQuads(Iterable<BakedQuad> bakedQuads, BlockPos pos, Consumer<Quad> out, Vec3 offset, @Nullable Direction direction) {
        for (BakedQuad quad : bakedQuads) {
            Vector3f[] positions = new Vector3f[4];
            Vector2f[] uvs = new Vector2f[4];
            int[] data = quad.getVertices();
            int len = data.length / 8;
            int i = 0;
            int j = 0;
            while (i < len) {
                positions[i] = new Vector3f(Float.intBitsToFloat(data[j]) + (float)pos.getX() + (float)offset.x, Float.intBitsToFloat(data[j + 1]) + (float)pos.getY() + (float)offset.y, Float.intBitsToFloat(data[j + 2]) + (float)pos.getZ() + (float)offset.z);
                uvs[i] = new Vector2f(Float.intBitsToFloat(data[j + 4]), Float.intBitsToFloat(data[j + 5]));
                ++i;
                j += 8;
            }
            out.accept(new Quad(pos, direction, positions[0], positions[1], positions[2], positions[3], uvs[0], uvs[1], uvs[2], uvs[3]));
        }
    }

    default public void getQuads(ClientLevel world, BlockPos pos, Consumer<Quad> out, boolean close, BlockPos blockPos, boolean normalTest, Predicate<Direction> predicate) {
        this.getQuads(world, pos, out, close, new Vector3f((float)(pos.getX() - blockPos.getX()), (float)(pos.getY() - blockPos.getY()), (float)(pos.getZ() - blockPos.getZ())), normalTest, predicate);
    }

    default public void getQuads(ClientLevel world, BlockPos pos, Consumer<Quad> out, boolean close, Vector3f lightDirection, boolean normalTest, Predicate<@Nullable Direction> predicate) {
        BlockState state = world.getBlockState(pos);
        if (!((Boolean)Vibrancy.TRANSPARENCY_TEST.get()).booleanValue() && state.propagatesSkylightDown((BlockGetter)world, pos)) {
            return;
        }
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        RandomSource random = RandomSource.create();
        Vec3 offset = state.getOffset((BlockGetter)world, pos);
        for (Direction direction : Direction.values()) {
            if (!predicate.test(direction) || !close && (!Block.shouldRenderFace((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)direction, (BlockPos)pos.relative(direction)) || normalTest && !Vibrancy.pointsToward(direction, lightDirection))) continue;
            this.getQuads(model.getQuads(state, direction, random), pos, out, offset, direction);
        }
        if (predicate.test(null)) {
            this.getQuads(model.getQuads(state, null, random), pos, out, offset, null);
        }
    }

    default public void upload(BufferBuilder builder, Collection<? extends IQuad> quads, VertexBuffer geomVBO, int quadsSSBO, int usage) {
        MeshData mesh = builder.build();
        if (mesh == null) {
            return;
        }
        geomVBO.bind();
        geomVBO.upload(mesh);
        VertexBuffer.unbind();
        ByteBuffer buf = MemoryUtil.memAlloc((int)(quads.size() * 160));
        for (IQuad iQuad : quads) {
            iQuad.toQuad().put(buf);
        }
        GL15.glBindBuffer((int)37074, (int)quadsSSBO);
        GL15.glBufferData((int)37074, (ByteBuffer)buf.flip(), (int)usage);
        GL15.glBindBuffer((int)37074, (int)0);
        MemoryUtil.memFree((Buffer)buf);
    }

    public record Quad(BlockPos blockPos, @Nullable Direction direction, @Nullable BlockPos relative, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4, Vector3f n, float d, Vector3f e1, Vector3f e2) implements IQuad
    {
        public static final int BYTES = 160;

        public Quad(BlockPos blockPos, @Nullable Direction direction, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4) {
            this(blockPos, direction, direction == null ? null : blockPos.relative(direction), v1, v2, v3, v4, uv1, uv2, uv3, uv4, new Vector3f((Vector3fc)v2).sub((Vector3fc)v1).cross((Vector3fc)new Vector3f((Vector3fc)v4).sub((Vector3fc)v1)).normalize(), new Vector3f((Vector3fc)v2).sub((Vector3fc)v1).cross((Vector3fc)new Vector3f((Vector3fc)v4).sub((Vector3fc)v1)).normalize().dot((Vector3fc)v1), new Vector3f((Vector3fc)v2).sub((Vector3fc)v1), new Vector3f((Vector3fc)v4).sub((Vector3fc)v1));
        }

        @Override
        public Quad toQuad() {
            return this;
        }

        public void put(ByteBuffer buf) {
            buf.putFloat(this.v1.x).putFloat(this.v1.y).putFloat(this.v1.z).putFloat(0.0f);
            buf.putFloat(this.v2.x).putFloat(this.v2.y).putFloat(this.v2.z).putFloat(0.0f);
            buf.putFloat(this.v3.x).putFloat(this.v3.y).putFloat(this.v3.z).putFloat(0.0f);
            buf.putFloat(this.v4.x).putFloat(this.v4.y).putFloat(this.v4.z).putFloat(0.0f);
            buf.putFloat(this.uv1.x).putFloat(this.uv1.y);
            buf.putFloat(this.uv2.x).putFloat(this.uv2.y);
            buf.putFloat(this.uv3.x).putFloat(this.uv3.y);
            buf.putFloat(this.uv4.x).putFloat(this.uv4.y);
            buf.putFloat(this.n.x).putFloat(this.n.y).putFloat(this.n.z).putFloat(this.d);
            buf.putFloat(this.e1.x).putFloat(this.e1.y).putFloat(this.e1.z).putFloat(this.e1.dot((Vector3fc)this.e1));
            buf.putFloat(this.e2.x).putFloat(this.e2.y).putFloat(this.e2.z).putFloat(this.e2.dot((Vector3fc)this.e2));
            float d11 = this.e1.dot((Vector3fc)this.e1);
            float d12 = this.e1.dot((Vector3fc)this.e2);
            float d22 = this.e2.dot((Vector3fc)this.e2);
            float invDet = 1.0f / (d11 * d22 - d12 * d12);
            float inv11 = d22 * invDet;
            float inv12 = -d12 * invDet;
            float inv21 = -d12 * invDet;
            float inv22 = d11 * invDet;
            buf.putFloat(inv11).putFloat(inv12).putFloat(inv21).putFloat(inv22);
        }

        public ShadowVolume toVolumeSphere(Vector3f origin, float radius) {
            float d0 = this.n.dot((Vector3fc)this.v1.sub((Vector3fc)origin, new Vector3f()));
            float t = radius - d0;
            Vector3f[] vertices = new Vector3f[]{this.v1, this.v2, this.v3, this.v4, null, null, null, null};
            for (int i = 0; i < 4; ++i) {
                Vector3f vertex = new Vector3f((Vector3fc)vertices[i]);
                Vector3f off = vertex.sub((Vector3fc)origin, new Vector3f());
                vertices[i + 4] = vertex.add((Vector3fc)off.normalize(t));
            }
            return new ShadowVolume(this, vertices);
        }

        public ShadowVolume toVolumeSky(Vector3f direction, float distance) {
            Vector3f add = direction.mul(-distance, new Vector3f());
            Vector3f[] vertices = new Vector3f[]{this.v1, this.v2, this.v3, this.v4, null, null, null, null};
            for (int i = 0; i < 4; ++i) {
                vertices[i + 4] = new Vector3f((Vector3fc)vertices[i]).add((Vector3fc)add);
            }
            return new ShadowVolume(this, vertices);
        }
    }

    public static interface IQuad {
        public Quad toQuad();
    }

    public record ShadowVolume(Quad caster, Vector3f[] vertices) implements IQuad
    {
        @Override
        public Quad toQuad() {
            return this.caster;
        }

        public void render(VertexConsumer consumer) {
            consumer.addVertex(this.vertices()[0]).addVertex(this.vertices()[1]).addVertex(this.vertices()[2]).addVertex(this.vertices()[3]);
            consumer.addVertex(this.vertices()[1]).addVertex(this.vertices()[5]).addVertex(this.vertices()[6]).addVertex(this.vertices()[2]);
            consumer.addVertex(this.vertices()[5]).addVertex(this.vertices()[4]).addVertex(this.vertices()[7]).addVertex(this.vertices()[6]);
            consumer.addVertex(this.vertices()[4]).addVertex(this.vertices()[0]).addVertex(this.vertices()[3]).addVertex(this.vertices()[7]);
            consumer.addVertex(this.vertices()[1]).addVertex(this.vertices()[0]).addVertex(this.vertices()[4]).addVertex(this.vertices()[5]);
            consumer.addVertex(this.vertices()[3]).addVertex(this.vertices()[2]).addVertex(this.vertices()[6]).addVertex(this.vertices()[7]);
        }
    }
}

