/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.Vec3;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.RaytracedLight;
import net.typho.vibrancy.mixin.LightTextureAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;

public abstract class SkyLight
implements RaytracedLight {
    @Nullable
    public static SkyLight INSTANCE;
    protected final VertexBuffer linesVBO = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
    protected final Map<ChunkPos, Chunk> chunks = new LinkedHashMap<ChunkPos, Chunk>();
    protected final List<ChunkPos> chunksToAdd = new LinkedList<ChunkPos>();
    protected Vector3f direction;
    protected float distance = 128.0f;
    protected boolean isDirty = true;
    protected int shadowCount = 0;

    public void markDirty() {
        this.isDirty = true;
    }

    public void clean() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void appendDebugInfo(Consumer<String> out) {
        out.accept("Sky Light Chunks: " + this.chunks.size());
        out.accept("Sky Light Shadows: " + this.shadowCount + " / " + this.chunks.values().stream().mapToInt(chunk -> chunk.quads.size()).sum());
        out.accept("Sky Light Direction: (" + this.direction.x + ", " + this.direction.y + ", " + this.direction.z + ")");
    }

    @Override
    public void updateDirty(Iterable<BlockPos> it) {
        for (BlockPos pos : it) {
            this.chunks.computeIfAbsent((ChunkPos)new ChunkPos((BlockPos)pos), (Function<ChunkPos, Chunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateDirty$1(net.minecraft.world.level.ChunkPos ), (Lnet/minecraft/world/level/ChunkPos;)Lnet/typho/vibrancy/light/SkyLight$Chunk;)((SkyLight)this)).dirty.add(pos);
        }
    }

    @Override
    public void init() {
    }

    public void onChunkLoad(ChunkPos pos) {
        this.chunksToAdd.add(pos);
    }

    public void onChunkUnload(ChunkPos pos) {
        this.chunksToAdd.remove(pos);
        Chunk chunk1 = this.chunks.remove(pos);
        if (chunk1 != null) {
            chunk1.free();
        }
    }

    public void onChunkUpdate(ChunkPos pos) {
        Chunk chunk1 = this.chunks.get(pos);
        if (chunk1 == null) {
            this.onChunkLoad(pos);
        } else {
            chunk1.markDirty();
        }
    }

    public abstract Vector3f getDirection(ClientLevel var1);

    public abstract Vector3f getColor(ClientLevel var1);

    protected boolean shouldCastBlock(ClientLevel level, BlockPos pos) {
        if (level.getBlockState(pos).propagatesSkylightDown((BlockGetter)level, pos)) {
            return false;
        }
        for (Direction direction : new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
            if (level.getBrightness(LightLayer.SKY, pos.relative(direction)) == 0) continue;
            return true;
        }
        return false;
    }

    protected void renderMask(boolean raytrace, Matrix4f view) {
        AdvancedFbo fbo = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask")));
        fbo.bind(true);
        GL15.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL15.glClearStencil((int)0);
        GL15.glClear((int)17664);
        if (raytrace) {
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)1);
            GL15.glStencilFunc((int)519, (int)1, (int)1);
            GL15.glStencilOp((int)7680, (int)7680, (int)7681);
            RenderType stencilType = VeilRenderType.get((ResourceLocation)Vibrancy.id("sky_stencil"), (Object[])new Object[0]);
            stencilType.setupRenderState();
            Vibrancy.SCREEN_VBO.bind();
            Vibrancy.SCREEN_VBO.drawWithShader(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.unbind();
            stencilType.clearRenderState();
            for (Chunk chunk : this.chunks.values()) {
                chunk.renderMask(view);
            }
            GL15.glDisable((int)2960);
        }
    }

    protected void renderLight(ClientLevel level) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
        VeilRenderSystem.setShader((ResourceLocation)Vibrancy.id("light/ray/sky"));
        ShaderInstance shader = Objects.requireNonNull(RenderSystem.getShader());
        shader.safeGetUniform("LightDirection").set(this.direction);
        shader.safeGetUniform("LightColor").set(this.getColor(level));
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.blendEquation((int)32774);
        Vibrancy.SCREEN_VBO.bind();
        Vibrancy.SCREEN_VBO.drawWithShader(null, null, shader);
        VertexBuffer.unbind();
        RenderSystem.disableBlend();
    }

    @Override
    public boolean render(boolean raytrace) {
        this.shadowCount = 0;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            this.direction = this.getDirection(level);
            this.chunksToAdd.removeIf(pos -> {
                if (level.hasChunk(pos.x, pos.z) && level.hasChunk(pos.x + 1, pos.z) && level.hasChunk(pos.x - 1, pos.z) && level.hasChunk(pos.x, pos.z + 1) && level.hasChunk(pos.x, pos.z - 1)) {
                    this.chunks.computeIfAbsent((ChunkPos)pos, x$0 -> new Chunk((ChunkPos)x$0)).markDirty();
                    return true;
                }
                return false;
            });
            int distanceSq = (Integer)Vibrancy.SKY_SHADOW_DISTANCE.get() * (Integer)Vibrancy.SKY_SHADOW_DISTANCE.get();
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.pos.distanceSquared(Minecraft.getInstance().player.chunkPosition()) <= distanceSq) {
                    chunk.render = true;
                    chunk.init(level, raytrace);
                    continue;
                }
                chunk.render = false;
            }
            this.clean();
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            Matrix4f view = new Matrix4f().rotate((Quaternionfc)camera.rotation().invert(new Quaternionf())).translate((float)(-camera.getPosition().x), (float)(-camera.getPosition().y), (float)(-camera.getPosition().z));
            this.renderMask(raytrace, view);
            this.renderLight(level);
            if (Vibrancy.DEBUG_SKY_LIGHT_VIEW) {
                BufferBuilder consumer = Tesselator.getInstance().begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
                boolean any = false;
                for (Chunk chunk : this.chunks.values()) {
                    if (chunk.shadowCount <= 0 || !chunk.render) continue;
                    for (RaytracedLight.Quad quad : chunk.quads) {
                        Vector3f[] order;
                        any = true;
                        Vector3f color = quad.direction() == null || Vibrancy.pointsToward(quad.direction(), this.direction) ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(1.0f, 0.0f, 0.0f);
                        for (Vector3f vec : order = new Vector3f[]{quad.v1(), quad.v2(), quad.v2(), quad.v3(), quad.v3(), quad.v4(), quad.v4(), quad.v1(), quad.v1(), quad.v3(), quad.v2(), quad.v4()}) {
                            consumer.addVertex(vec.x, vec.y, vec.z).setColor(color.x, color.y, color.z, 1.0f).setNormal(0.0f, 1.0f, 0.0f);
                        }
                    }
                }
                if (any) {
                    RenderType type = VeilRenderType.get((ResourceLocation)Vibrancy.id("debug_lines"), (Object[])new Object[0]);
                    type.setupRenderState();
                    this.linesVBO.bind();
                    this.linesVBO.upload(consumer.build());
                    this.linesVBO.drawWithShader(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                    VertexBuffer.unbind();
                    type.clearRenderState();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRender(Vec3 cam) {
        return true;
    }

    public void free() {
        for (Chunk chunk : this.chunks.values()) {
            chunk.free();
        }
        this.chunks.clear();
    }

    private /* synthetic */ Chunk lambda$updateDirty$1(ChunkPos x$0) {
        return new Chunk(x$0);
    }

    protected class Chunk
    implements NativeResource {
        protected final VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
        protected final int ssbo = GL15.glGenBuffers();
        protected final List<BlockPos> dirty = new LinkedList<BlockPos>();
        protected List<RaytracedLight.Quad> quads = new LinkedList<RaytracedLight.Quad>();
        protected CompletableFuture<List<RaytracedLight.Quad>> fullRebuildTask;
        protected final ChunkPos pos;
        protected boolean isDirty = true;
        protected boolean render = false;
        protected int shadowCount = 0;
        protected BlockBox box;

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        protected Chunk(ChunkPos pos) {
            this.pos = pos;
        }

        public void free() {
            this.vbo.close();
            GL15.glDeleteBuffers((int)this.ssbo);
        }

        protected void upload(BufferBuilder builder, Collection<? extends RaytracedLight.IQuad> volumes) {
            SkyLight.this.upload(builder, volumes, this.vbo, this.ssbo, 35044);
            this.shadowCount = volumes.size();
        }

        protected void regenQuads(ClientLevel level, BlockPos pos, Consumer<RaytracedLight.Quad> out) {
            this.quads.removeIf(quad -> quad.blockPos().equals((Object)pos));
            if (SkyLight.this.shouldCastBlock(level, pos)) {
                SkyLight.this.getQuads(level, pos, out, false, SkyLight.this.direction, false, dir -> true);
            }
        }

        protected void init(ClientLevel level, boolean raytrace) {
            if (this.fullRebuildTask != null) {
                ++Vibrancy.NUM_LIGHT_TASKS;
            }
            for (BlockPos pos : this.dirty) {
                this.regenQuads(level, pos, this.quads::add);
                for (Direction dir : Direction.values()) {
                    this.regenQuads(level, pos.relative(dir), this.quads::add);
                }
            }
            this.dirty.clear();
            if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                try {
                    this.quads = this.fullRebuildTask.get();
                    this.fullRebuildTask = null;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace && (this.isDirty() || SkyLight.this.isDirty())) {
                if (this.isDirty()) {
                    this.clean();
                }
                this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                    LinkedList quads = new LinkedList();
                    if (level.hasChunk(this.pos.x, this.pos.z)) {
                        LevelChunk chunk = level.getChunk(this.pos.x, this.pos.z);
                        for (int i = chunk.getMinSection(); i < chunk.getMaxSection(); ++i) {
                            LevelChunkSection section = chunk.getSection(chunk.getSectionIndexFromSectionY(i));
                            BlockPos minPos = SectionPos.of((ChunkPos)chunk.getPos(), (int)i).origin();
                            for (int x = 0; x < 16; ++x) {
                                for (int y = 0; y < 16; ++y) {
                                    for (int z = 0; z < 16; ++z) {
                                        BlockPos blockPos = new BlockPos(minPos.getX() + x, minPos.getY() + y, minPos.getZ() + z);
                                        if (!SkyLight.this.shouldCastBlock(level, blockPos)) continue;
                                        BlockState state = section.getBlockState(x, y, z);
                                        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
                                        RandomSource random = RandomSource.create();
                                        Vec3 offset = state.getOffset((BlockGetter)level, blockPos);
                                        for (Direction direction : Direction.values()) {
                                            if (!(state.getBlock() instanceof LeavesBlock ? level.getBlockState(blockPos.relative(direction)).isAir() : Block.shouldRenderFace((BlockState)state, (BlockGetter)level, (BlockPos)blockPos, (Direction)direction, (BlockPos)blockPos.relative(direction)))) continue;
                                            SkyLight.this.getQuads(model.getQuads(state, direction, random), blockPos, quads::add, offset, direction);
                                        }
                                        SkyLight.this.getQuads(model.getQuads(state, null, random), blockPos, quads::add, offset, null);
                                    }
                                }
                            }
                        }
                    }
                    return quads;
                });
            }
            BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
            LinkedList newQuads = new LinkedList();
            this.quads.removeIf(quad -> {
                if (quad.relative() != null && level.getBrightness(LightLayer.SKY, quad.relative()) == 0) {
                    return true;
                }
                if (quad.direction() == null || Vibrancy.pointsToward(quad.direction(), SkyLight.this.direction)) {
                    quad.toVolumeSky(SkyLight.this.direction, SkyLight.this.distance).render((VertexConsumer)builder);
                    newQuads.add(quad);
                }
                return false;
            });
            this.upload(builder, newQuads);
        }

        protected void renderMask(Matrix4f view) {
            if (this.shadowCount == 0 || !this.render) {
                return;
            }
            this.box = null;
            for (RaytracedLight.Quad quad : this.quads) {
                if (this.box == null) {
                    this.box = BlockBox.of((BlockPos)quad.blockPos());
                    continue;
                }
                this.box = this.box.include(quad.blockPos());
            }
            if (this.box == null) {
                return;
            }
            RenderType type = VeilRenderType.get((ResourceLocation)Vibrancy.id("sky_shadow"), (Object[])new Object[0]);
            type.setupRenderState();
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)255);
            GL15.glStencilFunc((int)514, (int)1, (int)1);
            GL15.glStencilOp((int)7680, (int)7680, (int)7680);
            GL30.glBindBufferBase((int)37074, (int)0, (int)this.ssbo);
            ShaderInstance shader = Objects.requireNonNull(RenderSystem.getShader());
            shader.safeGetUniform("MaxLength").set(SkyLight.this.distance);
            shader.safeGetUniform("LightDirection").set(SkyLight.this.direction);
            shader.setSampler("AtlasSampler", (Object)Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS));
            this.vbo.bind();
            this.vbo.drawWithShader(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.unbind();
            GL30.glBindBufferBase((int)37074, (int)0, (int)0);
            type.clearRenderState();
            SkyLight.this.shadowCount += this.shadowCount;
        }
    }

    public static class Overworld
    extends SkyLight {
        @Override
        public Vector3f getDirection(ClientLevel level) {
            float sunAngle = level.getSunAngle(0.0f);
            float x = (float)(-Math.sin(sunAngle));
            float y = (float)Math.cos(sunAngle);
            if (y < 0.0f) {
                x = -x;
                y = -y;
            }
            return new Vector3f(x, y, 0.0f);
        }

        @Override
        public Vector3f getColor(ClientLevel level) {
            Color color = new Color(((LightTextureAccessor)Minecraft.getInstance().gameRenderer.lightTexture()).getLightPixels().getPixelRGBA(0, 15));
            return new Vector3f((float)color.getRed() / 255.0f / 2.0f, (float)color.getGreen() / 255.0f / 2.0f, (float)color.getBlue() / 255.0f / 2.0f);
        }
    }
}

