/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.typho.vibrancy.BlockStateFunction;
import net.typho.vibrancy.Vibrancy;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin {
    @Shadow
    public abstract Block getBlock();

    @Shadow
    protected abstract BlockState asState();

    @Inject(method={"emissiveRendering"}, at={@At(value="HEAD")}, cancellable=true)
    private void emissiveRendering(BlockGetter level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockStateFunction<Boolean> func = Vibrancy.EMISSIVE_OVERRIDES.get(this.getBlock().builtInRegistryHolder().key());
        if (func != null) {
            cir.setReturnValue((Object)func.apply(this.asState()));
        }
    }
}

