/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientCommonPacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.EntityPointLight;
import net.typho.vibrancy.light.SkyLight;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin
extends ClientCommonPacketListenerImpl {
    public ClientPacketListenerMixin(Minecraft minecraft, Connection connection, CommonListenerCookie commonListenerCookie) {
        super(minecraft, connection, commonListenerCookie);
    }

    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void onGameJoin(ClientboundLoginPacket packet, CallbackInfo ci) {
        Vibrancy.ENTITY_LIGHTS.computeIfAbsent((LivingEntity)this.minecraft.player, EntityPointLight::new);
    }

    @Inject(method={"handleRespawn"}, at={@At(value="TAIL")})
    private void onPlayerRespawn(ClientboundRespawnPacket packet, CallbackInfo ci) {
        Vibrancy.ENTITY_LIGHTS.computeIfAbsent((LivingEntity)this.minecraft.player, EntityPointLight::new);
    }

    @Inject(method={"handleLevelChunkWithLight"}, at={@At(value="TAIL")})
    private void handleLevelChunkWithLight(ClientboundLevelChunkWithLightPacket packet, CallbackInfo ci) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkUpdate(new ChunkPos(packet.getX(), packet.getZ()));
        }
    }

    @Inject(method={"handleLightUpdatePacket"}, at={@At(value="TAIL")})
    private void handleLightUpdatePacket(ClientboundLightUpdatePacket packet, CallbackInfo ci) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkUpdate(new ChunkPos(packet.getX(), packet.getZ()));
        }
    }
}

