/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.mixin;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderInstance.class})
public abstract class ShaderProgramMixin {
    @Unique
    private Uniform camPos;
    @Unique
    private Uniform renderTime;
    @Unique
    private Uniform skyAngle;

    @Shadow
    @Nullable
    public abstract Uniform getUniform(String var1);

    @Shadow
    public abstract void setSampler(String var1, Object var2);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(ResourceProvider resourceProvider, String name, VertexFormat vertexFormat, CallbackInfo ci) {
        this.camPos = this.getUniform("CameraPos");
        this.renderTime = this.getUniform("RenderTime");
        this.skyAngle = this.getUniform("SkyAngle");
    }

    @Inject(method={"setDefaultUniforms"}, at={@At(value="TAIL")})
    private void setDefaultUniforms(VertexFormat.Mode mode, Matrix4f projectionMatrix, Matrix4f frustrumMatrix, Window window, CallbackInfo ci) {
        if (this.camPos != null) {
            Vector3f vec = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f();
            this.camPos.set(vec.z, vec.y, vec.x);
        }
        if (this.renderTime != null) {
            this.renderTime.set((float)GLFW.glfwGetTime());
        }
        if (this.skyAngle != null) {
            this.skyAngle.set(Minecraft.getInstance().level.getSunAngle(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false)));
        }
        DynamicBufferManger bufferManger = VeilRenderSystem.renderer().getDynamicBufferManger();
        for (DynamicBufferType dynamicBuffer : DynamicBufferType.values()) {
            this.setSampler(dynamicBuffer.getSourceName() + "Sampler", bufferManger.getBufferTexture(dynamicBuffer));
        }
    }
}

