/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1011;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7172;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.typho.vibrancy.BlockStateFunction;
import net.typho.vibrancy.DimensionLightInfo;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.RaytracedPointBlockLightRenderer;

public class Vibrancy
implements ClientModInitializer {
    public static final String MOD_ID = "vibrancy";
    public static final class_2960 LOGO_TEXTURE = class_2960.method_60655((String)"vibrancy", (String)"textures/gui/title/vibrancy.png");
    public static final class_7172<Boolean> DYNAMIC_LIGHTMAP = class_7172.method_42402((String)"options.vibrancy.dynamic_lightmap", (boolean)true);
    public static final class_7172<Boolean> TRANSPARENCY_TEST = class_7172.method_41749((String)"options.vibrancy.transparency_test", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.transparency_test.tooltip")), (boolean)false);
    public static final class_7172<Integer> RAYTRACE_DISTANCE = new class_7172("options.vibrancy.raytrace_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.raytrace_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.chunks", (Object[])new Object[]{value})), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)4, value -> {});
    public static final class_7172<Integer> LIGHT_CULL_DISTANCE = new class_7172("options.vibrancy.light_cull_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.light_cull_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.chunks", (Object[])new Object[]{value})), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)8, value -> {});
    public static final class_7172<Integer> MAX_RAYTRACED_LIGHTS = new class_7172("options.vibrancy.max_raytraced_lights", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_raytraced_lights.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 100 ? class_2561.method_43471((String)"options.vibrancy.max_raytraced_lights.max") : class_2561.method_43469((String)"options.vibrancy.max_raytraced_lights.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(5, 105, false), (Object)50, value -> {});
    public static final class_7172<Integer> MAX_SHADOW_DISTANCE = new class_7172("options.vibrancy.max_shadow_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_shadow_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 15 ? class_2561.method_43471((String)"options.vibrancy.max_shadow_distance.max") : class_2561.method_43469((String)"options.vibrancy.max_shadow_distance.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)8, value -> {});
    public static final class_7172<Integer> MAX_LIGHT_RADIUS = new class_7172("options.vibrancy.max_light_radius", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_light_radius.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 15 ? class_2561.method_43471((String)"options.vibrancy.max_light_radius.max") : class_2561.method_43469((String)"options.vibrancy.max_light_radius.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)15, value -> {});
    public static boolean SEEN_ALPHA_TEXT = false;
    public static final class_304 SAVE_LIGHTMAP = !FabricLoader.getInstance().isDevelopmentEnvironment() ? null : KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.vibrancy.debug.save_lightmap", 298, "key.categories.misc"));
    public static final Map<class_5321<class_2248>, BlockStateFunction<Boolean>> EMISSIVE_OVERRIDES = new LinkedHashMap<class_5321<class_2248>, BlockStateFunction<Boolean>>();
    public static int NUM_LIGHT_TASKS = 0;

    public static int maxLights() {
        int v = (Integer)MAX_RAYTRACED_LIGHTS.method_41753();
        return v > 100 ? Integer.MAX_VALUE : v;
    }

    public static int capShadowDistance(int distance) {
        int v = (Integer)MAX_SHADOW_DISTANCE.method_41753();
        return v > 15 ? distance : Math.min(distance, v);
    }

    public void onInitializeClient() {
        ClientChunkEvents.CHUNK_UNLOAD.register((world, chunk) -> RaytracedPointBlockLightRenderer.INSTANCE.lights.keySet().removeIf(pos -> new class_1923(pos).equals((Object)chunk.method_12004())));
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> RaytracedPointBlockLightRenderer.INSTANCE.lights.clear());
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(this){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)Vibrancy.MOD_ID, (String)"dynamic_lights");
            }

            public void method_14491(class_3300 manager) {
                BufferedReader reader;
                DynamicLightInfo.MAP.clear();
                for (class_3298 resource : manager.method_14489(class_2960.method_60655((String)Vibrancy.MOD_ID, (String)"dynamic_lights.json"))) {
                    try {
                        reader = resource.method_43039();
                        try {
                            JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                                if (key.startsWith("#")) {
                                    class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key.substring(1)));
                                    DynamicLightInfo.MAP.put(state -> state.method_26164(tagKey), class_156.method_34866(state -> new DynamicLightInfo.Builder().load((class_2248)state.method_41520().comp_349(), (JsonElement)value).build()));
                                } else {
                                    class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key));
                                    DynamicLightInfo info = new DynamicLightInfo.Builder().load((class_2248)class_7923.field_41175.method_29107(regKey), (JsonElement)value).build();
                                    DynamicLightInfo.MAP.put(state -> state.method_54097(regKey), state -> info);
                                }
                            });
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                EMISSIVE_OVERRIDES.clear();
                for (class_3298 resource : manager.method_14489(class_2960.method_60655((String)Vibrancy.MOD_ID, (String)"emissive_blocks.json"))) {
                    try {
                        reader = resource.method_43039();
                        try {
                            JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                                class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key));
                                EMISSIVE_OVERRIDES.put((class_5321<class_2248>)regKey, BlockStateFunction.parseJson((class_2248)class_7923.field_41175.method_29107(regKey), value, JsonElement::getAsBoolean, () -> false));
                            });
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"vibrant_textures"), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()), (class_2561)class_2561.method_43471((String)"pack.name.vibrancy.textures"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"ripple"), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()), (class_2561)class_2561.method_43471((String)"pack.name.vibrancy.ripple"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
    }

    public static float[] getTempTint(DimensionLightInfo dimLight, float temp) {
        float[] skyScales = new float[]{1.0f, 1.0f, 1.0f};
        if (dimLight.minTemp() == null || dimLight.maxTemp() == null) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        if (temp > 0.8f) {
            float blend = class_3532.method_15363((float)(temp - 0.8f), (float)0.0f, (float)1.0f);
            skyScales = new float[]{class_3532.method_16439((float)blend, (float)skyScales[0], (float)dimLight.maxTemp()[0]), class_3532.method_16439((float)blend, (float)skyScales[1], (float)dimLight.maxTemp()[1]), class_3532.method_16439((float)blend, (float)skyScales[2], (float)dimLight.maxTemp()[2])};
        } else {
            float blend = class_3532.method_15363((float)(0.8f - temp), (float)0.0f, (float)1.0f);
            skyScales = new float[]{class_3532.method_16439((float)blend, (float)skyScales[0], (float)dimLight.minTemp()[0]), class_3532.method_16439((float)blend, (float)skyScales[1], (float)dimLight.minTemp()[1]), class_3532.method_16439((float)blend, (float)skyScales[2], (float)dimLight.minTemp()[2])};
        }
        if (dimLight.skyScale() == null) {
            return skyScales;
        }
        return new float[]{skyScales[0] * dimLight.skyScale()[0], skyScales[1] * dimLight.skyScale()[1], skyScales[2] * dimLight.skyScale()[2]};
    }

    public static float getDay(class_638 world, float delta) {
        return world.method_23783(delta);
    }

    public static void createLightmap(class_638 world, class_746 player, class_315 options, class_1011 image, float temp, float humid, float delta) {
        DimensionLightInfo dimLight = DimensionLightInfo.get((class_1937)world);
        float day = Vibrancy.getDay(world, delta);
        float brightness = class_3532.method_15363((float)(2.0f - ((Double)options.method_42473().method_41753()).floatValue()), (float)1.0f, (float)2.0f);
        float[] tempTint = Vibrancy.getTempTint(dimLight, temp);
        for (int sky = 0; sky < image.method_4323(); ++sky) {
            float[] fArray;
            float fSky = (float)sky / (float)(image.method_4323() - 1);
            if (player.method_6059(class_1294.field_5925)) {
                fSky = 1.0f;
                day = 1.0f;
            } else {
                fSky = (float)Math.pow(fSky, brightness);
            }
            if (dimLight.hasDay() && dimLight.nightSky() != null) {
                float[] fArray2 = new float[3];
                fArray2[0] = fSky * fSky * class_3532.method_16439((float)day, (float)dimLight.nightSky()[0], (float)tempTint[0]);
                fArray2[1] = fSky * fSky * class_3532.method_16439((float)day, (float)dimLight.nightSky()[1], (float)tempTint[1]);
                fArray = fArray2;
                fArray2[2] = fSky * fSky * class_3532.method_16439((float)day, (float)dimLight.nightSky()[2], (float)tempTint[2]);
            } else {
                fArray = tempTint;
            }
            float[] skyTint = fArray;
            for (int block = 0; block < image.method_4307(); ++block) {
                float fBlock = (float)Math.pow((float)block / (float)(image.method_4307() - 1), brightness);
                float red = fBlock * dimLight.block()[0] + skyTint[0];
                float green = fBlock * dimLight.block()[1] + skyTint[1];
                float blue = fBlock * dimLight.block()[2] + skyTint[2];
                image.method_4305(block, sky, 0xFF000000 | (int)class_3532.method_15363((float)(blue * 255.0f), (float)0.0f, (float)255.0f) << 16 | (int)class_3532.method_15363((float)(green * 255.0f), (float)0.0f, (float)255.0f) << 8 | (int)class_3532.method_15363((float)(red * 255.0f), (float)0.0f, (float)255.0f));
            }
        }
    }
}

