package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.typho.vibrancy.mixin.BlockStateModelLoaderAccessor;
import org.apache.commons.lang3.tuple.ImmutablePair;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface BlockStateFunction<T> {
    T apply(class_2680 state);

    static <T> BlockStateFunction<T> parse(Map<Predicate<class_2680>, Supplier<T>> map, Supplier<T> def) {
        return state -> map.entrySet().stream()
                .filter(entry -> entry.getKey().test(state))
                .map(Map.Entry::getValue)
                .findAny()
                .orElse(def)
                .get();
    }

    static <T> BlockStateFunction<T> parseJson(class_2248 block, JsonElement json, Function<JsonElement, T> toT, Supplier<T> def) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            JsonElement defElement = obj.get("default");

            if (defElement != null) {
                T t = toT.apply(defElement);
                def = () -> t;
            }

            return parse(
                    obj.asMap().entrySet().stream()
                            .filter(entry -> !entry.getKey().equals("default"))
                            .map(entry -> {
                                T value = toT.apply(entry.getValue());
                                return new ImmutablePair<Predicate<class_2680>, Supplier<T>>(BlockStateModelLoaderAccessor.predicate(block.method_9595(), entry.getKey()), () -> value);
                            })
                            .collect(
                                    LinkedHashMap::new,
                                    (map, value) -> map.put(value.getLeft(), value.getRight()),
                                    HashMap::putAll
                            ),
                    def
            );
        } else {
            T t = toT.apply(json);
            return state -> t;
        }
    }
}
