package net.typho.vibrancy;

import com.google.gson.*;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.typho.vibrancy.light.AbstractPointLight;
import net.typho.vibrancy.light.BlockPointLight;
import org.joml.Vector3f;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public record DynamicLightInfo(Vector3f color, BlockStateFunction<Optional<Float>> radius, BlockStateFunction<Optional<Float>> brightness, BlockStateFunction<Optional<Float>> flicker, BlockStateFunction<Optional<class_243>> offset) {
    public static final Map<Predicate<class_2680>, Function<class_2680, DynamicLightInfo>> MAP = new LinkedHashMap<>();

    public static DynamicLightInfo get(class_2680 state) {
        return MAP.entrySet().stream()
                .filter(entry -> entry.getKey().test(state))
                .findAny()
                .map(entry -> entry.getValue().apply(state))
                .orElse(null);
    }

    public BlockPointLight createBlockLight(class_2338 pos, class_2680 state) {
        return (BlockPointLight) initLight(new BlockPointLight(
                pos
        ).setFlicker(flicker().apply(state).orElse(0f)), state);
    }

    public void addBlockLight(class_2338 pos, class_2680 state) {
        BlockPointLight old = Vibrancy.BLOCK_LIGHTS.get(pos);

        if (old == null) {
            Vibrancy.BLOCK_LIGHTS.put(pos, createBlockLight(pos, state));
        }
    }

    public <L extends AbstractPointLight> L initLight(L light, class_2680 state) {
        float b = brightness.apply(state).orElse(1f);
        light.setColor(color().mul(b, new Vector3f()))
                .setRadius(radius.apply(state).orElse((float) state.method_26213()));
        return light;
    }

    public static class Builder {
        public Vector3f color;
        public BlockStateFunction<Optional<Float>> radius = state -> Optional.empty(), brightness = state -> Optional.empty(), flicker = state -> Optional.empty();
        public BlockStateFunction<Optional<class_243>> offset = state -> Optional.empty();

        public Builder color(Vector3f color) {
            this.color = color;
            return this;
        }

        public Builder radius(BlockStateFunction<Optional<Float>> radius) {
            BlockStateFunction<Optional<Float>> radius1 = this.radius;
            this.radius = state -> radius.apply(state).or(() -> radius1.apply(state));
            return this;
        }

        public Builder brightness(BlockStateFunction<Optional<Float>> brightness) {
            BlockStateFunction<Optional<Float>> brightness1 = this.brightness;
            this.brightness = state -> brightness.apply(state).or(() -> brightness1.apply(state));
            return this;
        }

        public Builder flicker(BlockStateFunction<Optional<Float>> flicker) {
            BlockStateFunction<Optional<Float>> flicker1 = this.flicker;
            this.flicker = state -> flicker.apply(state).or(() -> flicker1.apply(state));
            return this;
        }

        public Builder offset(BlockStateFunction<Optional<class_243>> offset) {
            BlockStateFunction<Optional<class_243>> offset1 = this.offset;
            this.offset = state -> offset.apply(state).or(() -> offset1.apply(state));
            return this;
        }

        public Builder copy(DynamicLightInfo info) {
            return color(info.color)
                    .radius(info.radius)
                    .brightness(info.brightness)
                    .flicker(info.flicker)
                    .offset(info.offset);
        }

        public Builder then(class_2248 block, String key, JsonElement value) {
            return switch (key) {
                case "color" -> {
                    if (value.isJsonArray()) {
                        JsonArray array = value.getAsJsonArray();

                        if (array.size() != 3) {
                            throw new JsonParseException("Expected a 3-element array for color while parsing dynamic light info while parsing " + block + ", got " + array.size() + " elements");
                        }

                        yield color(new Vector3f(
                                array.get(0).getAsJsonPrimitive().getAsFloat(),
                                array.get(1).getAsJsonPrimitive().getAsFloat(),
                                array.get(2).getAsJsonPrimitive().getAsFloat()
                        ));
                    } else {
                        throw new JsonParseException("Expected a 3-element array for color while parsing dynamic light info while parsing " + block + ", got " + value);
                    }
                }
                case "offset" -> {
                    if (value.isJsonNull()) {
                        offset = state -> Optional.empty();
                        yield this;
                    } else if (value.isJsonObject() || value.isJsonArray()) {
                        yield offset(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonArray()) {
                                JsonArray array = json.getAsJsonArray();

                                if (array.size() != 3) {
                                    throw new JsonParseException("Expected a 3-element array for offset while parsing dynamic light info while parsing " + block + ", got " + array.size() + " elements");
                                }

                                return Optional.of(new class_243(
                                        array.get(0).getAsJsonPrimitive().getAsDouble(),
                                        array.get(1).getAsJsonPrimitive().getAsDouble(),
                                        array.get(2).getAsJsonPrimitive().getAsDouble()
                                ));
                            } else {
                                throw new JsonParseException("Expected a 3-element array for offset while parsing dynamic light info while parsing " + block + ", got " + json);
                            }
                        }, Optional::empty));
                    } else {
                        throw new JsonParseException("Expected a 3-element array for offset while parsing dynamic light info while parsing " + block + ", got " + value);
                    }
                }
                case "radius" -> {
                    if (value.isJsonNull()) {
                        radius = state -> Optional.empty();
                        yield this;
                    } else if (value.isJsonObject() || value.isJsonPrimitive()) {
                        yield radius(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonPrimitive()) {
                                return Optional.of(json.getAsJsonPrimitive().getAsFloat());
                            } else {
                                throw new JsonParseException("Expected a float for radius while parsing dynamic light info while parsing " + block + ", got " + json);
                            }
                        }, Optional::empty));
                    } else {
                        throw new JsonParseException("Expected a float for radius while parsing dynamic light info while parsing " + block + ", got " + value);
                    }
                }
                case "brightness" -> {
                    if (value.isJsonNull()) {
                        brightness = state -> Optional.empty();
                        yield this;
                    } else if (value.isJsonObject() || value.isJsonPrimitive()) {
                        yield brightness(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonPrimitive()) {
                                return Optional.of(json.getAsJsonPrimitive().getAsFloat());
                            } else {
                                throw new JsonParseException("Expected a float for brightness while parsing dynamic light info while parsing " + block + ", got " + json);
                            }
                        }, Optional::empty));
                    } else {
                        throw new JsonParseException("Expected a float for brightness while parsing dynamic light info while parsing " + block + ", got " + value);
                    }
                }
                case "flicker" -> {
                    if (value.isJsonNull()) {
                        flicker = state -> Optional.empty();
                        yield this;
                    } else if (value.isJsonObject() || value.isJsonPrimitive()) {
                        yield flicker(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonPrimitive()) {
                                return Optional.of(json.getAsJsonPrimitive().getAsFloat());
                            } else {
                                throw new JsonParseException("Expected a float for flicker while parsing dynamic light info while parsing " + block + ", got " + json);
                            }
                        }, Optional::empty));
                    } else {
                        throw new JsonParseException("Expected a float for flicker while parsing dynamic light info while parsing " + block + ", got " + value);
                    }
                }
                default -> this;
            };
        }

        public Builder load(class_2248 block, JsonElement json) {
            if (json.isJsonObject()) {
                JsonObject jsonObj = json.getAsJsonObject();

                JsonElement copy = jsonObj.get("copy");

                if (copy != null) {
                    if (copy.isJsonPrimitive()) {
                        JsonPrimitive primitive = copy.getAsJsonPrimitive();

                        if (primitive.isString()) {
                            String s = primitive.getAsString();

                            if (s.startsWith("#")) {
                                throw new IllegalArgumentException("Can't copy the dynamic light info of a tag (for technical reasons)");
                            }

                            copy(get(class_7923.field_41175.method_10223(class_2960.method_60654(s)).method_9564()));
                        } else {
                            throw new JsonParseException("Expected a string for copy while parsing dynamic light info for \"" + block + "\", got " + primitive);
                        }
                    } else {
                        throw new JsonParseException("Expected a string for copy while parsing dynamic light info for \"" + block + "\", got " + copy);
                    }
                }

                jsonObj.asMap().forEach((key1, value) -> then(block, key1, value));
                return this;
            } else if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();

                if (primitive.isString()) {
                    String s = primitive.getAsString();

                    if (s.startsWith("#")) {
                        throw new IllegalArgumentException("Can't copy the dynamic light info of a tag (for technical reasons)");
                    }

                    return copy(get(class_7923.field_41175.method_10223(class_2960.method_60654(s)).method_9564()));
                }
            }

            throw new JsonParseException("Expected either a string or object while parsing dynamic light info for \"" + block + "\", got " + json);
        }

        public DynamicLightInfo build() {
            return new DynamicLightInfo(color, radius, brightness, flicker, offset);
        }
    }
}
