package net.typho.vibrancy;

import com.google.common.collect.ImmutableList;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpact;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.caffeinemc.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import net.minecraft.class_2561;
import java.util.LinkedList;
import java.util.List;

public final class SodiumCompat {
    private SodiumCompat() {
    }

    public static OptionPage rtxPage(MinecraftOptionsStorage vanillaOpts) {
        List<OptionGroup> groups = new LinkedList<>();

        groups.add(OptionGroup.createBuilder()
                .add(OptionImpl.createBuilder(boolean.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.better_fog"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.better_fog.tooltip"))
                        .setControl(TickBoxControl::new)
                        .setBinding((opts, value) -> Vibrancy.BETTER_FOG.method_41748(value), opts -> Vibrancy.BETTER_FOG.method_41753())
                        .build())
                .add(OptionImpl.createBuilder(boolean.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.elytra_trails"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.elytra_trails.tooltip"))
                        .setControl(TickBoxControl::new)
                        .setBinding((opts, value) -> Vibrancy.ELYTRA_TRAILS.method_41748(value), opts -> Vibrancy.ELYTRA_TRAILS.method_41753())
                        .build())
                .build());

        groups.add(OptionGroup.createBuilder()
                .add(OptionImpl.createBuilder(boolean.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.transparency_test"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.transparency_test.tooltip"))
                        .setControl(TickBoxControl::new)
                        .setBinding((opts, value) -> Vibrancy.TRANSPARENCY_TEST.method_41748(value), opts -> Vibrancy.TRANSPARENCY_TEST.method_41753())
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.sky_shadow_distance"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.sky_shadow_distance.tooltip"))
                        .setControl(option -> new SliderControl(option, 1, 8, 1, v -> class_2561.method_43469("options.vibrancy.sky_shadow_distance.value", v)))
                        .setBinding((opts, value) -> Vibrancy.SKY_SHADOW_DISTANCE.method_41748(value), opts -> Vibrancy.SKY_SHADOW_DISTANCE.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.raytrace_distance"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.raytrace_distance.tooltip"))
                        .setControl(option -> new SliderControl(option, 1, 32, 1, v -> class_2561.method_43469("options.vibrancy.light_cull_distance.value", v * 16)))
                        .setBinding((opts, value) -> Vibrancy.RAYTRACE_DISTANCE.method_41748(value), opts -> Vibrancy.RAYTRACE_DISTANCE.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.light_cull_distance"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.light_cull_distance.tooltip"))
                        .setControl(option -> new SliderControl(option, 1, 32, 1, v -> class_2561.method_43469("options.vibrancy.light_cull_distance.value", v * 16)))
                        .setBinding((opts, value) -> Vibrancy.LIGHT_CULL_DISTANCE.method_41748(value), opts -> Vibrancy.LIGHT_CULL_DISTANCE.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.max_raytraced_lights"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.max_raytraced_lights.tooltip"))
                        .setControl(option -> new SliderControl(option, 5, 105, 5, v -> v > 100 ? class_2561.method_43471("options.vibrancy.max_raytraced_lights.max") : class_2561.method_43469("options.vibrancy.max_raytraced_lights.value", v)))
                        .setBinding((opts, value) -> Vibrancy.MAX_RAYTRACED_LIGHTS.method_41748(value), opts -> Vibrancy.MAX_RAYTRACED_LIGHTS.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.max_shadow_distance"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.max_shadow_distance.tooltip"))
                        .setControl(option -> new SliderControl(option, 1, 16, 1, v -> v > 15 ? class_2561.method_43471("options.vibrancy.max_shadow_distance.max") : class_2561.method_43469("options.vibrancy.max_shadow_distance.value", v)))
                        .setBinding((opts, value) -> Vibrancy.MAX_SHADOW_DISTANCE.method_41748(value), opts -> Vibrancy.MAX_SHADOW_DISTANCE.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .add(OptionImpl.createBuilder(int.class, vanillaOpts)
                        .setName(class_2561.method_43471("options.vibrancy.max_light_radius"))
                        .setTooltip(class_2561.method_43471("options.vibrancy.max_light_radius.tooltip"))
                        .setControl(option -> new SliderControl(option, 1, 16, 1, v -> v > 15 ? class_2561.method_43471("options.vibrancy.max_light_radius.max") : class_2561.method_43469("options.vibrancy.max_light_radius.value", v)))
                        .setBinding((opts, value) -> Vibrancy.MAX_LIGHT_RADIUS.method_41748(value), opts -> Vibrancy.MAX_LIGHT_RADIUS.method_41753())
                        .setImpact(OptionImpact.HIGH)
                        .build())
                .build());

        return new OptionPage(class_2561.method_43471("options.vibrancy.page"), ImmutableList.copyOf(groups));
    }
}
