package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3298;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7172;
import net.minecraft.class_742;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.typho.vibrancy.light.BlockPointLight;
import net.typho.vibrancy.light.EntityPointLight;
import net.typho.vibrancy.light.RaytracedLight;
import net.typho.vibrancy.light.SkyLight;
import org.joml.Vector3f;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

import static org.lwjgl.glfw.GLFW.*;
import static org.lwjgl.opengl.GL11.GL_COLOR_BUFFER_BIT;
import static org.lwjgl.opengl.GL11.glClear;

public class Vibrancy {
    public static final String MOD_ID = "vibrancy";

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static final class_7172<Boolean> TRANSPARENCY_TEST = class_7172.method_41749("options.vibrancy.transparency_test", value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.transparency_test.tooltip")), true);
    public static final class_7172<Boolean> BETTER_FOG = class_7172.method_41749("options.vibrancy.better_fog", value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.better_fog.tooltip")), true);
    public static final class_7172<Boolean> ELYTRA_TRAILS = class_7172.method_41749("options.vibrancy.elytra_trails", value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.elytra_trails.tooltip")), true);
    public static final class_7172<Integer> SKY_SHADOW_DISTANCE = new class_7172<>(
            "options.vibrancy.sky_shadow_distance",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.sky_shadow_distance.tooltip")),
            (text, value) -> class_315.method_41783(text, class_2561.method_43469("options.vibrancy.sky_shadow_distance.value", value)),
            new class_7172.class_7174(1, 8, false),
            4,
            value -> {}
    );public static final class_7172<Integer> RAYTRACE_DISTANCE = new class_7172<>(
            "options.vibrancy.raytrace_distance",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.raytrace_distance.tooltip")),
            (text, value) -> class_315.method_41783(text, class_2561.method_43469("options.vibrancy.raytrace_distance.value", value * 16)),
            new class_7172.class_7174(1, 32, false),
            16,
            value -> {}
    );
    public static final class_7172<Integer> LIGHT_CULL_DISTANCE = new class_7172<>(
            "options.vibrancy.light_cull_distance",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.light_cull_distance.tooltip")),
            (text, value) -> class_315.method_41783(text, class_2561.method_43469("options.vibrancy.light_cull_distance.value", value * 16)),
            new class_7172.class_7174(1, 32, false),
            32,
            value -> {}
    );
    public static final class_7172<Integer> MAX_RAYTRACED_LIGHTS = new class_7172<>(
            "options.vibrancy.max_raytraced_lights",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.max_raytraced_lights.tooltip")),
            (text, value) -> class_315.method_41783(text, value > 100 ? class_2561.method_43471("options.vibrancy.max_raytraced_lights.max") : class_2561.method_43469("options.vibrancy.max_raytraced_lights.value", value)),
            new class_7172.class_7174(5, 105, false),
            60,
            value -> {}
    );
    public static final class_7172<Integer> MAX_SHADOW_DISTANCE = new class_7172<>(
            "options.vibrancy.max_shadow_distance",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.max_shadow_distance.tooltip")),
            (text, value) -> class_315.method_41783(text, value > 15 ? class_2561.method_43471("options.vibrancy.max_shadow_distance.max") : class_2561.method_43469("options.vibrancy.max_shadow_distance.value", value)),
            new class_7172.class_7174(1, 16, false),
            6,
            value -> {}
    );
    public static final class_7172<Integer> MAX_LIGHT_RADIUS = new class_7172<>(
            "options.vibrancy.max_light_radius",
            value -> class_7919.method_47407(class_2561.method_43471("options.vibrancy.max_light_radius.tooltip")),
            (text, value) -> class_315.method_41783(text, value > 15 ? class_2561.method_43471("options.vibrancy.max_light_radius.max") : class_2561.method_43469("options.vibrancy.max_light_radius.value", value)),
            new class_7172.class_7174(1, 16, false),
            15,
            value -> {}
    );
    public static boolean DEBUG_SKY_LIGHT_VIEW = false, RENDER_SKY_LIGHT = true, RENDER_BLOCK_LIGHT = true, RENDER_ENTITY_LIGHT = true, SEEN_ALPHA_TEXT = false;
    public static Supplier<class_2400> STEAM;
    public static final Map<class_5321<class_2248>, BlockStateFunction<Boolean>> EMISSIVE_OVERRIDES = new LinkedHashMap<>();
    public static final Map<class_2338, BlockPointLight> BLOCK_LIGHTS = new LinkedHashMap<>();
    public static final Map<class_1309, EntityPointLight> ENTITY_LIGHTS = new LinkedHashMap<>();
    public static int NUM_LIGHT_TASKS = 0, NUM_RAYTRACED_LIGHTS = 0, NUM_VISIBLE_LIGHTS = 0, SHADOW_COUNT = 0;
    public static class_291 SCREEN_VBO;

    static {
        RenderSystem.recordRenderCall(() -> {
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27380, class_290.field_1592);
            builder.method_22912(-1, 1, 0);
            builder.method_22912(-1, -1, 0);
            builder.method_22912(1, 1, 0);
            builder.method_22912(1, -1, 0);

            SCREEN_VBO = new class_291(class_291.class_8555.field_44793);
            SCREEN_VBO.method_1353();
            SCREEN_VBO.method_1352(builder.method_60800());
            class_291.method_1354();
        });
    }

    public static int maxLights() {
        int v = MAX_RAYTRACED_LIGHTS.method_41753();
        return v > 100 ? Integer.MAX_VALUE : v;
    }

    public static int capShadowDistance(int distance) {
        int v = MAX_SHADOW_DISTANCE.method_41753();
        return v > 15 ? distance : Math.min(distance, v);
    }

    public static boolean shouldRenderLight(RaytracedLight light) {
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        boolean b = light.shouldRender(cam);

        if (b) {
            NUM_VISIBLE_LIGHTS++;
        }

        return b;
    }

    public static double getLightSortDistance(RaytracedLight light) {
        return light.getSortDistance();
    }

    public static void renderLight(RaytracedLight light, int[] cap) {
        boolean raytrace = cap[0] < Vibrancy.maxLights();

        if (light.render(raytrace)) {
            if (raytrace) {
                NUM_RAYTRACED_LIGHTS++;
            }

            cap[0]++;
        }
    }

    public static boolean pointsToward(class_2350 face, Vector3f offset) {
        class_2382 normal = face.method_10163();
        return new Vector3f(normal.method_10263(), normal.method_10264(), normal.method_10260()).dot(offset) > 0;
    }

    public static void elytraTrail(class_1309 entity) {
        if (Math.random() < Math.min(entity.method_18798().method_1033() - 0.75, (entity.method_23318() - 80) / 40)) {
            entity.method_37908().method_8406(STEAM.get(), entity.method_23317(), entity.method_23318(), entity.method_23321(), 0, 0, 0);
        }
    }

    public static void updateBlock(class_2338 pos, class_2680 state) {
        DynamicLightInfo info = DynamicLightInfo.get(state);

        if (info != null) {
            info.addBlockLight(pos, state);
        }
    }

    @SuppressWarnings("deprecation")
    public static void registerReloadListeners(class_3304 resourceManager) {
        resourceManager.method_14477((class_4013) manager -> {
            DynamicLightInfo.MAP.clear();

            for (class_3298 resource : manager.method_14489(id("dynamic_lights.json"))) {
                try (BufferedReader reader = resource.method_43039()) {
                    JsonParser.parseReader(reader).getAsJsonObject().asMap().forEach((key, value) -> {
                        if (key.startsWith("#")) {
                            class_6862<class_2248> tagKey = class_6862.method_40092(class_7924.field_41254, class_2960.method_60654(key.substring(1)));
                            DynamicLightInfo.MAP.put(state -> state.method_26164(tagKey), class_156.method_34866(state -> new DynamicLightInfo.Builder().load(state.method_26204().method_40142().comp_349(), value).build()));
                        } else {
                            class_5321<class_2248> regKey = class_5321.method_29179(class_7924.field_41254, class_2960.method_60654(key));
                            DynamicLightInfo info = new DynamicLightInfo.Builder().load(class_7923.field_41175.method_29107(regKey), value).build();
                            DynamicLightInfo.MAP.put(state -> state.method_54097(regKey), state -> info);
                        }
                    });
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            EMISSIVE_OVERRIDES.clear();

            for (class_3298 resource : manager.method_14489(id("emissive_blocks.json"))) {
                try (BufferedReader reader = resource.method_43039()) {
                    JsonParser.parseReader(reader).getAsJsonObject().asMap().forEach((key, value) -> {
                        class_5321<class_2248> regKey = class_5321.method_29179(class_7924.field_41254, class_2960.method_60654(key));
                        EMISSIVE_OVERRIDES.put(regKey, BlockStateFunction.parseJson(class_7923.field_41175.method_29107(regKey), value, JsonElement::getAsBoolean, () -> false));
                    });
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void onChunkLoad(class_2818 chunk) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkLoad(chunk.method_12004());
        }

        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b = new class_1923(light.blockPos).equals(chunk.method_12004());

            if (b) {
                light.free();
            }

            return b;
        });

        for (int i = chunk.method_32891(); i < chunk.method_31597(); i++) {
            class_2826 section = chunk.method_38259(chunk.method_31603(i));

            if (section.method_19523(state -> DynamicLightInfo.MAP.keySet()
                    .stream()
                    .anyMatch(p -> p.test(state)))) {
                class_2338 minPos = class_4076.method_18681(chunk.method_12004(), i).method_19767();

                for (int x = 0; x < 16; x++) {
                    for (int y = 0; y < 16; y++) {
                        for (int z = 0; z < 16; z++) {
                            class_2680 state = section.method_12254(x, y, z);
                            DynamicLightInfo info = DynamicLightInfo.get(state);

                            if (info != null) {
                                info.addBlockLight(new class_2338(x + minPos.method_10263(), y + minPos.method_10264(), z + minPos.method_10260()), state);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void onChunkUnload(class_2818 chunk) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkUnload(chunk.method_12004());
        }

        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b = new class_1923(light.blockPos).equals(chunk.method_12004());

            if (b) {
                light.free();
            }

            return b;
        });
    }

    public static void afterClientLevelChange(class_638 world) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.free();
        }

        if (world.method_27983().equals(class_1937.field_25179)) {
            SkyLight.INSTANCE = new SkyLight.Overworld();
            SkyLight.INSTANCE.markDirty();
        } else {
            SkyLight.INSTANCE = null;
        }

        BLOCK_LIGHTS.values().forEach(BlockPointLight::free);
        BLOCK_LIGHTS.clear();
        ENTITY_LIGHTS.values().forEach(EntityPointLight::free);
        ENTITY_LIGHTS.clear();

        for (class_742 player : world.method_18456()) {
            ENTITY_LIGHTS.put(player, new EntityPointLight(player));
        }
    }

    public static void render() {
        NUM_LIGHT_TASKS = 0;
        class_2960 id = id("ray_light");

        VeilRenderSystem.renderer().enableBuffers(id, DynamicBufferType.NORMAL, DynamicBufferType.ALBEDO, DynamicBufferType.LIGHT_UV);

        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(id).bind(true);
        RenderSystem.clearColor(0, 0, 0, 0);
        glClear(GL_COLOR_BUFFER_BIT);

        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b = light == null || light.shouldRemove();

            if (b && light != null) {
                light.free();
            }

            return b;
        });
        int[] cap = {0};
        NUM_RAYTRACED_LIGHTS = 0;
        NUM_VISIBLE_LIGHTS = 0;
        SHADOW_COUNT = 0;

        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.init();
            SkyLight.INSTANCE.updateDirty(RaytracedLight.DIRTY);
        }

        for (BlockPointLight light : BLOCK_LIGHTS.values()) {
            light.init();
            light.updateDirty(RaytracedLight.DIRTY);
        }

        for (EntityPointLight light : ENTITY_LIGHTS.values()) {
            light.init();
            light.updateDirty(RaytracedLight.DIRTY);
        }

        if (SkyLight.INSTANCE != null && RENDER_SKY_LIGHT) {
            renderLight(SkyLight.INSTANCE, cap);
        }

        if (RENDER_BLOCK_LIGHT) {
            ENTITY_LIGHTS.values().stream()
                    .sorted(Comparator.comparingDouble(Vibrancy::getLightSortDistance))
                    .filter(Vibrancy::shouldRenderLight)
                    .forEachOrdered(light -> renderLight(light, cap));
        }

        if (RENDER_ENTITY_LIGHT) {
            BLOCK_LIGHTS.values().stream()
                    .sorted(Comparator.comparingDouble(Vibrancy::getLightSortDistance))
                    .filter(Vibrancy::shouldRenderLight)
                    .forEachOrdered(light -> renderLight(light, cap));
        }

        RaytracedLight.DIRTY.clear();
    }

    public static boolean debugKey(int key) {
        switch (key) {
            case GLFW_KEY_9 -> {
                DEBUG_SKY_LIGHT_VIEW = !DEBUG_SKY_LIGHT_VIEW;
                class_310.method_1551().field_1724.method_7353(class_2561.method_43471("debug.vibrancy.sky_light_view"), false);
                return true;
            }
            case GLFW_KEY_8 -> {
                RENDER_SKY_LIGHT = !RENDER_SKY_LIGHT;
                class_310.method_1551().field_1724.method_7353(class_2561.method_43471("debug.vibrancy.render_sky_light"), false);
                return true;
            }
            case GLFW_KEY_7 -> {
                RENDER_BLOCK_LIGHT = !RENDER_BLOCK_LIGHT;
                class_310.method_1551().field_1724.method_7353(class_2561.method_43471("debug.vibrancy.render_block_light"), false);
                return true;
            }
            case GLFW_KEY_6 -> {
                RENDER_ENTITY_LIGHT = !RENDER_ENTITY_LIGHT;
                class_310.method_1551().field_1724.method_7353(class_2561.method_43471("debug.vibrancy.render_entity_light"), false);
                return true;
            }
        }

        return false;
    }

    public static void init() {
    }
}
