package net.typho.vibrancy.light;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

import static org.lwjgl.opengl.GL15.GL_STREAM_DRAW;

public abstract class AbstractMovingPointLight extends AbstractPointLight {
    protected boolean hasLight = false;
    protected Map<class_2338, List<Quad>> quads = new LinkedHashMap<>();
    protected final List<class_2338> dirty = new LinkedList<>();
    protected class_9380 quadBox;
    protected CompletableFuture<Map<class_2338, List<Quad>>> fullRebuildTask;

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_9380 box = getBox();

        for (class_2338 pos : it) {
            if (box.method_58244(pos)) {
                dirty.add(pos);
            }
        }
    }

    @Override
    protected void upload(class_287 builder, Collection<? extends IQuad> volumes) {
        if (volumes.isEmpty()) {
            anyShadows = false;
        } else {
            anyShadows = true;
            upload(builder, volumes, geomVBO, quadsSSBO, GL_STREAM_DRAW);
        }
    }

    protected void regenQuadsSync(class_638 world, class_2338 pos, Consumer<Quad> out, class_2338 lightBlockPos) {
        quads.remove(pos);
        regenQuadsAsync(world, pos, out, lightBlockPos);
    }

    protected void regenQuadsAsync(class_638 world, class_2338 pos, Consumer<Quad> out, class_2338 lightBlockPos) {
        getQuads(world, pos, out, pos.method_10262(lightBlockPos) <= 4, lightBlockPos, false, dir -> true);
    }

    protected void regenAll(class_638 world, class_9380 box, class_2338 lightBlockPos) {
        fullRebuildTask = CompletableFuture.supplyAsync(() -> {
            Map<class_2338, List<Quad>> quads = new LinkedHashMap<>();

            for (int x = box.comp_2466().method_10263(); x <= box.comp_2467().method_10263(); x++) {
                for (int y = box.comp_2466().method_10264(); y <= box.comp_2467().method_10264(); y++) {
                    for (int z = box.comp_2466().method_10260(); z <= box.comp_2467().method_10260(); z++) {
                        class_2338 pos = new class_2338(x, y, z);
                        List<Quad> existing = this.quads.get(pos);

                        if (existing != null && !existing.isEmpty()) {
                            quads.put(pos, existing);
                        } else {
                            List<Quad> list = new LinkedList<>();
                            regenQuadsAsync(world, pos, list::add, lightBlockPos);

                            if (!list.isEmpty()) {
                                quads.put(pos, list);
                            }
                        }
                    }
                }
            }

            return quads;
        });
    }

    @Override
    public void init() {
    }

    public abstract boolean shouldRegenAll();

    @Override
    public boolean render(boolean raytrace) {
        class_638 world = class_310.method_1551().field_1687;

        if (world != null) {
            class_2338 lightBlockPos = new class_2338((int) Math.floor(getPosition().x), (int) Math.floor(getPosition().y), (int) Math.floor(getPosition().z));
            Vector3f lightPos = new Vector3f(getPosition().x, getPosition().y, getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int) Math.ceil(radius) - 2);
            class_9380 box = getBox();

            List<ShadowVolume> volumes = new LinkedList<>();
            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);

            if (isVisible()) {
                if (fullRebuildTask != null && fullRebuildTask.isDone()) {
                    try {
                        quads = fullRebuildTask.get();
                        fullRebuildTask = null;
                    } catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                } else if (hasLight) {
                    if (quadBox == null || shouldRegenAll()) {
                        dirty.clear();
                        regenAll(world, blockRadius > 1 ? new class_9380(
                                new class_2338(box.comp_2466().method_10263() - blockRadius, box.comp_2466().method_10264() - blockRadius, box.comp_2466().method_10260() - blockRadius),
                                new class_2338(box.comp_2467().method_10263() + blockRadius, box.comp_2467().method_10264() + blockRadius, box.comp_2467().method_10260() + blockRadius)
                        ) : box, lightBlockPos);
                        quadBox = box;
                    } else if (!dirty.isEmpty()) {
                        for (class_2338 pos : dirty) {
                            List<Quad> list = new LinkedList<>();
                            regenQuadsSync(world, pos, list::add, lightBlockPos);

                            for (class_2350 dir : class_2350.values()) {
                                regenQuadsSync(world, pos.method_10093(dir), list::add, lightBlockPos);
                            }

                            if (!list.isEmpty()) {
                                quads.put(pos, list);
                            } else {
                                quads.remove(pos);
                            }
                        }
                    }
                }

                quads.forEach((pos, list) -> {
                    if (box.method_58244(pos)) {
                        for (Quad quad : list) {
                            ShadowVolume volume = quad.toVolumeSphere(lightPos, radius);
                            volume.render(builder);
                            volumes.add(volume);
                        }
                    }
                });

                upload(builder, volumes);

                shadowCount = volumes.size();

                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f view = new Matrix4f()
                        .rotate(camera.method_23767().invert(new Quaternionf()))
                        .translate((float) -camera.method_19326().field_1352, (float) -camera.method_19326().field_1351, (float) -camera.method_19326().field_1350);

                renderMask(raytrace, lightPos, view);
                renderLight(lightPos, view);

                return true;
            }
        }

        return false;
    }
}
