package net.typho.vibrancy.light;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.Vibrancy;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

import static org.lwjgl.opengl.GL15.*;
import static org.lwjgl.opengl.GL30.glBindBufferBase;
import static org.lwjgl.opengl.GL43.GL_SHADER_STORAGE_BUFFER;

public abstract class AbstractPointLight implements RaytracedLight {
    protected final class_291 geomVBO = new class_291(class_291.class_8555.field_44793), boxVBO = new class_291(class_291.class_8555.field_44793);
    protected final int quadsSSBO = glGenBuffers();
    protected int shadowCount = 0;
    protected boolean anyShadows = false;
    protected float flicker = 0, flickerMin, flickerMax, flickerStart = (float) GLFW.glfwGetTime(), radius = 15;
    protected boolean isDirty = true;
    protected Vector3f color, position = new Vector3f();

    public void markDirty() {
        isDirty = true;
    }

    public void clean() {
        isDirty = false;
    }

    public boolean isDirty() {
        return isDirty;
    }

    public @NotNull Vector3f getPosition() {
        return position;
    }

    public float getFlicker() {
        return flicker;
    }

    public AbstractPointLight setFlicker(float flicker) {
        this.flicker = flicker;
        markDirty();
        return this;
    }

    public float getRadius() {
        return radius;
    }

    public AbstractPointLight setRadius(float radius) {
        this.radius = radius;
        markDirty();
        return this;
    }

    public Vector3f getColor() {
        return color;
    }

    public AbstractPointLight setColor(Vector3f color) {
        this.color = color;
        markDirty();
        return this;
    }

    @Override
    public double getSortDistance(class_243 cam) {
        return position.distanceSquared((float) cam.field_1352, (float) cam.field_1351, (float) cam.field_1350);
    }

    @Override
    public boolean shouldRender(class_243 cam) {
        return position.distanceSquared((float) cam.field_1352, (float) cam.field_1351, (float) cam.field_1350) / 16 < Vibrancy.LIGHT_CULL_DISTANCE.method_41753() * Vibrancy.LIGHT_CULL_DISTANCE.method_41753() && RaytracedLight.super.shouldRender(cam);
    }

    protected void getVolumes(class_638 world, class_2338 pos, Consumer<ShadowVolume> out, double sqDist, class_2338 lightBlockPos, Vector3f lightPos, float radius) {
        getQuads(world, pos, quad -> out.accept(quad.toVolumeSphere(lightPos, radius)), sqDist <= 4, lightBlockPos, true, dir -> true);
    }

    protected void upload(class_287 builder, Collection<? extends IQuad> volumes) {
        if (volumes.isEmpty()) {
            anyShadows = false;
        } else {
            anyShadows = true;
            upload(builder, volumes, geomVBO, quadsSSBO, GL_STATIC_DRAW);
        }
    }

    public class_9380 getBox() {
        class_2338 lightBlockPos = new class_2338((int) Math.floor(position.x), (int) Math.floor(position.y), (int) Math.floor(position.z));
        int blockRadius = Vibrancy.capShadowDistance((int) Math.ceil(radius) - 2);
        class_9380 box = class_9380.method_58236(lightBlockPos);

        if (blockRadius > 1) {
            box = new class_9380(
                    new class_2338(box.comp_2466().method_10263() - blockRadius, box.comp_2466().method_10264() - blockRadius, box.comp_2466().method_10260() - blockRadius),
                    new class_2338(box.comp_2467().method_10263() + blockRadius, box.comp_2467().method_10264() + blockRadius, box.comp_2467().method_10260() + blockRadius)
            );
        }

        return box;
    }

    protected void renderMask(boolean raytrace, Vector3f lightPos, Matrix4f view) {
        AdvancedFbo fbo = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask")));
        fbo.bind(true);
        glClearColor(0f, 0f, 0f, 0f);
        glClearStencil(0);
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

        if (anyShadows && raytrace) {
            glEnable(GL_STENCIL_TEST);
            glStencilMask(0xFF);
            glStencilFunc(GL_ALWAYS, 1, 0xFF);
            glStencilOp(GL_KEEP, GL_KEEP, GL_REPLACE);

            class_1921 stencilType = VeilRenderType.get(Vibrancy.id("point_stencil"));
            stencilType.method_23516();

            class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());

            shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
            shader.method_35785("LightRadius").method_1251(radius);

            Vibrancy.SCREEN_VBO.method_1353();
            Vibrancy.SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();

            stencilType.method_23518();

            class_1921 type = VeilRenderType.get(Vibrancy.id("point_shadow"));
            type.method_23516();

            glEnable(GL_STENCIL_TEST);
            glStencilMask(0xFF);
            glStencilFunc(GL_EQUAL, 1, 0xFF);
            glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

            shader = Objects.requireNonNull(RenderSystem.getShader());

            shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
            shader.method_35785("LightRadius").method_1251(radius);

            glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 0, quadsSSBO);

            shader.method_34583("AtlasSampler", class_310.method_1551().method_1554().method_24153(class_1723.field_21668));

            geomVBO.method_1353();
            geomVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();

            glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 0, 0);

            type.method_23518();
            glDisable(GL_STENCIL_TEST);

            Vibrancy.SHADOW_COUNT += shadowCount;
        }
    }

    protected void renderLight(Vector3f lightPos, Matrix4f view) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
        VeilRenderSystem.setShader(Vibrancy.id("light/ray/point"));
        class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());

        float time = (float) GLFW.glfwGetTime();

        while (time - flickerStart > 0.25) {
            flickerStart += 0.25f;
            flickerMin = flickerMax;
            flickerMax = new java.util.Random().nextFloat(-1, 1);
        }

        float brightness = (1 + flicker * class_3532.method_16439((time - flickerStart) * 4, flickerMin, flickerMax));

        shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
        shader.method_35785("LightColor").method_1249(color.x * brightness, color.y * brightness, color.z * brightness);
        shader.method_35785("LightRadius").method_1251(radius);
        shader.method_35785("AnyShadows").method_35649(anyShadows ? 1 : 0);

        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        class_238 box = getBoundingBox();
        Vector3f[] vertices = {
                new Vector3f((float) box.field_1320, (float) box.field_1325, (float) box.field_1324),
                new Vector3f((float) box.field_1323, (float) box.field_1325, (float) box.field_1324),
                new Vector3f((float) box.field_1323, (float) box.field_1322, (float) box.field_1324),
                new Vector3f((float) box.field_1320, (float) box.field_1322, (float) box.field_1324),
                new Vector3f((float) box.field_1320, (float) box.field_1325, (float) box.field_1321),
                new Vector3f((float) box.field_1323, (float) box.field_1325, (float) box.field_1321),
                new Vector3f((float) box.field_1323, (float) box.field_1322, (float) box.field_1321),
                new Vector3f((float) box.field_1320, (float) box.field_1322, (float) box.field_1321),
        };

        builder.method_60830(vertices[0])
                .method_60830(vertices[1])
                .method_60830(vertices[2])
                .method_60830(vertices[3]);

        builder.method_60830(vertices[1])
                .method_60830(vertices[5])
                .method_60830(vertices[6])
                .method_60830(vertices[2]);

        builder.method_60830(vertices[5])
                .method_60830(vertices[4])
                .method_60830(vertices[7])
                .method_60830(vertices[6]);

        builder.method_60830(vertices[4])
                .method_60830(vertices[0])
                .method_60830(vertices[3])
                .method_60830(vertices[7]);

        builder.method_60830(vertices[1])
                .method_60830(vertices[0])
                .method_60830(vertices[4])
                .method_60830(vertices[5]);

        builder.method_60830(vertices[3])
                .method_60830(vertices[2])
                .method_60830(vertices[6])
                .method_60830(vertices[7]);

        RenderSystem.disableDepthTest();
        glCullFace(GL_FRONT);
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.class_4535.ONE, GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation(GL_FUNC_ADD);

        boxVBO.method_1353();
        boxVBO.method_1352(builder.method_60794());
        boxVBO.method_34427(view, RenderSystem.getProjectionMatrix(), shader);
        class_291.method_1354();

        glCullFace(GL_BACK);
        RenderSystem.disableBlend();
    }

    @Override
    public @NotNull class_238 getBoundingBox() {
        return new class_238(
                position.x - radius, position.y - radius, position.z - radius,
                position.x + radius, position.y + radius, position.z + radius
        );
    }

    @Override
    public void free() {
        geomVBO.close();
        glDeleteBuffers(quadsSSBO);
    }
}
