package net.typho.vibrancy.light;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class BlockPointLight extends AbstractPointLight {
    protected final List<class_2338> dirty = new LinkedList<>();
    protected List<ShadowVolume> volumes = new LinkedList<>();
    protected CompletableFuture<List<ShadowVolume>> fullRebuildTask;
    public final class_2338 blockPos;
    protected boolean render = false;

    public BlockPointLight(class_2338 blockPos) {
        this.blockPos = blockPos;
        markDirty();
    }

    public void regenQuads(class_638 world, class_2338 pos, Consumer<ShadowVolume> out, class_2338 lightBlockPos, Vector3f lightPos) {
        volumes.removeIf(v -> v.caster().blockPos().equals(pos));
        getVolumes(world, pos, out, pos.method_10262(lightBlockPos), lightBlockPos, lightPos, radius);
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_9380 box = getBox();

        for (class_2338 pos : it) {
            if (box.method_58244(pos)) {
                dirty.add(pos);
            }
        }
    }

    @Override
    public void init() {
        render = false;

        boolean dirty = isDirty;

        class_638 world = class_310.method_1551().field_1687;

        if (world != null) {
            class_2680 state = world.method_8320(blockPos);
            DynamicLightInfo info = DynamicLightInfo.get(state);

            if (info != null) {
                class_243 offset = info.offset().apply(state).orElse(new class_243(0.5, 0.5, 0.5));
                position.set(blockPos.method_10263() + offset.field_1352, blockPos.method_10264() + offset.field_1351, blockPos.method_10260() + offset.field_1350);
                info.initLight(this, state);
                render = true;
            }
        }

        isDirty = dirty;
    }

    @Override
    public boolean render(boolean raytrace) {
        if (!render) {
            return false;
        }

        class_638 world = class_310.method_1551().field_1687;

        if (world != null) {
            class_2338 lightBlockPos = new class_2338((int) Math.floor(getPosition().x), (int) Math.floor(getPosition().y), (int) Math.floor(getPosition().z));
            Vector3f lightPos = new Vector3f(getPosition().x, getPosition().y, getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int) Math.ceil(radius) - 2);
            class_9380 box = getBox();

            if (fullRebuildTask != null) {
                Vibrancy.NUM_LIGHT_TASKS++;
            }

            if (!dirty.isEmpty()) {
                for (class_2338 pos : dirty) {
                    if (!pos.equals(lightBlockPos)) {
                        regenQuads(world, pos, volumes::add, lightBlockPos, lightPos);
                    }

                    for (class_2350 dir : class_2350.values()) {
                        class_2338 pos1 = pos.method_10093(dir);

                        if (!pos1.equals(lightBlockPos)) {
                            regenQuads(world, pos1, volumes::add, lightBlockPos, lightPos);
                        }
                    }
                }

                dirty.clear();

                class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);

                for (ShadowVolume volume : volumes) {
                    volume.render(builder);
                }

                upload(builder, volumes);

                shadowCount = volumes.size();
            }

            if (fullRebuildTask != null && fullRebuildTask.isDone()) {
                try {
                    volumes = fullRebuildTask.get();
                    fullRebuildTask = null;
                    class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);

                    for (ShadowVolume volume : volumes) {
                        volume.render(builder);
                    }

                    upload(builder, volumes);

                    shadowCount = volumes.size();
                } catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace) {
                if (blockRadius < 1) {
                    raytrace = false;
                } else {
                    if (isDirty()) {
                        clean();
                        fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                            List<ShadowVolume> volumes = new LinkedList<>();

                            for (int x = box.comp_2466().method_10263(); x <= box.comp_2467().method_10263(); x++) {
                                for (int y = box.comp_2466().method_10264(); y <= box.comp_2467().method_10264(); y++) {
                                    for (int z = box.comp_2466().method_10260(); z <= box.comp_2467().method_10260(); z++) {
                                        class_2338 pos = new class_2338(x, y, z);

                                        if (!pos.equals(lightBlockPos)) {
                                            double sqDist = pos.method_10262(lightBlockPos);

                                            if (sqDist != 0 && sqDist < blockRadius * blockRadius) {
                                                getVolumes(world, pos, volumes::add, sqDist, lightBlockPos, lightPos, radius);
                                            }
                                        }
                                    }
                                }
                            }

                            return volumes;
                        });
                    }
                }
            }

            if (isVisible()) {
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f view = new Matrix4f()
                        .rotate(camera.method_23767().invert(new Quaternionf()))
                        .translate((float) -camera.method_19326().field_1352, (float) -camera.method_19326().field_1351, (float) -camera.method_19326().field_1350);

                renderMask(raytrace, lightPos, view);
                renderLight(lightPos, view);

                return true;
            }
        }

        return false;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260() + "]";
    }
}
