package net.typho.vibrancy.light;

import net.minecraft.class_1011;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.mixin.LightTextureAccessor;

import java.awt.*;

public class EntityPointLight extends AbstractMovingPointLight {
    public final class_1309 entity;

    public EntityPointLight(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    public boolean shouldRemove() {
        return entity.method_31481();
    }

    @Override
    public boolean shouldRender(class_243 cam) {
        return super.shouldRender(cam) || entity == class_310.method_1551().field_1719;
    }

    @Override
    public void init() {
        float tickDelta = class_310.method_1551().method_60646().method_60637(true);
        class_243 entityPos = entity.method_5836(tickDelta)
                .method_1019(entity.method_5828(tickDelta));
        position.set(entityPos.field_1352, entityPos.field_1351, entityPos.field_1350);
    }

    @Override
    public boolean shouldRegenAll() {
        return !quadBox.method_58244(entity.method_24515());
    }

    public boolean init(class_1799 stack) {
        if (stack.method_7909() instanceof class_1747 block) {
            class_2680 state = block.method_7711().method_9564();
            DynamicLightInfo info = DynamicLightInfo.get(state);

            if (info != null) {
                info.initLight(this, state);

                class_1011 lightmap = ((LightTextureAccessor) class_310.method_1551().field_1773.method_22974()).getLightPixels();
                Color color = new Color(lightmap.method_4315(15, 0));
                this.color.add(color.getRed() / 255f, color.getGreen() / 255f, color.getBlue() / 255f);

                hasLight = true;
                return true;
            }
        }

        return false;
    }

    @Override
    public boolean render(boolean raytrace) {
        if (!(init(entity.method_6047()) || init(entity.method_6079()))) {
            return false;
        }

        return super.render(raytrace);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + entity + "]";
    }
}
