package net.typho.vibrancy.light;

import foundry.veil.api.client.render.VeilRenderSystem;
import net.minecraft.class_1087;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_9801;
import net.typho.vibrancy.Vibrancy;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

import static org.lwjgl.opengl.GL15.glBindBuffer;
import static org.lwjgl.opengl.GL15.glBufferData;
import static org.lwjgl.opengl.GL43.GL_SHADER_STORAGE_BUFFER;

public interface RaytracedLight extends NativeResource {
    Set<class_2338> DIRTY = new HashSet<>();

    default boolean isVisible() {
        return true;
    }

    void updateDirty(Iterable<class_2338> it);

    void init();

    boolean render(boolean raytrace);

    default boolean shouldRemove() {
        return false;
    }

    default boolean shouldRender(class_243 cam) {
        class_238 box = getBoundingBox();

        if (box == null) {
            return true;
        }

        return VeilRenderSystem.getCullingFrustum().testAab(box);
    }

    default double getSortDistance() {
        return getSortDistance(class_310.method_1551().field_1773.method_19418().method_19326());
    }

    default double getSortDistance(class_243 cam) {
        return 0;
    }

    default @Nullable class_238 getBoundingBox() {
        return null;
    }

    default void getQuads(Iterable<class_777> bakedQuads, class_2338 pos, Consumer<Quad> out, class_243 offset, @Nullable class_2350 direction) {
        for (class_777 quad : bakedQuads) {
            Vector3f[] positions = new Vector3f[4];
            Vector2f[] uvs = new Vector2f[4];

            int[] data = quad.method_3357();
            int len = data.length / 8;

            for (int i = 0, j = 0; i < len; i++, j += 8) {
                positions[i] = new Vector3f(
                        Float.intBitsToFloat(data[j]) + pos.method_10263() + (float) offset.field_1352,
                        Float.intBitsToFloat(data[j + 1]) + pos.method_10264() + (float) offset.field_1351,
                        Float.intBitsToFloat(data[j + 2]) + pos.method_10260() + (float) offset.field_1350
                );
                uvs[i] = new Vector2f(
                        Float.intBitsToFloat(data[j + 4]),
                        Float.intBitsToFloat(data[j + 5])
                );
            }

            out.accept(new Quad(
                    pos,
                    direction,
                    positions[0],
                    positions[1],
                    positions[2],
                    positions[3],
                    uvs[0],
                    uvs[1],
                    uvs[2],
                    uvs[3]
            ));
        }
    }

    default void getQuads(class_638 world, class_2338 pos, Consumer<Quad> out, boolean close, class_2338 blockPos, boolean normalTest, Predicate<class_2350> predicate) {
        getQuads(world, pos, out, close, new Vector3f(pos.method_10263() - blockPos.method_10263(), pos.method_10264() - blockPos.method_10264(), pos.method_10260() - blockPos.method_10260()), normalTest, predicate);
    }

    default void getQuads(class_638 world, class_2338 pos, Consumer<Quad> out, boolean close, Vector3f lightDirection, boolean normalTest, Predicate<@Nullable class_2350> predicate) {
        class_2680 state = world.method_8320(pos);

        if (!Vibrancy.TRANSPARENCY_TEST.method_41753() && state.method_26167(world, pos)) {
            return;
        }

        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        class_5819 random = class_5819.method_43047();
        class_243 offset = state.method_26226(world, pos);

        for (class_2350 direction : class_2350.values()) {
            if (predicate.test(direction) && (close || (class_2248.method_9607(state, world, pos, direction, pos.method_10093(direction)) && (!normalTest || Vibrancy.pointsToward(direction, lightDirection))))) {
                getQuads(model.method_4707(state, direction, random), pos, out, offset, direction);
            }
        }

        if (predicate.test(null)) {
            getQuads(model.method_4707(state, null, random), pos, out, offset, null);
        }
    }

    default void upload(class_287 builder, Collection<? extends IQuad> quads, class_291 geomVBO, int quadsSSBO, int usage) {
        class_9801 mesh = builder.method_60794();

        if (mesh == null) {
            return;
        }

        geomVBO.method_1353();
        geomVBO.method_1352(mesh);
        class_291.method_1354();

        ByteBuffer buf = MemoryUtil.memAlloc(quads.size() * Quad.BYTES);

        for (IQuad quad : quads) {
            quad.toQuad().put(buf);
        }

        glBindBuffer(GL_SHADER_STORAGE_BUFFER, quadsSSBO);
        glBufferData(GL_SHADER_STORAGE_BUFFER, buf.flip(), usage);
        glBindBuffer(GL_SHADER_STORAGE_BUFFER, 0);

        MemoryUtil.memFree(buf);
    }

    interface IQuad {
        Quad toQuad();
    }

    record Quad(
            class_2338 blockPos, @Nullable class_2350 direction, @Nullable class_2338 relative,
            Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4,
            Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4,
            Vector3f n, float d,
            Vector3f e1, Vector3f e2
    ) implements IQuad {
        public static final int BYTES = 40 * Float.BYTES;

        public Quad(class_2338 blockPos, @Nullable class_2350 direction, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4,
                    Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4) {
            this(
                    blockPos, direction, direction == null ? null : blockPos.method_10093(direction),
                    v1, v2, v3, v4, uv1, uv2, uv3, uv4,
                    new Vector3f(v2).sub(v1).cross(new Vector3f(v4).sub(v1)).normalize(),
                    new Vector3f(v2).sub(v1).cross(new Vector3f(v4).sub(v1)).normalize().dot(v1),
                    new Vector3f(v2).sub(v1),
                    new Vector3f(v4).sub(v1)
            );
        }

        @Override
        public Quad toQuad() {
            return this;
        }

        public void put(ByteBuffer buf) {
            buf.putFloat(v1.x).putFloat(v1.y).putFloat(v1.z).putFloat(0);
            buf.putFloat(v2.x).putFloat(v2.y).putFloat(v2.z).putFloat(0);
            buf.putFloat(v3.x).putFloat(v3.y).putFloat(v3.z).putFloat(0);
            buf.putFloat(v4.x).putFloat(v4.y).putFloat(v4.z).putFloat(0);

            buf.putFloat(uv1.x).putFloat(uv1.y);
            buf.putFloat(uv2.x).putFloat(uv2.y);
            buf.putFloat(uv3.x).putFloat(uv3.y);
            buf.putFloat(uv4.x).putFloat(uv4.y);

            buf.putFloat(n.x).putFloat(n.y).putFloat(n.z).putFloat(d);
            buf.putFloat(e1.x).putFloat(e1.y).putFloat(e1.z).putFloat(e1.dot(e1));
            buf.putFloat(e2.x).putFloat(e2.y).putFloat(e2.z).putFloat(e2.dot(e2));

            float d11 = e1.dot(e1);
            float d12 = e1.dot(e2);
            float d22 = e2.dot(e2);
            float invDet = 1.0f / (d11 * d22 - d12 * d12);

            float inv11 =  d22 * invDet;
            float inv12 = -d12 * invDet;
            float inv21 = -d12 * invDet;
            float inv22 =  d11 * invDet;

            buf.putFloat(inv11).putFloat(inv12).putFloat(inv21).putFloat(inv22);
        }

        public ShadowVolume toVolumeSphere(Vector3f origin, float radius) {
            float d0 = n.dot(v1.sub(origin, new Vector3f()));
            float t = radius - d0;

            Vector3f[] vertices = {v1, v2, v3, v4, null, null, null, null};

            for (int i = 0; i < 4; i++) {
                Vector3f vertex = new Vector3f(vertices[i]);
                Vector3f off = vertex.sub(origin, new Vector3f());
                vertices[i + 4] = vertex.add(off.normalize(t));
            }

            return new ShadowVolume(
                    this,
                    vertices
            );
        }

        public ShadowVolume toVolumeSky(Vector3f direction, float distance) {
            Vector3f add = direction.mul(-distance, new Vector3f());
            Vector3f[] vertices = {v1, v2, v3, v4, null, null, null, null};

            for (int i = 0; i < 4; i++) {
                vertices[i + 4] = new Vector3f(vertices[i]).add(add);
            }

            return new ShadowVolume(
                    this,
                    vertices
            );
        }
    }

    record ShadowVolume(Quad caster, Vector3f[] vertices) implements IQuad {
        @Override
        public Quad toQuad() {
            return caster;
        }

        public void render(class_4588 consumer) {
            consumer.method_60830(vertices()[0])
                    .method_60830(vertices()[1])
                    .method_60830(vertices()[2])
                    .method_60830(vertices()[3]);

            consumer.method_60830(vertices()[1])
                    .method_60830(vertices()[5])
                    .method_60830(vertices()[6])
                    .method_60830(vertices()[2]);

            consumer.method_60830(vertices()[5])
                    .method_60830(vertices()[4])
                    .method_60830(vertices()[7])
                    .method_60830(vertices()[6]);

            consumer.method_60830(vertices()[4])
                    .method_60830(vertices()[0])
                    .method_60830(vertices()[3])
                    .method_60830(vertices()[7]);

            consumer.method_60830(vertices()[1])
                    .method_60830(vertices()[0])
                    .method_60830(vertices()[4])
                    .method_60830(vertices()[5]);

            consumer.method_60830(vertices()[3])
                    .method_60830(vertices()[2])
                    .method_60830(vertices()[6])
                    .method_60830(vertices()[7]);
        }
    }
}
