package net.typho.vibrancy.light;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.mixin.LightTextureAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.lwjgl.system.NativeResource;

import java.awt.*;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

import static org.lwjgl.opengl.GL11.*;
import static org.lwjgl.opengl.GL14.GL_FUNC_ADD;
import static org.lwjgl.opengl.GL15.*;
import static org.lwjgl.opengl.GL30.glBindBufferBase;
import static org.lwjgl.opengl.GL43.GL_SHADER_STORAGE_BUFFER;

public abstract class SkyLight implements RaytracedLight {
    protected class Chunk implements NativeResource {
        protected final class_291 vbo = new class_291(class_291.class_8555.field_44793);
        protected final int ssbo = glGenBuffers();
        protected final List<class_2338> dirty = new LinkedList<>();
        protected List<Quad> quads = new LinkedList<>();
        protected CompletableFuture<List<Quad>> fullRebuildTask;
        protected final class_1923 pos;
        protected boolean isDirty = true, render = false;
        protected int shadowCount = 0;
        protected class_9380 box;

        public void markDirty() {
            isDirty = true;
        }

        public void clean() {
            isDirty = false;
        }

        public boolean isDirty() {
            return isDirty;
        }

        protected Chunk(class_1923 pos) {
            this.pos = pos;
        }

        @Override
        public void free() {
            vbo.close();
            glDeleteBuffers(ssbo);
        }

        protected void upload(class_287 builder, Collection<? extends IQuad> volumes) {
            SkyLight.this.upload(builder, volumes, vbo, ssbo, GL_STATIC_DRAW);

            shadowCount = volumes.size();
        }

        protected void regenQuads(class_638 level, class_2338 pos, Consumer<Quad> out) {
            quads.removeIf(quad -> quad.blockPos().equals(pos));

            if (shouldCastBlock(level, pos)) {
                getQuads(level, pos, out, false, direction, false, dir -> true);
            }
        }

        protected void init(class_638 level, boolean raytrace) {
            if (fullRebuildTask != null) {
                Vibrancy.NUM_LIGHT_TASKS++;
            }

            for (class_2338 pos : dirty) {
                regenQuads(level, pos, quads::add);

                for (class_2350 dir : class_2350.values()) {
                    regenQuads(level, pos.method_10093(dir), quads::add);
                }
            }

            dirty.clear();

            if (fullRebuildTask != null && fullRebuildTask.isDone()) {
                try {
                    quads = fullRebuildTask.get();
                    fullRebuildTask = null;
                } catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace && (isDirty() || SkyLight.this.isDirty())) {
                if (isDirty()) {
                    clean();
                }

                fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                    List<Quad> quads = new LinkedList<>();

                    if (level.method_8393(pos.field_9181, pos.field_9180)) {
                        class_2818 chunk = level.method_8497(pos.field_9181, pos.field_9180);

                        for (int i = chunk.method_32891(); i < chunk.method_31597(); i++) {
                            class_2826 section = chunk.method_38259(chunk.method_31603(i));
                            class_2338 minPos = class_4076.method_18681(chunk.method_12004(), i).method_19767();

                            for (int x = 0; x < 16; x++) {
                                for (int y = 0; y < 16; y++) {
                                    for (int z = 0; z < 16; z++) {
                                        class_2338 blockPos = new class_2338(minPos.method_10263() + x, minPos.method_10264() + y, minPos.method_10260() + z);

                                        if (shouldCastBlock(level, blockPos)) {
                                            class_2680 state = section.method_12254(x, y, z);

                                            class_1087 model = class_310.method_1551().method_1541().method_3349(state);
                                            class_5819 random = class_5819.method_43047();
                                            class_243 offset = state.method_26226(level, blockPos);

                                            for (class_2350 direction : class_2350.values()) {
                                                if (state.method_26204() instanceof class_2397 ? level.method_8320(blockPos.method_10093(direction)).method_26215() : class_2248.method_9607(state, level, blockPos, direction, blockPos.method_10093(direction))) {
                                                    getQuads(model.method_4707(state, direction, random), blockPos, quads::add, offset, direction);
                                                }
                                            }

                                            getQuads(model.method_4707(state, null, random), blockPos, quads::add, offset, null);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    return quads;
                });
            }

            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);

            List<Quad> newQuads = new LinkedList<>();

            quads.removeIf(quad -> {
                if (quad.relative() != null && level.method_8314(class_1944.field_9284, quad.relative()) == 0) {
                    return true;
                }

                if (quad.direction() == null || Vibrancy.pointsToward(quad.direction(), direction)) {
                    quad.toVolumeSky(direction, distance).render(builder);
                    newQuads.add(quad);
                }

                return false;
            });

            upload(builder, newQuads);
        }

        protected void renderMask(Matrix4f view) {
            if (shadowCount == 0 || !render) {
                return;
            }

            box = null;

            for (Quad quad : quads) {
                if (box == null) {
                    box = class_9380.method_58236(quad.blockPos());
                } else {
                    box = box.method_58241(quad.blockPos());
                }
            }

            if (box == null) {
                return;
            }

            /*
            RenderType stencilType = VeilRenderType.get(Vibrancy.id("sky_stencil_node"));
            stencilType.setupRenderState();

            glEnable(GL_STENCIL_TEST);
            glStencilMask(2);
            glStencilFunc(GL_ALWAYS, 2, 2);
            glStencilOp(GL_KEEP, GL_KEEP, GL_REPLACE);

            ShaderInstance shader = Objects.requireNonNull(RenderSystem.getShader());

            shader.safeGetUniform("BoxMin").set(box.min().getX(), box.min().getY(), box.min().getZ());
            shader.safeGetUniform("BoxMax").set(box.max().getX() + 1, box.max().getY() + 1, box.max().getZ() + 1);

            Vibrancy.SCREEN_VBO.bind();
            Vibrancy.SCREEN_VBO.drawWithShader(view, RenderSystem.getProjectionMatrix(), shader);
            VertexBuffer.unbind();

            stencilType.clearRenderState();
             */

            class_1921 type = VeilRenderType.get(Vibrancy.id("sky_shadow"));
            type.method_23516();

            glEnable(GL_STENCIL_TEST);
            glStencilMask(0xFF);
            glStencilFunc(GL_EQUAL, 1, 1);
            glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);
            glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 0, ssbo);

            class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());

            shader.method_35785("MaxLength").method_1251(distance);
            shader.method_35785("LightDirection").method_34413(direction);
            shader.method_34583("AtlasSampler", class_310.method_1551().method_1554().method_24153(class_1723.field_21668));

            vbo.method_1353();
            vbo.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();

            glBindBufferBase(GL_SHADER_STORAGE_BUFFER, 0, 0);

            type.method_23518();

            /*
            RenderType stencilClearType = VeilRenderType.get(Vibrancy.id("sky_stencil_clear"));
            stencilClearType.setupRenderState();

            glEnable(GL_STENCIL_TEST);
            glStencilMask(2);
            glStencilFunc(GL_ALWAYS, 0, 2);
            glStencilOp(GL_KEEP, GL_KEEP, GL_REPLACE);

            Vibrancy.SCREEN_VBO.bind();
            Vibrancy.SCREEN_VBO.drawWithShader(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.unbind();

            stencilClearType.clearRenderState();
             */

            SkyLight.this.shadowCount += shadowCount;
        }
    }

    public static @Nullable SkyLight INSTANCE;

    protected final class_291 linesVBO = new class_291(class_291.class_8555.field_44794);
    protected final Map<class_1923, Chunk> chunks = new LinkedHashMap<>();
    protected final List<class_1923> chunksToAdd = new LinkedList<>();
    protected Vector3f direction;
    protected float distance = 128;
    protected boolean isDirty = true;
    protected int shadowCount = 0;

    public void markDirty() {
        isDirty = true;
    }

    public void clean() {
        isDirty = false;
    }

    public boolean isDirty() {
        return isDirty;
    }

    public void appendDebugInfo(Consumer<String> out) {
        out.accept("Sky Light Chunks: " + chunks.size());
        out.accept("Sky Light Shadows: " + shadowCount + " / " + chunks.values().stream().mapToInt(chunk -> chunk.quads.size()).sum());
        out.accept("Sky Light Direction: (" + direction.x + ", " + direction.y + ", " + direction.z + ")");
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        for (class_2338 pos : it) {
            chunks.computeIfAbsent(new class_1923(pos), Chunk::new).dirty.add(pos);
        }
    }

    @Override
    public void init() {
    }

    public void onChunkLoad(class_1923 pos) {
        chunksToAdd.add(pos);
    }

    public void onChunkUnload(class_1923 pos) {
        chunksToAdd.remove(pos);
        Chunk chunk1 = chunks.remove(pos);

        if (chunk1 != null) {
            chunk1.free();
        }
    }

    public void onChunkUpdate(class_1923 pos) {
        Chunk chunk1 = chunks.get(pos);

        if (chunk1 == null) {
            onChunkLoad(pos);
        } else {
            chunk1.markDirty();
        }
    }

    public abstract Vector3f getDirection(class_638 level);

    public abstract Vector3f getColor(class_638 level);

    protected boolean shouldCastBlock(class_638 level, class_2338 pos) {
        if (level.method_8320(pos).method_26167(level, pos)) {
            return false;
        }

        for (class_2350 direction : new class_2350[]{class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034}) {
            if (level.method_8314(class_1944.field_9284, pos.method_10093(direction)) != 0) {
                return true;
            }
        }

        return false;
    }

    protected void renderMask(boolean raytrace, Matrix4f view) {
        AdvancedFbo fbo = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask")));
        fbo.bind(true);
        glClearColor(0f, 0f, 0f, 0f);
        glClearStencil(0);
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

        if (raytrace) {
            glEnable(GL_STENCIL_TEST);
            glStencilMask(1);
            glStencilFunc(GL_ALWAYS, 1, 1);
            glStencilOp(GL_KEEP, GL_KEEP, GL_REPLACE);

            class_1921 stencilType = VeilRenderType.get(Vibrancy.id("sky_stencil"));
            stencilType.method_23516();

            Vibrancy.SCREEN_VBO.method_1353();
            Vibrancy.SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();

            stencilType.method_23518();

            for (Chunk chunk : chunks.values()) {
                chunk.renderMask(view);
            }

            glDisable(GL_STENCIL_TEST);
        }
    }

    protected void renderLight(class_638 level) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
        VeilRenderSystem.setShader(Vibrancy.id("light/ray/sky"));
        class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());

        shader.method_35785("LightDirection").method_34413(direction);
        shader.method_35785("LightColor").method_34413(getColor(level));

        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.class_4535.ONE, GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation(GL_FUNC_ADD);

        Vibrancy.SCREEN_VBO.method_1353();
        Vibrancy.SCREEN_VBO.method_34427(null, null, shader);
        class_291.method_1354();

        RenderSystem.disableBlend();
    }

    @Override
    public boolean render(boolean raytrace) {
        shadowCount = 0;

        class_638 level = class_310.method_1551().field_1687;

        if (level != null) {
            direction = getDirection(level);

            chunksToAdd.removeIf(pos -> {
                if (
                        level.method_8393(pos.field_9181, pos.field_9180) &&
                        level.method_8393(pos.field_9181 + 1, pos.field_9180) &&
                        level.method_8393(pos.field_9181 - 1, pos.field_9180) &&
                        level.method_8393(pos.field_9181, pos.field_9180 + 1) &&
                        level.method_8393(pos.field_9181, pos.field_9180 - 1)
                ) {
                    chunks.computeIfAbsent(pos, Chunk::new).markDirty();
                    return true;
                }

                return false;
            });

            int distanceSq = Vibrancy.SKY_SHADOW_DISTANCE.method_41753() * Vibrancy.SKY_SHADOW_DISTANCE.method_41753();

            for (Chunk chunk : chunks.values()) {
                if (chunk.pos.method_52566(class_310.method_1551().field_1724.method_31476()) <= distanceSq) {
                    chunk.render = true;
                    chunk.init(level, raytrace);
                } else {
                    chunk.render = false;
                }
            }

            clean();

            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            Matrix4f view = new Matrix4f()
                    .rotate(camera.method_23767().invert(new Quaternionf()))
                    .translate((float) -camera.method_19326().field_1352, (float) -camera.method_19326().field_1351, (float) -camera.method_19326().field_1350);

            renderMask(raytrace, view);
            renderLight(level);

            if (Vibrancy.DEBUG_SKY_LIGHT_VIEW) {
                class_287 consumer = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
                boolean any = false;

                for (Chunk chunk : chunks.values()) {
                    if (chunk.shadowCount > 0 && chunk.render) {
                        for (Quad quad : chunk.quads) {
                            any = true;

                            Vector3f color = quad.direction() == null || Vibrancy.pointsToward(quad.direction(), direction) ? new Vector3f(0, 1, 0) : new Vector3f(1, 0, 0);

                            Vector3f[] order = {
                                    quad.v1(), quad.v2(),
                                    quad.v2(), quad.v3(),
                                    quad.v3(), quad.v4(),
                                    quad.v4(), quad.v1(),
                                    quad.v1(), quad.v3(),
                                    quad.v2(), quad.v4()
                            };

                            for (Vector3f vec : order) {
                                consumer.method_22912(vec.x, vec.y, vec.z).method_22915(color.x, color.y, color.z, 1).method_22914(0, 1, 0);
                            }
                        }
                    }
                }

                if (any) {
                    class_1921 type = VeilRenderType.get(Vibrancy.id("debug_lines"));
                    type.method_23516();

                    linesVBO.method_1353();
                    linesVBO.method_1352(consumer.method_60794());
                    linesVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                    class_291.method_1354();

                    type.method_23518();
                }
            }

            return true;
        }

        return false;
    }

    @Override
    public boolean shouldRender(class_243 cam) {
        return true;
    }

    @Override
    public void free() {
        for (Chunk chunk : chunks.values()) {
            chunk.free();
        }

        chunks.clear();
    }

    public static class Overworld extends SkyLight {
        @Override
        public Vector3f getDirection(class_638 level) {
            float sunAngle = level.method_8442(0);
            float x = (float) -Math.sin(sunAngle), y = (float) Math.cos(sunAngle);

            if (y < 0) {
                x = -x;
                y = -y;
            }

            return new Vector3f(x, y, 0);
        }

        @Override
        public Vector3f getColor(class_638 level) {
            Color color = new Color(((LightTextureAccessor) class_310.method_1551().field_1773.method_22974()).getLightPixels().method_4315(0, 15));
            return new Vector3f(color.getRed() / 255f / 2, color.getGreen() / 255f / 2, color.getBlue() / 255f / 2);
        }
    }
}
