package net.typho.vibrancy.mixin;

import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.typho.vibrancy.BlockStateFunction;
import net.typho.vibrancy.Vibrancy;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4970.class_4971.class)
public abstract class BlockStateBaseMixin {
    @Shadow
    public abstract class_2248 getBlock();

    @Shadow protected abstract class_2680 asState();

    @Inject(
            method = "emissiveRendering",
            at = @At("HEAD"),
            cancellable = true
    )
    @SuppressWarnings("deprecation")
    private void emissiveRendering(class_1922 level, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        BlockStateFunction<Boolean> func = Vibrancy.EMISSIVE_OVERRIDES.get(getBlock().method_40142().method_40237());

        if (func != null) {
            cir.setReturnValue(func.apply(asState()));
        }
    }
}
