package net.typho.vibrancy.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2818;
import net.minecraft.class_631;
import net.minecraft.class_6603;
import net.typho.vibrancy.Vibrancy;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.function.Consumer;

@Mixin(class_631.class)
public class ClientChunkCacheMixin {
    @Inject(
            method = "replaceWithPacketData",
            at = @At("TAIL")
    )
    private void onChunkLoad(int x, int z, class_2540 packetByteBuf, class_2487 nbtCompound, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info) {
        Vibrancy.onChunkLoad(info.getReturnValue());
    }

    @Inject(
            method = "replaceWithPacketData",
            at = @At(
                    value = "NEW",
                    target = "net/minecraft/world/level/chunk/LevelChunk",
                    shift = At.Shift.BEFORE
            )
    )
    private void onChunkLoad(int x, int z, class_2540 packetByteBuf, class_2487 nbtCompound, Consumer<class_6603.class_6605> consumer, CallbackInfoReturnable<class_2818> info, @Local class_2818 chunk) {
        if (chunk != null) {
            Vibrancy.onChunkUnload(chunk);
        }
    }

    @Inject(
            method = "drop",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;replace(ILnet/minecraft/world/level/chunk/LevelChunk;Lnet/minecraft/world/level/chunk/LevelChunk;)Lnet/minecraft/world/level/chunk/LevelChunk;"
            )
    )
    private void onChunkUnload(class_1923 pos, CallbackInfo ci, @Local class_2818 chunk) {
        Vibrancy.onChunkUnload(chunk);
    }
}
