package net.typho.vibrancy.mixin;

import foundry.veil.VeilClient;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import net.minecraft.class_309;
import net.minecraft.class_310;
import net.typho.vibrancy.Vibrancy;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static org.lwjgl.glfw.GLFW.*;

@Mixin(class_309.class)
public class KeyboardHandlerMixin {
    @Shadow
    @Final
    private class_310 minecraft;

    @Unique
    private boolean f6Handled;

    @Inject(
            method = "keyPress",
            at = @At("HEAD"),
            cancellable = true
    )
    public void keyPress(long window, int key, int scancode, int action, int mods, CallbackInfo ci) {
        if (window == minecraft.method_22683().method_4490()) {
            if (VeilClient.EDITOR_KEY.method_1417(key, scancode)) {
                if (action == GLFW_PRESS) {
                    ci.cancel();
                } else if (action == GLFW_RELEASE) {
                    if (!f6Handled) {
                        VeilImGuiImpl.get().toggle();
                    }

                    f6Handled = false;
                    ci.cancel();
                }
            } else if (action == GLFW_PRESS && glfwGetKey(window, GLFW_KEY_F6) == GLFW_PRESS) {
                if (Vibrancy.debugKey(key)) {
                    f6Handled = true;
                    ci.cancel();
                }
            }
        }
    }
}
