package net.typho.vibrancy.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.typho.vibrancy.light.RaytracedLight;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2818.class)
public class LevelChunkMixin {
    @Inject(
            method = "setBlockState",
            at = @At(
                    value = "RETURN",
                    ordinal = 3
            )
    )
    private void setBlockState(class_2338 pos, class_2680 state, boolean moved, CallbackInfoReturnable<class_2680> cir) {
        RenderSystem.recordRenderCall(() -> RaytracedLight.DIRTY.add(pos));
    }
}
