package net.typho.vibrancy.mixin;

import net.minecraft.class_310;
import net.minecraft.class_3304;
import net.minecraft.class_434;
import net.minecraft.class_437;
import net.minecraft.class_542;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.EntityPointLight;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_310.class)
public class MinecraftMixin {
    @Shadow
    @Nullable
    public class_746 player;

    @Shadow
    @Final
    private class_3304 resourceManager;

    @Inject(
            method = "disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V",
            at = @At("HEAD")
    )
    private void disconnect(class_437 disconnectionScreen, boolean transferring, CallbackInfo ci) {
        EntityPointLight light = Vibrancy.ENTITY_LIGHTS.get(player);

        if (light != null) {
            light.free();
        }
    }

    @Inject(
            method = "clearClientLevel",
            at = @At("HEAD")
    )
    private void clearClientLevel(class_437 nextScreen, CallbackInfo ci) {
        EntityPointLight light = Vibrancy.ENTITY_LIGHTS.get(player);

        if (light != null) {
            light.free();
        }
    }

    @Inject(
            method = "<init>",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/packs/resources/ReloadableResourceManager;registerReloadListener(Lnet/minecraft/server/packs/resources/PreparableReloadListener;)V",
                    ordinal = 0
            )
    )
    private void init(class_542 gameConfig, CallbackInfo ci) {
        Vibrancy.registerReloadListeners(resourceManager);
    }

    @Inject(
            method = "setLevel",
            at = @At("TAIL")
    )
    private void afterClientLevelChange(class_638 level, class_434.class_9678 reason, CallbackInfo ci) {
        if (level != null) {
            Vibrancy.afterClientLevelChange(level);
        }
    }
}
