package net.typho.vibrancy.mixin;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import net.minecraft.class_1041;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_5944.class)
public abstract class ShaderProgramMixin {
    @Shadow
    @Nullable
    public abstract class_284 getUniform(String p_173349_);

    @Shadow
    public abstract void setSampler(String p_173351_, Object p_173352_);

    @Unique
    private class_284 camPos;
    @Unique
    private class_284 renderTime;
    @Unique
    private class_284 skyAngle;

    @Inject(
            method = "<init>",
            at = @At("TAIL")
    )
    private void init(class_5912 resourceProvider, String name, class_293 vertexFormat, CallbackInfo ci) {
        camPos = getUniform("CameraPos");
        renderTime = getUniform("RenderTime");
        skyAngle = getUniform("SkyAngle");
    }

    @Inject(
            method = "setDefaultUniforms",
            at = @At("TAIL")
    )
    private void setDefaultUniforms(class_293.class_5596 mode, Matrix4f projectionMatrix, Matrix4f frustrumMatrix, class_1041 window, CallbackInfo ci) {
        if (camPos != null) {
            Vector3f vec = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
            camPos.method_1249(vec.z, vec.y, vec.x);
        }

        if (renderTime != null) {
            renderTime.method_1251((float) GLFW.glfwGetTime());
        }

        if (skyAngle != null) {
            skyAngle.method_1251(class_310.method_1551().field_1687.method_8442(class_310.method_1551().method_60646().method_60637(false)));
        }

        DynamicBufferManger bufferManger = VeilRenderSystem.renderer().getDynamicBufferManger();
        for (DynamicBufferType dynamicBuffer : DynamicBufferType.values()) {
            setSampler(dynamicBuffer.getSourceName() + "Sampler", bufferManger.getBufferTexture(dynamicBuffer));
        }
    }
}
