/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.typho.vibrancy.BlockStateFunction;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.AbstractPointLight;
import net.typho.vibrancy.light.BlockPointLight;
import org.joml.Vector3f;

public record DynamicLightInfo(Vector3f color, BlockStateFunction<Optional<Float>> radius, BlockStateFunction<Optional<Float>> brightness, BlockStateFunction<Optional<Float>> flicker, BlockStateFunction<Optional<class_243>> offset) {
    public static final Map<Predicate<class_2680>, Function<class_2680, DynamicLightInfo>> MAP = new LinkedHashMap<Predicate<class_2680>, Function<class_2680, DynamicLightInfo>>();

    public static DynamicLightInfo get(class_2680 state) {
        return MAP.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(state)).findAny().map(entry -> (DynamicLightInfo)((Function)entry.getValue()).apply(state)).orElse(null);
    }

    public BlockPointLight createBlockLight(class_2338 pos, class_2680 state) {
        return (BlockPointLight)this.initLight(new BlockPointLight(pos).setFlicker(this.flicker().apply(state).orElse(Float.valueOf(0.0f)).floatValue()), state);
    }

    public void addBlockLight(class_2338 pos, class_2680 state) {
        BlockPointLight old = Vibrancy.BLOCK_LIGHTS.get(pos);
        if (old == null) {
            Vibrancy.BLOCK_LIGHTS.put(pos, this.createBlockLight(pos, state));
        }
    }

    public <L extends AbstractPointLight> L initLight(L light, class_2680 state) {
        float b = this.brightness.apply(state).orElse(Float.valueOf(1.0f)).floatValue();
        light.setColor(this.color().mul(b, new Vector3f())).setRadius(this.radius.apply(state).orElse(Float.valueOf(state.method_26213())).floatValue());
        return light;
    }

    public static class Builder {
        public Vector3f color;
        public BlockStateFunction<Optional<Float>> radius = state -> Optional.empty();
        public BlockStateFunction<Optional<Float>> brightness = state -> Optional.empty();
        public BlockStateFunction<Optional<Float>> flicker = state -> Optional.empty();
        public BlockStateFunction<Optional<class_243>> offset = state -> Optional.empty();

        public Builder color(Vector3f color) {
            this.color = color;
            return this;
        }

        public Builder radius(BlockStateFunction<Optional<Float>> radius) {
            BlockStateFunction<Optional<Float>> radius1 = this.radius;
            this.radius = state -> ((Optional)radius.apply(state)).or(() -> (Optional)radius1.apply(state));
            return this;
        }

        public Builder brightness(BlockStateFunction<Optional<Float>> brightness) {
            BlockStateFunction<Optional<Float>> brightness1 = this.brightness;
            this.brightness = state -> ((Optional)brightness.apply(state)).or(() -> (Optional)brightness1.apply(state));
            return this;
        }

        public Builder flicker(BlockStateFunction<Optional<Float>> flicker) {
            BlockStateFunction<Optional<Float>> flicker1 = this.flicker;
            this.flicker = state -> ((Optional)flicker.apply(state)).or(() -> (Optional)flicker1.apply(state));
            return this;
        }

        public Builder offset(BlockStateFunction<Optional<class_243>> offset) {
            BlockStateFunction<Optional<class_243>> offset1 = this.offset;
            this.offset = state -> ((Optional)offset.apply(state)).or(() -> (Optional)offset1.apply(state));
            return this;
        }

        public Builder copy(DynamicLightInfo info) {
            return this.color(info.color).radius(info.radius).brightness(info.brightness).flicker(info.flicker).offset(info.offset);
        }

        public Builder then(class_2248 block, String key, JsonElement value) {
            return switch (key) {
                case "color" -> {
                    if (value.isJsonArray()) {
                        JsonArray array = value.getAsJsonArray();
                        if (array.size() != 3) {
                            throw new JsonParseException("Expected a 3-element array for color while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + array.size() + " elements");
                        }
                        yield this.color(new Vector3f(array.get(0).getAsJsonPrimitive().getAsFloat(), array.get(1).getAsJsonPrimitive().getAsFloat(), array.get(2).getAsJsonPrimitive().getAsFloat()));
                    }
                    throw new JsonParseException("Expected a 3-element array for color while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(value));
                }
                case "offset" -> {
                    if (value.isJsonNull()) {
                        this.offset = state -> Optional.empty();
                        yield this;
                    }
                    if (value.isJsonObject() || value.isJsonArray()) {
                        yield this.offset(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonArray()) {
                                JsonArray array = json.getAsJsonArray();
                                if (array.size() != 3) {
                                    throw new JsonParseException("Expected a 3-element array for offset while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + array.size() + " elements");
                                }
                                return Optional.of(new class_243(array.get(0).getAsJsonPrimitive().getAsDouble(), array.get(1).getAsJsonPrimitive().getAsDouble(), array.get(2).getAsJsonPrimitive().getAsDouble()));
                            }
                            throw new JsonParseException("Expected a 3-element array for offset while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(json));
                        }, Optional::empty));
                    }
                    throw new JsonParseException("Expected a 3-element array for offset while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(value));
                }
                case "radius" -> {
                    if (value.isJsonNull()) {
                        this.radius = state -> Optional.empty();
                        yield this;
                    }
                    if (value.isJsonObject() || value.isJsonPrimitive()) {
                        yield this.radius(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonPrimitive()) {
                                return Optional.of(Float.valueOf(json.getAsJsonPrimitive().getAsFloat()));
                            }
                            throw new JsonParseException("Expected a float for radius while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(json));
                        }, Optional::empty));
                    }
                    throw new JsonParseException("Expected a float for radius while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(value));
                }
                case "brightness" -> {
                    if (value.isJsonNull()) {
                        this.brightness = state -> Optional.empty();
                        yield this;
                    }
                    if (value.isJsonObject() || value.isJsonPrimitive()) {
                        yield this.brightness(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonPrimitive()) {
                                return Optional.of(Float.valueOf(json.getAsJsonPrimitive().getAsFloat()));
                            }
                            throw new JsonParseException("Expected a float for brightness while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(json));
                        }, Optional::empty));
                    }
                    throw new JsonParseException("Expected a float for brightness while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(value));
                }
                case "flicker" -> {
                    if (value.isJsonNull()) {
                        this.flicker = state -> Optional.empty();
                        yield this;
                    }
                    if (value.isJsonObject() || value.isJsonPrimitive()) {
                        yield this.flicker(BlockStateFunction.parseJson(block, value, json -> {
                            if (json.isJsonPrimitive()) {
                                return Optional.of(Float.valueOf(json.getAsJsonPrimitive().getAsFloat()));
                            }
                            throw new JsonParseException("Expected a float for flicker while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(json));
                        }, Optional::empty));
                    }
                    throw new JsonParseException("Expected a float for flicker while parsing dynamic light info while parsing " + String.valueOf(block) + ", got " + String.valueOf(value));
                }
                default -> this;
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder load(class_2248 block, JsonElement json) {
            JsonPrimitive primitive;
            if (json.isJsonObject()) {
                JsonObject jsonObj = json.getAsJsonObject();
                JsonElement copy = jsonObj.get("copy");
                if (copy != null) {
                    if (!copy.isJsonPrimitive()) throw new JsonParseException("Expected a string for copy while parsing dynamic light info for \"" + String.valueOf(block) + "\", got " + String.valueOf(copy));
                    JsonPrimitive primitive2 = copy.getAsJsonPrimitive();
                    if (!primitive2.isString()) throw new JsonParseException("Expected a string for copy while parsing dynamic light info for \"" + String.valueOf(block) + "\", got " + String.valueOf(primitive2));
                    String s = primitive2.getAsString();
                    if (s.startsWith("#")) {
                        throw new IllegalArgumentException("Can't copy the dynamic light info of a tag (for technical reasons)");
                    }
                    this.copy(DynamicLightInfo.get(((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)s))).method_9564()));
                }
                jsonObj.asMap().forEach((key1, value) -> this.then(block, (String)key1, (JsonElement)value));
                return this;
            }
            if (!json.isJsonPrimitive() || !(primitive = json.getAsJsonPrimitive()).isString()) throw new JsonParseException("Expected either a string or object while parsing dynamic light info for \"" + String.valueOf(block) + "\", got " + String.valueOf(json));
            String s = primitive.getAsString();
            if (!s.startsWith("#")) return this.copy(DynamicLightInfo.get(((class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)s))).method_9564()));
            throw new IllegalArgumentException("Can't copy the dynamic light info of a tag (for technical reasons)");
        }

        public DynamicLightInfo build() {
            return new DynamicLightInfo(this.color, this.radius, this.brightness, this.flicker, this.offset);
        }
    }
}

