/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3298;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7172;
import net.minecraft.class_742;
import net.minecraft.class_7919;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.typho.vibrancy.BlockStateFunction;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.light.AbstractPointLight;
import net.typho.vibrancy.light.BlockPointLight;
import net.typho.vibrancy.light.EntityPointLight;
import net.typho.vibrancy.light.RaytracedLight;
import net.typho.vibrancy.light.SkyLight;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;

public class Vibrancy {
    public static final String MOD_ID = "vibrancy";
    public static final class_7172<Boolean> TRANSPARENCY_TEST = class_7172.method_41749((String)"options.vibrancy.transparency_test", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.transparency_test.tooltip")), (boolean)true);
    public static final class_7172<Boolean> BETTER_FOG = class_7172.method_41749((String)"options.vibrancy.better_fog", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.better_fog.tooltip")), (boolean)true);
    public static final class_7172<Boolean> ELYTRA_TRAILS = class_7172.method_41749((String)"options.vibrancy.elytra_trails", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.elytra_trails.tooltip")), (boolean)true);
    public static final class_7172<Integer> SKY_SHADOW_DISTANCE = new class_7172("options.vibrancy.sky_shadow_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.sky_shadow_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.vibrancy.sky_shadow_distance.value", (Object[])new Object[]{value})), (class_7172.class_7178)new class_7172.class_7174(1, 8, false), (Object)4, value -> {});
    public static final class_7172<Integer> RAYTRACE_DISTANCE = new class_7172("options.vibrancy.raytrace_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.raytrace_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.vibrancy.raytrace_distance.value", (Object[])new Object[]{value * 16})), (class_7172.class_7178)new class_7172.class_7174(1, 32, false), (Object)16, value -> {});
    public static final class_7172<Integer> LIGHT_CULL_DISTANCE = new class_7172("options.vibrancy.light_cull_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.light_cull_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)class_2561.method_43469((String)"options.vibrancy.light_cull_distance.value", (Object[])new Object[]{value * 16})), (class_7172.class_7178)new class_7172.class_7174(1, 32, false), (Object)32, value -> {});
    public static final class_7172<Integer> MAX_RAYTRACED_LIGHTS = new class_7172("options.vibrancy.max_raytraced_lights", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_raytraced_lights.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 100 ? class_2561.method_43471((String)"options.vibrancy.max_raytraced_lights.max") : class_2561.method_43469((String)"options.vibrancy.max_raytraced_lights.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(5, 105, false), (Object)60, value -> {});
    public static final class_7172<Integer> MAX_SHADOW_DISTANCE = new class_7172("options.vibrancy.max_shadow_distance", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_shadow_distance.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 15 ? class_2561.method_43471((String)"options.vibrancy.max_shadow_distance.max") : class_2561.method_43469((String)"options.vibrancy.max_shadow_distance.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)6, value -> {});
    public static final class_7172<Integer> MAX_LIGHT_RADIUS = new class_7172("options.vibrancy.max_light_radius", value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"options.vibrancy.max_light_radius.tooltip")), (text, value) -> class_315.method_41783((class_2561)text, (class_2561)(value > 15 ? class_2561.method_43471((String)"options.vibrancy.max_light_radius.max") : class_2561.method_43469((String)"options.vibrancy.max_light_radius.value", (Object[])new Object[]{value}))), (class_7172.class_7178)new class_7172.class_7174(1, 16, false), (Object)15, value -> {});
    public static boolean DEBUG_SKY_LIGHT_VIEW = false;
    public static boolean RENDER_SKY_LIGHT = true;
    public static boolean RENDER_BLOCK_LIGHT = true;
    public static boolean RENDER_ENTITY_LIGHT = true;
    public static boolean SEEN_ALPHA_TEXT = false;
    public static Supplier<class_2400> STEAM;
    public static final Map<class_5321<class_2248>, BlockStateFunction<Boolean>> EMISSIVE_OVERRIDES;
    public static final Map<class_2338, BlockPointLight> BLOCK_LIGHTS;
    public static final Map<class_1309, EntityPointLight> ENTITY_LIGHTS;
    public static int NUM_LIGHT_TASKS;
    public static int NUM_RAYTRACED_LIGHTS;
    public static int NUM_VISIBLE_LIGHTS;
    public static int SHADOW_COUNT;
    public static class_291 SCREEN_VBO;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static int maxLights() {
        int v = (Integer)MAX_RAYTRACED_LIGHTS.method_41753();
        return v > 100 ? Integer.MAX_VALUE : v;
    }

    public static int capShadowDistance(int distance) {
        int v = (Integer)MAX_SHADOW_DISTANCE.method_41753();
        return v > 15 ? distance : Math.min(distance, v);
    }

    public static boolean shouldRenderLight(RaytracedLight light) {
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        boolean b = light.shouldRender(cam);
        if (b) {
            ++NUM_VISIBLE_LIGHTS;
        }
        return b;
    }

    public static double getLightSortDistance(RaytracedLight light) {
        return light.getSortDistance();
    }

    public static void renderLight(RaytracedLight light, int[] cap) {
        boolean raytrace;
        boolean bl = raytrace = cap[0] < Vibrancy.maxLights();
        if (light.render(raytrace)) {
            if (raytrace) {
                ++NUM_RAYTRACED_LIGHTS;
            }
            cap[0] = cap[0] + 1;
        }
    }

    public static boolean pointsToward(class_2350 face, Vector3f offset) {
        class_2382 normal = face.method_10163();
        return new Vector3f((float)normal.method_10263(), (float)normal.method_10264(), (float)normal.method_10260()).dot((Vector3fc)offset) > 0.0f;
    }

    public static void elytraTrail(class_1309 entity) {
        if (Math.random() < Math.min(entity.method_18798().method_1033() - 0.75, (entity.method_23318() - 80.0) / 40.0)) {
            entity.method_37908().method_8406((class_2394)STEAM.get(), entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public static void updateBlock(class_2338 pos, class_2680 state) {
        DynamicLightInfo info = DynamicLightInfo.get(state);
        if (info != null) {
            info.addBlockLight(pos, state);
        }
    }

    public static void registerReloadListeners(class_3304 resourceManager) {
        resourceManager.method_14477((class_3302)((class_4013)manager -> {
            BufferedReader reader;
            DynamicLightInfo.MAP.clear();
            for (class_3298 resource : manager.method_14489(Vibrancy.id("dynamic_lights.json"))) {
                try {
                    reader = resource.method_43039();
                    try {
                        JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                            if (key.startsWith("#")) {
                                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key.substring(1)));
                                DynamicLightInfo.MAP.put(state -> state.method_26164(tagKey), class_156.method_34866(state -> new DynamicLightInfo.Builder().load((class_2248)state.method_26204().method_40142().comp_349(), (JsonElement)value).build()));
                            } else {
                                class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key));
                                DynamicLightInfo info = new DynamicLightInfo.Builder().load((class_2248)class_7923.field_41175.method_29107(regKey), (JsonElement)value).build();
                                DynamicLightInfo.MAP.put(state -> state.method_54097(regKey), state -> info);
                            }
                        });
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            EMISSIVE_OVERRIDES.clear();
            for (class_3298 resource : manager.method_14489(Vibrancy.id("emissive_blocks.json"))) {
                try {
                    reader = resource.method_43039();
                    try {
                        JsonParser.parseReader((Reader)reader).getAsJsonObject().asMap().forEach((key, value) -> {
                            class_5321 regKey = class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60654((String)key));
                            EMISSIVE_OVERRIDES.put((class_5321<class_2248>)regKey, BlockStateFunction.parseJson((class_2248)class_7923.field_41175.method_29107(regKey), value, JsonElement::getAsBoolean, () -> false));
                        });
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    public static void onChunkLoad(class_2818 chunk) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkLoad(chunk.method_12004());
        }
        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b = new class_1923(light.blockPos).equals((Object)chunk.method_12004());
            if (b) {
                light.free();
            }
            return b;
        });
        for (int i = chunk.method_32891(); i < chunk.method_31597(); ++i) {
            class_2826 section = chunk.method_38259(chunk.method_31603(i));
            if (!section.method_19523(state -> DynamicLightInfo.MAP.keySet().stream().anyMatch(p -> p.test(state)))) continue;
            class_2338 minPos = class_4076.method_18681((class_1923)chunk.method_12004(), (int)i).method_19767();
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 state2 = section.method_12254(x, y, z);
                        DynamicLightInfo info = DynamicLightInfo.get(state2);
                        if (info == null) continue;
                        info.addBlockLight(new class_2338(x + minPos.method_10263(), y + minPos.method_10264(), z + minPos.method_10260()), state2);
                    }
                }
            }
        }
    }

    public static void onChunkUnload(class_2818 chunk) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.onChunkUnload(chunk.method_12004());
        }
        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b = new class_1923(light.blockPos).equals((Object)chunk.method_12004());
            if (b) {
                light.free();
            }
            return b;
        });
    }

    public static void afterClientLevelChange(class_638 world) {
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.free();
        }
        if (world.method_27983().equals(class_1937.field_25179)) {
            SkyLight.INSTANCE = new SkyLight.Overworld();
            SkyLight.INSTANCE.markDirty();
        } else {
            SkyLight.INSTANCE = null;
        }
        BLOCK_LIGHTS.values().forEach(AbstractPointLight::free);
        BLOCK_LIGHTS.clear();
        ENTITY_LIGHTS.values().forEach(AbstractPointLight::free);
        ENTITY_LIGHTS.clear();
        for (class_742 player : world.method_18456()) {
            ENTITY_LIGHTS.put((class_1309)player, new EntityPointLight((class_1309)player));
        }
    }

    public static void render() {
        NUM_LIGHT_TASKS = 0;
        class_2960 id = Vibrancy.id("ray_light");
        VeilRenderSystem.renderer().enableBuffers(id, new DynamicBufferType[]{DynamicBufferType.NORMAL, DynamicBufferType.ALBEDO, DynamicBufferType.LIGHT_UV});
        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(id).bind(true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        BLOCK_LIGHTS.values().removeIf(light -> {
            boolean b;
            boolean bl = b = light == null || light.shouldRemove();
            if (b && light != null) {
                light.free();
            }
            return b;
        });
        int[] cap = new int[]{0};
        NUM_RAYTRACED_LIGHTS = 0;
        NUM_VISIBLE_LIGHTS = 0;
        SHADOW_COUNT = 0;
        if (SkyLight.INSTANCE != null) {
            SkyLight.INSTANCE.init();
            SkyLight.INSTANCE.updateDirty(RaytracedLight.DIRTY);
        }
        for (BlockPointLight blockPointLight : BLOCK_LIGHTS.values()) {
            blockPointLight.init();
            blockPointLight.updateDirty(RaytracedLight.DIRTY);
        }
        for (EntityPointLight entityPointLight : ENTITY_LIGHTS.values()) {
            entityPointLight.init();
            entityPointLight.updateDirty(RaytracedLight.DIRTY);
        }
        if (SkyLight.INSTANCE != null && RENDER_SKY_LIGHT) {
            Vibrancy.renderLight(SkyLight.INSTANCE, cap);
        }
        if (RENDER_BLOCK_LIGHT) {
            ENTITY_LIGHTS.values().stream().sorted(Comparator.comparingDouble(Vibrancy::getLightSortDistance)).filter(Vibrancy::shouldRenderLight).forEachOrdered(light -> Vibrancy.renderLight(light, cap));
        }
        if (RENDER_ENTITY_LIGHT) {
            BLOCK_LIGHTS.values().stream().sorted(Comparator.comparingDouble(Vibrancy::getLightSortDistance)).filter(Vibrancy::shouldRenderLight).forEachOrdered(light -> Vibrancy.renderLight(light, cap));
        }
        RaytracedLight.DIRTY.clear();
    }

    public static boolean debugKey(int key) {
        switch (key) {
            case 57: {
                DEBUG_SKY_LIGHT_VIEW = !DEBUG_SKY_LIGHT_VIEW;
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"debug.vibrancy.sky_light_view"), false);
                return true;
            }
            case 56: {
                RENDER_SKY_LIGHT = !RENDER_SKY_LIGHT;
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"debug.vibrancy.render_sky_light"), false);
                return true;
            }
            case 55: {
                RENDER_BLOCK_LIGHT = !RENDER_BLOCK_LIGHT;
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"debug.vibrancy.render_block_light"), false);
                return true;
            }
            case 54: {
                RENDER_ENTITY_LIGHT = !RENDER_ENTITY_LIGHT;
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"debug.vibrancy.render_entity_light"), false);
                return true;
            }
        }
        return false;
    }

    public static void init() {
    }

    static {
        EMISSIVE_OVERRIDES = new LinkedHashMap<class_5321<class_2248>, BlockStateFunction<Boolean>>();
        BLOCK_LIGHTS = new LinkedHashMap<class_2338, BlockPointLight>();
        ENTITY_LIGHTS = new LinkedHashMap<class_1309, EntityPointLight>();
        NUM_LIGHT_TASKS = 0;
        NUM_RAYTRACED_LIGHTS = 0;
        NUM_VISIBLE_LIGHTS = 0;
        SHADOW_COUNT = 0;
        RenderSystem.recordRenderCall(() -> {
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27380, class_290.field_1592);
            builder.method_22912(-1.0f, 1.0f, 0.0f);
            builder.method_22912(-1.0f, -1.0f, 0.0f);
            builder.method_22912(1.0f, 1.0f, 0.0f);
            builder.method_22912(1.0f, -1.0f, 0.0f);
            SCREEN_VBO = new class_291(class_291.class_8555.field_44793);
            SCREEN_VBO.method_1353();
            SCREEN_VBO.method_1352(builder.method_60800());
            class_291.method_1354();
        });
    }
}

