/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.AbstractPointLight;
import net.typho.vibrancy.light.RaytracedLight;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class AbstractMovingPointLight
extends AbstractPointLight {
    protected boolean hasLight = false;
    protected Map<class_2338, List<RaytracedLight.Quad>> quads = new LinkedHashMap<class_2338, List<RaytracedLight.Quad>>();
    protected final List<class_2338> dirty = new LinkedList<class_2338>();
    protected class_9380 quadBox;
    protected CompletableFuture<Map<class_2338, List<RaytracedLight.Quad>>> fullRebuildTask;

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_9380 box = this.getBox();
        for (class_2338 pos : it) {
            if (!box.method_58244(pos)) continue;
            this.dirty.add(pos);
        }
    }

    @Override
    protected void upload(class_287 builder, Collection<? extends RaytracedLight.IQuad> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35040);
        }
    }

    protected void regenQuadsSync(class_638 world, class_2338 pos, Consumer<RaytracedLight.Quad> out, class_2338 lightBlockPos) {
        this.quads.remove(pos);
        this.regenQuadsAsync(world, pos, out, lightBlockPos);
    }

    protected void regenQuadsAsync(class_638 world, class_2338 pos, Consumer<RaytracedLight.Quad> out, class_2338 lightBlockPos) {
        this.getQuads(world, pos, out, pos.method_10262((class_2382)lightBlockPos) <= 4.0, lightBlockPos, false, (class_2350 dir) -> true);
    }

    protected void regenAll(class_638 world, class_9380 box, class_2338 lightBlockPos) {
        this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
            LinkedHashMap<class_2338, List<RaytracedLight.Quad>> quads = new LinkedHashMap<class_2338, List<RaytracedLight.Quad>>();
            for (int x = box.comp_2466().method_10263(); x <= box.comp_2467().method_10263(); ++x) {
                for (int y = box.comp_2466().method_10264(); y <= box.comp_2467().method_10264(); ++y) {
                    for (int z = box.comp_2466().method_10260(); z <= box.comp_2467().method_10260(); ++z) {
                        class_2338 pos = new class_2338(x, y, z);
                        List<RaytracedLight.Quad> existing = this.quads.get(pos);
                        if (existing != null && !existing.isEmpty()) {
                            quads.put(pos, existing);
                            continue;
                        }
                        LinkedList list = new LinkedList();
                        this.regenQuadsAsync(world, pos, list::add, lightBlockPos);
                        if (list.isEmpty()) continue;
                        quads.put(pos, list);
                    }
                }
            }
            return quads;
        });
    }

    @Override
    public void init() {
    }

    public abstract boolean shouldRegenAll();

    @Override
    public boolean render(boolean raytrace) {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f(this.getPosition().x, this.getPosition().y, this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            class_9380 box = this.getBox();
            LinkedList volumes = new LinkedList();
            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            if (this.isVisible()) {
                if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                    try {
                        this.quads = this.fullRebuildTask.get();
                        this.fullRebuildTask = null;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                } else if (this.hasLight) {
                    if (this.quadBox == null || this.shouldRegenAll()) {
                        this.dirty.clear();
                        this.regenAll(world, blockRadius > 1 ? new class_9380(new class_2338(box.comp_2466().method_10263() - blockRadius, box.comp_2466().method_10264() - blockRadius, box.comp_2466().method_10260() - blockRadius), new class_2338(box.comp_2467().method_10263() + blockRadius, box.comp_2467().method_10264() + blockRadius, box.comp_2467().method_10260() + blockRadius)) : box, lightBlockPos);
                        this.quadBox = box;
                    } else if (!this.dirty.isEmpty()) {
                        for (class_2338 pos2 : this.dirty) {
                            LinkedList list2 = new LinkedList();
                            this.regenQuadsSync(world, pos2, list2::add, lightBlockPos);
                            for (class_2350 dir : class_2350.values()) {
                                this.regenQuadsSync(world, pos2.method_10093(dir), list2::add, lightBlockPos);
                            }
                            if (!list2.isEmpty()) {
                                this.quads.put(pos2, list2);
                                continue;
                            }
                            this.quads.remove(pos2);
                        }
                    }
                }
                this.quads.forEach((pos, list) -> {
                    if (box.method_58244(pos)) {
                        for (RaytracedLight.Quad quad : list) {
                            RaytracedLight.ShadowVolume volume = quad.toVolumeSphere(lightPos, this.radius);
                            volume.render((class_4588)builder);
                            volumes.add(volume);
                        }
                    }
                });
                this.upload(builder, volumes);
                this.shadowCount = volumes.size();
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f view = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
                this.renderMask(raytrace, lightPos, view);
                this.renderLight(lightPos, view);
                return true;
            }
        }
        return false;
    }
}

