/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.util.Collection;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.RaytracedLight;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public abstract class AbstractPointLight
implements RaytracedLight {
    protected final class_291 geomVBO = new class_291(class_291.class_8555.field_44793);
    protected final class_291 boxVBO = new class_291(class_291.class_8555.field_44793);
    protected final int quadsSSBO = GL15.glGenBuffers();
    protected int shadowCount = 0;
    protected boolean anyShadows = false;
    protected float flicker = 0.0f;
    protected float flickerMin;
    protected float flickerMax;
    protected float flickerStart = (float)GLFW.glfwGetTime();
    protected float radius = 15.0f;
    protected boolean isDirty = true;
    protected Vector3f color;
    protected Vector3f position = new Vector3f();

    public void markDirty() {
        this.isDirty = true;
    }

    public void clean() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @NotNull
    public Vector3f getPosition() {
        return this.position;
    }

    public float getFlicker() {
        return this.flicker;
    }

    public AbstractPointLight setFlicker(float flicker) {
        this.flicker = flicker;
        this.markDirty();
        return this;
    }

    public float getRadius() {
        return this.radius;
    }

    public AbstractPointLight setRadius(float radius) {
        this.radius = radius;
        this.markDirty();
        return this;
    }

    public Vector3f getColor() {
        return this.color;
    }

    public AbstractPointLight setColor(Vector3f color) {
        this.color = color;
        this.markDirty();
        return this;
    }

    @Override
    public double getSortDistance(class_243 cam) {
        return this.position.distanceSquared((float)cam.field_1352, (float)cam.field_1351, (float)cam.field_1350);
    }

    @Override
    public boolean shouldRender(class_243 cam) {
        return this.position.distanceSquared((float)cam.field_1352, (float)cam.field_1351, (float)cam.field_1350) / 16.0f < (float)((Integer)Vibrancy.LIGHT_CULL_DISTANCE.method_41753() * (Integer)Vibrancy.LIGHT_CULL_DISTANCE.method_41753()) && RaytracedLight.super.shouldRender(cam);
    }

    protected void getVolumes(class_638 world, class_2338 pos, Consumer<RaytracedLight.ShadowVolume> out, double sqDist, class_2338 lightBlockPos, Vector3f lightPos, float radius) {
        this.getQuads(world, pos, (RaytracedLight.Quad quad) -> out.accept(quad.toVolumeSphere(lightPos, radius)), sqDist <= 4.0, lightBlockPos, true, (class_2350 dir) -> true);
    }

    protected void upload(class_287 builder, Collection<? extends RaytracedLight.IQuad> volumes) {
        if (volumes.isEmpty()) {
            this.anyShadows = false;
        } else {
            this.anyShadows = true;
            this.upload(builder, volumes, this.geomVBO, this.quadsSSBO, 35044);
        }
    }

    public class_9380 getBox() {
        class_2338 lightBlockPos = new class_2338((int)Math.floor(this.position.x), (int)Math.floor(this.position.y), (int)Math.floor(this.position.z));
        int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
        class_9380 box = class_9380.method_58236((class_2338)lightBlockPos);
        if (blockRadius > 1) {
            box = new class_9380(new class_2338(box.comp_2466().method_10263() - blockRadius, box.comp_2466().method_10264() - blockRadius, box.comp_2466().method_10260() - blockRadius), new class_2338(box.comp_2467().method_10263() + blockRadius, box.comp_2467().method_10264() + blockRadius, box.comp_2467().method_10260() + blockRadius));
        }
        return box;
    }

    protected void renderMask(boolean raytrace, Vector3f lightPos, Matrix4f view) {
        AdvancedFbo fbo = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask")));
        fbo.bind(true);
        GL15.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL15.glClearStencil((int)0);
        GL15.glClear((int)17664);
        if (this.anyShadows && raytrace) {
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)255);
            GL15.glStencilFunc((int)519, (int)1, (int)255);
            GL15.glStencilOp((int)7680, (int)7680, (int)7681);
            class_1921 stencilType = VeilRenderType.get((class_2960)Vibrancy.id("point_stencil"), (Object[])new Object[0]);
            stencilType.method_23516();
            class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());
            shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
            shader.method_35785("LightRadius").method_1251(this.radius);
            Vibrancy.SCREEN_VBO.method_1353();
            Vibrancy.SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();
            stencilType.method_23518();
            class_1921 type = VeilRenderType.get((class_2960)Vibrancy.id("point_shadow"), (Object[])new Object[0]);
            type.method_23516();
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)255);
            GL15.glStencilFunc((int)514, (int)1, (int)255);
            GL15.glStencilOp((int)7680, (int)7680, (int)7680);
            shader = Objects.requireNonNull(RenderSystem.getShader());
            shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
            shader.method_35785("LightRadius").method_1251(this.radius);
            GL30.glBindBufferBase((int)37074, (int)0, (int)this.quadsSSBO);
            shader.method_34583("AtlasSampler", (Object)class_310.method_1551().method_1554().method_24153(class_1723.field_21668));
            this.geomVBO.method_1353();
            this.geomVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();
            GL30.glBindBufferBase((int)37074, (int)0, (int)0);
            type.method_23518();
            GL15.glDisable((int)2960);
            Vibrancy.SHADOW_COUNT += this.shadowCount;
        }
    }

    protected void renderLight(Vector3f lightPos, Matrix4f view) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
        VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/point"));
        class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());
        float time = (float)GLFW.glfwGetTime();
        while ((double)(time - this.flickerStart) > 0.25) {
            this.flickerStart += 0.25f;
            this.flickerMin = this.flickerMax;
            this.flickerMax = new Random().nextFloat(-1.0f, 1.0f);
        }
        float brightness = 1.0f + this.flicker * class_3532.method_16439((float)((time - this.flickerStart) * 4.0f), (float)this.flickerMin, (float)this.flickerMax);
        shader.method_35785("LightPos").method_1249(lightPos.x, lightPos.y, lightPos.z);
        shader.method_35785("LightColor").method_1249(this.color.x * brightness, this.color.y * brightness, this.color.z * brightness);
        shader.method_35785("LightRadius").method_1251(this.radius);
        shader.method_35785("AnyShadows").method_35649(this.anyShadows ? 1 : 0);
        class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        class_238 box = this.getBoundingBox();
        Vector3f[] vertices = new Vector3f[]{new Vector3f((float)box.field_1320, (float)box.field_1325, (float)box.field_1324), new Vector3f((float)box.field_1323, (float)box.field_1325, (float)box.field_1324), new Vector3f((float)box.field_1323, (float)box.field_1322, (float)box.field_1324), new Vector3f((float)box.field_1320, (float)box.field_1322, (float)box.field_1324), new Vector3f((float)box.field_1320, (float)box.field_1325, (float)box.field_1321), new Vector3f((float)box.field_1323, (float)box.field_1325, (float)box.field_1321), new Vector3f((float)box.field_1323, (float)box.field_1322, (float)box.field_1321), new Vector3f((float)box.field_1320, (float)box.field_1322, (float)box.field_1321)};
        builder.method_60830(vertices[0]).method_60830(vertices[1]).method_60830(vertices[2]).method_60830(vertices[3]);
        builder.method_60830(vertices[1]).method_60830(vertices[5]).method_60830(vertices[6]).method_60830(vertices[2]);
        builder.method_60830(vertices[5]).method_60830(vertices[4]).method_60830(vertices[7]).method_60830(vertices[6]);
        builder.method_60830(vertices[4]).method_60830(vertices[0]).method_60830(vertices[3]).method_60830(vertices[7]);
        builder.method_60830(vertices[1]).method_60830(vertices[0]).method_60830(vertices[4]).method_60830(vertices[5]);
        builder.method_60830(vertices[3]).method_60830(vertices[2]).method_60830(vertices[6]).method_60830(vertices[7]);
        RenderSystem.disableDepthTest();
        GL15.glCullFace((int)1028);
        RenderSystem.enableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation((int)32774);
        this.boxVBO.method_1353();
        this.boxVBO.method_1352(builder.method_60794());
        this.boxVBO.method_34427(view, RenderSystem.getProjectionMatrix(), shader);
        class_291.method_1354();
        GL15.glCullFace((int)1029);
        RenderSystem.disableBlend();
    }

    @Override
    @NotNull
    public class_238 getBoundingBox() {
        return new class_238((double)(this.position.x - this.radius), (double)(this.position.y - this.radius), (double)(this.position.z - this.radius), (double)(this.position.x + this.radius), (double)(this.position.y + this.radius), (double)(this.position.z + this.radius));
    }

    public void free() {
        this.geomVBO.close();
        GL15.glDeleteBuffers((int)this.quadsSSBO);
    }
}

