/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.DynamicLightInfo;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.AbstractPointLight;
import net.typho.vibrancy.light.RaytracedLight;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BlockPointLight
extends AbstractPointLight {
    protected final List<class_2338> dirty = new LinkedList<class_2338>();
    protected List<RaytracedLight.ShadowVolume> volumes = new LinkedList<RaytracedLight.ShadowVolume>();
    protected CompletableFuture<List<RaytracedLight.ShadowVolume>> fullRebuildTask;
    public final class_2338 blockPos;
    protected boolean render = false;

    public BlockPointLight(class_2338 blockPos) {
        this.blockPos = blockPos;
        this.markDirty();
    }

    public void regenQuads(class_638 world, class_2338 pos, Consumer<RaytracedLight.ShadowVolume> out, class_2338 lightBlockPos, Vector3f lightPos) {
        this.volumes.removeIf(v -> v.caster().blockPos().equals((Object)pos));
        this.getVolumes(world, pos, out, pos.method_10262((class_2382)lightBlockPos), lightBlockPos, lightPos, this.radius);
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        class_9380 box = this.getBox();
        for (class_2338 pos : it) {
            if (!box.method_58244(pos)) continue;
            this.dirty.add(pos);
        }
    }

    @Override
    public void init() {
        class_2680 state;
        DynamicLightInfo info;
        this.render = false;
        boolean dirty = this.isDirty;
        class_638 world = class_310.method_1551().field_1687;
        if (world != null && (info = DynamicLightInfo.get(state = world.method_8320(this.blockPos))) != null) {
            class_243 offset = info.offset().apply(state).orElse(new class_243(0.5, 0.5, 0.5));
            this.position.set((double)this.blockPos.method_10263() + offset.field_1352, (double)this.blockPos.method_10264() + offset.field_1351, (double)this.blockPos.method_10260() + offset.field_1350);
            info.initLight(this, state);
            this.render = true;
        }
        this.isDirty = dirty;
    }

    @Override
    public boolean render(boolean raytrace) {
        if (!this.render) {
            return false;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            class_287 builder;
            class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
            Vector3f lightPos = new Vector3f(this.getPosition().x, this.getPosition().y, this.getPosition().z);
            int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 2);
            class_9380 box = this.getBox();
            if (this.fullRebuildTask != null) {
                ++Vibrancy.NUM_LIGHT_TASKS;
            }
            if (!this.dirty.isEmpty()) {
                for (class_2338 class_23382 : this.dirty) {
                    if (!class_23382.equals((Object)lightBlockPos)) {
                        this.regenQuads(world, class_23382, this.volumes::add, lightBlockPos, lightPos);
                    }
                    for (class_2350 dir : class_2350.values()) {
                        class_2338 pos1 = class_23382.method_10093(dir);
                        if (pos1.equals((Object)lightBlockPos)) continue;
                        this.regenQuads(world, pos1, this.volumes::add, lightBlockPos, lightPos);
                    }
                }
                this.dirty.clear();
                builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                for (RaytracedLight.ShadowVolume volume : this.volumes) {
                    volume.render((class_4588)builder);
                }
                this.upload(builder, this.volumes);
                this.shadowCount = this.volumes.size();
            }
            if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                try {
                    this.volumes = this.fullRebuildTask.get();
                    this.fullRebuildTask = null;
                    builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                    for (RaytracedLight.ShadowVolume volume : this.volumes) {
                        volume.render((class_4588)builder);
                    }
                    this.upload(builder, this.volumes);
                    this.shadowCount = this.volumes.size();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace) {
                if (blockRadius < 1) {
                    raytrace = false;
                } else if (this.isDirty()) {
                    this.clean();
                    this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                        LinkedList volumes = new LinkedList();
                        for (int x = box.comp_2466().method_10263(); x <= box.comp_2467().method_10263(); ++x) {
                            for (int y = box.comp_2466().method_10264(); y <= box.comp_2467().method_10264(); ++y) {
                                for (int z = box.comp_2466().method_10260(); z <= box.comp_2467().method_10260(); ++z) {
                                    double sqDist;
                                    class_2338 pos = new class_2338(x, y, z);
                                    if (pos.equals((Object)lightBlockPos) || (sqDist = pos.method_10262((class_2382)lightBlockPos)) == 0.0 || !(sqDist < (double)(blockRadius * blockRadius))) continue;
                                    this.getVolumes(world, pos, volumes::add, sqDist, lightBlockPos, lightPos, this.radius);
                                }
                            }
                        }
                        return volumes;
                    });
                }
            }
            if (this.isVisible()) {
                class_4184 camera = class_310.method_1551().field_1773.method_19418();
                Matrix4f matrix4f = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
                this.renderMask(raytrace, lightPos, matrix4f);
                this.renderLight(lightPos, matrix4f);
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.blockPos.method_10263() + ", " + this.blockPos.method_10264() + ", " + this.blockPos.method_10260() + "]";
    }
}

