/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import foundry.veil.api.client.render.VeilRenderSystem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1087;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_777;
import net.minecraft.class_9801;
import net.typho.vibrancy.Vibrancy;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL15;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;

public interface RaytracedLight
extends NativeResource {
    public static final Set<class_2338> DIRTY = new HashSet<class_2338>();

    default public boolean isVisible() {
        return true;
    }

    public void updateDirty(Iterable<class_2338> var1);

    public void init();

    public boolean render(boolean var1);

    default public boolean shouldRemove() {
        return false;
    }

    default public boolean shouldRender(class_243 cam) {
        class_238 box = this.getBoundingBox();
        if (box == null) {
            return true;
        }
        return VeilRenderSystem.getCullingFrustum().testAab(box);
    }

    default public double getSortDistance() {
        return this.getSortDistance(class_310.method_1551().field_1773.method_19418().method_19326());
    }

    default public double getSortDistance(class_243 cam) {
        return 0.0;
    }

    @Nullable
    default public class_238 getBoundingBox() {
        return null;
    }

    default public void getQuads(Iterable<class_777> bakedQuads, class_2338 pos, Consumer<Quad> out, class_243 offset, @Nullable class_2350 direction) {
        for (class_777 quad : bakedQuads) {
            Vector3f[] positions = new Vector3f[4];
            Vector2f[] uvs = new Vector2f[4];
            int[] data = quad.method_3357();
            int len = data.length / 8;
            int i = 0;
            int j = 0;
            while (i < len) {
                positions[i] = new Vector3f(Float.intBitsToFloat(data[j]) + (float)pos.method_10263() + (float)offset.field_1352, Float.intBitsToFloat(data[j + 1]) + (float)pos.method_10264() + (float)offset.field_1351, Float.intBitsToFloat(data[j + 2]) + (float)pos.method_10260() + (float)offset.field_1350);
                uvs[i] = new Vector2f(Float.intBitsToFloat(data[j + 4]), Float.intBitsToFloat(data[j + 5]));
                ++i;
                j += 8;
            }
            out.accept(new Quad(pos, direction, positions[0], positions[1], positions[2], positions[3], uvs[0], uvs[1], uvs[2], uvs[3]));
        }
    }

    default public void getQuads(class_638 world, class_2338 pos, Consumer<Quad> out, boolean close, class_2338 blockPos, boolean normalTest, Predicate<class_2350> predicate) {
        this.getQuads(world, pos, out, close, new Vector3f((float)(pos.method_10263() - blockPos.method_10263()), (float)(pos.method_10264() - blockPos.method_10264()), (float)(pos.method_10260() - blockPos.method_10260())), normalTest, predicate);
    }

    default public void getQuads(class_638 world, class_2338 pos, Consumer<Quad> out, boolean close, Vector3f lightDirection, boolean normalTest, Predicate<@Nullable class_2350> predicate) {
        class_2680 state = world.method_8320(pos);
        if (!((Boolean)Vibrancy.TRANSPARENCY_TEST.method_41753()).booleanValue() && state.method_26167((class_1922)world, pos)) {
            return;
        }
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        class_5819 random = class_5819.method_43047();
        class_243 offset = state.method_26226((class_1922)world, pos);
        for (class_2350 direction : class_2350.values()) {
            if (!predicate.test(direction) || !close && (!class_2248.method_9607((class_2680)state, (class_1922)world, (class_2338)pos, (class_2350)direction, (class_2338)pos.method_10093(direction)) || normalTest && !Vibrancy.pointsToward(direction, lightDirection))) continue;
            this.getQuads(model.method_4707(state, direction, random), pos, out, offset, direction);
        }
        if (predicate.test(null)) {
            this.getQuads(model.method_4707(state, null, random), pos, out, offset, null);
        }
    }

    default public void upload(class_287 builder, Collection<? extends IQuad> quads, class_291 geomVBO, int quadsSSBO, int usage) {
        class_9801 mesh = builder.method_60794();
        if (mesh == null) {
            return;
        }
        geomVBO.method_1353();
        geomVBO.method_1352(mesh);
        class_291.method_1354();
        ByteBuffer buf = MemoryUtil.memAlloc((int)(quads.size() * 160));
        for (IQuad iQuad : quads) {
            iQuad.toQuad().put(buf);
        }
        GL15.glBindBuffer((int)37074, (int)quadsSSBO);
        GL15.glBufferData((int)37074, (ByteBuffer)buf.flip(), (int)usage);
        GL15.glBindBuffer((int)37074, (int)0);
        MemoryUtil.memFree((Buffer)buf);
    }

    public record Quad(class_2338 blockPos, @Nullable class_2350 direction, @Nullable class_2338 relative, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4, Vector3f n, float d, Vector3f e1, Vector3f e2) implements IQuad
    {
        public static final int BYTES = 160;

        public Quad(class_2338 blockPos, @Nullable class_2350 direction, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, Vector2f uv1, Vector2f uv2, Vector2f uv3, Vector2f uv4) {
            this(blockPos, direction, direction == null ? null : blockPos.method_10093(direction), v1, v2, v3, v4, uv1, uv2, uv3, uv4, new Vector3f((Vector3fc)v2).sub((Vector3fc)v1).cross((Vector3fc)new Vector3f((Vector3fc)v4).sub((Vector3fc)v1)).normalize(), new Vector3f((Vector3fc)v2).sub((Vector3fc)v1).cross((Vector3fc)new Vector3f((Vector3fc)v4).sub((Vector3fc)v1)).normalize().dot((Vector3fc)v1), new Vector3f((Vector3fc)v2).sub((Vector3fc)v1), new Vector3f((Vector3fc)v4).sub((Vector3fc)v1));
        }

        @Override
        public Quad toQuad() {
            return this;
        }

        public void put(ByteBuffer buf) {
            buf.putFloat(this.v1.x).putFloat(this.v1.y).putFloat(this.v1.z).putFloat(0.0f);
            buf.putFloat(this.v2.x).putFloat(this.v2.y).putFloat(this.v2.z).putFloat(0.0f);
            buf.putFloat(this.v3.x).putFloat(this.v3.y).putFloat(this.v3.z).putFloat(0.0f);
            buf.putFloat(this.v4.x).putFloat(this.v4.y).putFloat(this.v4.z).putFloat(0.0f);
            buf.putFloat(this.uv1.x).putFloat(this.uv1.y);
            buf.putFloat(this.uv2.x).putFloat(this.uv2.y);
            buf.putFloat(this.uv3.x).putFloat(this.uv3.y);
            buf.putFloat(this.uv4.x).putFloat(this.uv4.y);
            buf.putFloat(this.n.x).putFloat(this.n.y).putFloat(this.n.z).putFloat(this.d);
            buf.putFloat(this.e1.x).putFloat(this.e1.y).putFloat(this.e1.z).putFloat(this.e1.dot((Vector3fc)this.e1));
            buf.putFloat(this.e2.x).putFloat(this.e2.y).putFloat(this.e2.z).putFloat(this.e2.dot((Vector3fc)this.e2));
            float d11 = this.e1.dot((Vector3fc)this.e1);
            float d12 = this.e1.dot((Vector3fc)this.e2);
            float d22 = this.e2.dot((Vector3fc)this.e2);
            float invDet = 1.0f / (d11 * d22 - d12 * d12);
            float inv11 = d22 * invDet;
            float inv12 = -d12 * invDet;
            float inv21 = -d12 * invDet;
            float inv22 = d11 * invDet;
            buf.putFloat(inv11).putFloat(inv12).putFloat(inv21).putFloat(inv22);
        }

        public ShadowVolume toVolumeSphere(Vector3f origin, float radius) {
            float d0 = this.n.dot((Vector3fc)this.v1.sub((Vector3fc)origin, new Vector3f()));
            float t = radius - d0;
            Vector3f[] vertices = new Vector3f[]{this.v1, this.v2, this.v3, this.v4, null, null, null, null};
            for (int i = 0; i < 4; ++i) {
                Vector3f vertex = new Vector3f((Vector3fc)vertices[i]);
                Vector3f off = vertex.sub((Vector3fc)origin, new Vector3f());
                vertices[i + 4] = vertex.add((Vector3fc)off.normalize(t));
            }
            return new ShadowVolume(this, vertices);
        }

        public ShadowVolume toVolumeSky(Vector3f direction, float distance) {
            Vector3f add = direction.mul(-distance, new Vector3f());
            Vector3f[] vertices = new Vector3f[]{this.v1, this.v2, this.v3, this.v4, null, null, null, null};
            for (int i = 0; i < 4; ++i) {
                vertices[i + 4] = new Vector3f((Vector3fc)vertices[i]).add((Vector3fc)add);
            }
            return new ShadowVolume(this, vertices);
        }
    }

    public static interface IQuad {
        public Quad toQuad();
    }

    public record ShadowVolume(Quad caster, Vector3f[] vertices) implements IQuad
    {
        @Override
        public Quad toQuad() {
            return this.caster;
        }

        public void render(class_4588 consumer) {
            consumer.method_60830(this.vertices()[0]).method_60830(this.vertices()[1]).method_60830(this.vertices()[2]).method_60830(this.vertices()[3]);
            consumer.method_60830(this.vertices()[1]).method_60830(this.vertices()[5]).method_60830(this.vertices()[6]).method_60830(this.vertices()[2]);
            consumer.method_60830(this.vertices()[5]).method_60830(this.vertices()[4]).method_60830(this.vertices()[7]).method_60830(this.vertices()[6]);
            consumer.method_60830(this.vertices()[4]).method_60830(this.vertices()[0]).method_60830(this.vertices()[3]).method_60830(this.vertices()[7]);
            consumer.method_60830(this.vertices()[1]).method_60830(this.vertices()[0]).method_60830(this.vertices()[4]).method_60830(this.vertices()[5]);
            consumer.method_60830(this.vertices()[3]).method_60830(this.vertices()[2]).method_60830(this.vertices()[6]).method_60830(this.vertices()[7]);
        }
    }
}

