/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy.light;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_9380;
import net.typho.vibrancy.Vibrancy;
import net.typho.vibrancy.light.RaytracedLight;
import net.typho.vibrancy.mixin.LightTextureAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;

public abstract class SkyLight
implements RaytracedLight {
    @Nullable
    public static SkyLight INSTANCE;
    protected final class_291 linesVBO = new class_291(class_291.class_8555.field_44794);
    protected final Map<class_1923, Chunk> chunks = new LinkedHashMap<class_1923, Chunk>();
    protected final List<class_1923> chunksToAdd = new LinkedList<class_1923>();
    protected Vector3f direction;
    protected float distance = 128.0f;
    protected boolean isDirty = true;
    protected int shadowCount = 0;

    public void markDirty() {
        this.isDirty = true;
    }

    public void clean() {
        this.isDirty = false;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void appendDebugInfo(Consumer<String> out) {
        out.accept("Sky Light Chunks: " + this.chunks.size());
        out.accept("Sky Light Shadows: " + this.shadowCount + " / " + this.chunks.values().stream().mapToInt(chunk -> chunk.quads.size()).sum());
        out.accept("Sky Light Direction: (" + this.direction.x + ", " + this.direction.y + ", " + this.direction.z + ")");
    }

    @Override
    public void updateDirty(Iterable<class_2338> it) {
        for (class_2338 pos : it) {
            this.chunks.computeIfAbsent((class_1923)new class_1923((class_2338)pos), (Function<class_1923, Chunk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateDirty$1(net.minecraft.class_1923 ), (Lnet/minecraft/class_1923;)Lnet/typho/vibrancy/light/SkyLight$Chunk;)((SkyLight)this)).dirty.add(pos);
        }
    }

    @Override
    public void init() {
    }

    public void onChunkLoad(class_1923 pos) {
        this.chunksToAdd.add(pos);
    }

    public void onChunkUnload(class_1923 pos) {
        this.chunksToAdd.remove(pos);
        Chunk chunk1 = this.chunks.remove(pos);
        if (chunk1 != null) {
            chunk1.free();
        }
    }

    public void onChunkUpdate(class_1923 pos) {
        Chunk chunk1 = this.chunks.get(pos);
        if (chunk1 == null) {
            this.onChunkLoad(pos);
        } else {
            chunk1.markDirty();
        }
    }

    public abstract Vector3f getDirection(class_638 var1);

    public abstract Vector3f getColor(class_638 var1);

    protected boolean shouldCastBlock(class_638 level, class_2338 pos) {
        if (level.method_8320(pos).method_26167((class_1922)level, pos)) {
            return false;
        }
        for (class_2350 direction : new class_2350[]{class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034}) {
            if (level.method_8314(class_1944.field_9284, pos.method_10093(direction)) == 0) continue;
            return true;
        }
        return false;
    }

    protected void renderMask(boolean raytrace, Matrix4f view) {
        AdvancedFbo fbo = Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("shadow_mask")));
        fbo.bind(true);
        GL15.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL15.glClearStencil((int)0);
        GL15.glClear((int)17664);
        if (raytrace) {
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)1);
            GL15.glStencilFunc((int)519, (int)1, (int)1);
            GL15.glStencilOp((int)7680, (int)7680, (int)7681);
            class_1921 stencilType = VeilRenderType.get((class_2960)Vibrancy.id("sky_stencil"), (Object[])new Object[0]);
            stencilType.method_23516();
            Vibrancy.SCREEN_VBO.method_1353();
            Vibrancy.SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();
            stencilType.method_23518();
            for (Chunk chunk : this.chunks.values()) {
                chunk.renderMask(view);
            }
            GL15.glDisable((int)2960);
        }
    }

    protected void renderLight(class_638 level) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(Vibrancy.id("ray_light"))).bind(true);
        VeilRenderSystem.setShader((class_2960)Vibrancy.id("light/ray/sky"));
        class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());
        shader.method_35785("LightDirection").method_34413(this.direction);
        shader.method_35785("LightColor").method_34413(this.getColor(level));
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.blendEquation((int)32774);
        Vibrancy.SCREEN_VBO.method_1353();
        Vibrancy.SCREEN_VBO.method_34427(null, null, shader);
        class_291.method_1354();
        RenderSystem.disableBlend();
    }

    @Override
    public boolean render(boolean raytrace) {
        this.shadowCount = 0;
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            this.direction = this.getDirection(level);
            this.chunksToAdd.removeIf(pos -> {
                if (level.method_8393(pos.field_9181, pos.field_9180) && level.method_8393(pos.field_9181 + 1, pos.field_9180) && level.method_8393(pos.field_9181 - 1, pos.field_9180) && level.method_8393(pos.field_9181, pos.field_9180 + 1) && level.method_8393(pos.field_9181, pos.field_9180 - 1)) {
                    this.chunks.computeIfAbsent((class_1923)pos, x$0 -> new Chunk((class_1923)x$0)).markDirty();
                    return true;
                }
                return false;
            });
            int distanceSq = (Integer)Vibrancy.SKY_SHADOW_DISTANCE.method_41753() * (Integer)Vibrancy.SKY_SHADOW_DISTANCE.method_41753();
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.pos.method_52566(class_310.method_1551().field_1724.method_31476()) <= distanceSq) {
                    chunk.render = true;
                    chunk.init(level, raytrace);
                    continue;
                }
                chunk.render = false;
            }
            this.clean();
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            Matrix4f view = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
            this.renderMask(raytrace, view);
            this.renderLight(level);
            if (Vibrancy.DEBUG_SKY_LIGHT_VIEW) {
                class_287 consumer = class_289.method_1348().method_60827(class_293.class_5596.field_27377, class_290.field_29337);
                boolean any = false;
                for (Chunk chunk : this.chunks.values()) {
                    if (chunk.shadowCount <= 0 || !chunk.render) continue;
                    for (RaytracedLight.Quad quad : chunk.quads) {
                        Vector3f[] order;
                        any = true;
                        Vector3f color = quad.direction() == null || Vibrancy.pointsToward(quad.direction(), this.direction) ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(1.0f, 0.0f, 0.0f);
                        for (Vector3f vec : order = new Vector3f[]{quad.v1(), quad.v2(), quad.v2(), quad.v3(), quad.v3(), quad.v4(), quad.v4(), quad.v1(), quad.v1(), quad.v3(), quad.v2(), quad.v4()}) {
                            consumer.method_22912(vec.x, vec.y, vec.z).method_22915(color.x, color.y, color.z, 1.0f).method_22914(0.0f, 1.0f, 0.0f);
                        }
                    }
                }
                if (any) {
                    class_1921 type = VeilRenderType.get((class_2960)Vibrancy.id("debug_lines"), (Object[])new Object[0]);
                    type.method_23516();
                    this.linesVBO.method_1353();
                    this.linesVBO.method_1352(consumer.method_60794());
                    this.linesVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                    class_291.method_1354();
                    type.method_23518();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRender(class_243 cam) {
        return true;
    }

    public void free() {
        for (Chunk chunk : this.chunks.values()) {
            chunk.free();
        }
        this.chunks.clear();
    }

    private /* synthetic */ Chunk lambda$updateDirty$1(class_1923 x$0) {
        return new Chunk(x$0);
    }

    protected class Chunk
    implements NativeResource {
        protected final class_291 vbo = new class_291(class_291.class_8555.field_44793);
        protected final int ssbo = GL15.glGenBuffers();
        protected final List<class_2338> dirty = new LinkedList<class_2338>();
        protected List<RaytracedLight.Quad> quads = new LinkedList<RaytracedLight.Quad>();
        protected CompletableFuture<List<RaytracedLight.Quad>> fullRebuildTask;
        protected final class_1923 pos;
        protected boolean isDirty = true;
        protected boolean render = false;
        protected int shadowCount = 0;
        protected class_9380 box;

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        protected Chunk(class_1923 pos) {
            this.pos = pos;
        }

        public void free() {
            this.vbo.close();
            GL15.glDeleteBuffers((int)this.ssbo);
        }

        protected void upload(class_287 builder, Collection<? extends RaytracedLight.IQuad> volumes) {
            SkyLight.this.upload(builder, volumes, this.vbo, this.ssbo, 35044);
            this.shadowCount = volumes.size();
        }

        protected void regenQuads(class_638 level, class_2338 pos, Consumer<RaytracedLight.Quad> out) {
            this.quads.removeIf(quad -> quad.blockPos().equals((Object)pos));
            if (SkyLight.this.shouldCastBlock(level, pos)) {
                SkyLight.this.getQuads(level, pos, out, false, SkyLight.this.direction, false, dir -> true);
            }
        }

        protected void init(class_638 level, boolean raytrace) {
            if (this.fullRebuildTask != null) {
                ++Vibrancy.NUM_LIGHT_TASKS;
            }
            for (class_2338 pos : this.dirty) {
                this.regenQuads(level, pos, this.quads::add);
                for (class_2350 dir : class_2350.values()) {
                    this.regenQuads(level, pos.method_10093(dir), this.quads::add);
                }
            }
            this.dirty.clear();
            if (this.fullRebuildTask != null && this.fullRebuildTask.isDone()) {
                try {
                    this.quads = this.fullRebuildTask.get();
                    this.fullRebuildTask = null;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else if (raytrace && (this.isDirty() || SkyLight.this.isDirty())) {
                if (this.isDirty()) {
                    this.clean();
                }
                this.fullRebuildTask = CompletableFuture.supplyAsync(() -> {
                    LinkedList quads = new LinkedList();
                    if (level.method_8393(this.pos.field_9181, this.pos.field_9180)) {
                        class_2818 chunk = level.method_8497(this.pos.field_9181, this.pos.field_9180);
                        for (int i = chunk.method_32891(); i < chunk.method_31597(); ++i) {
                            class_2826 section = chunk.method_38259(chunk.method_31603(i));
                            class_2338 minPos = class_4076.method_18681((class_1923)chunk.method_12004(), (int)i).method_19767();
                            for (int x = 0; x < 16; ++x) {
                                for (int y = 0; y < 16; ++y) {
                                    for (int z = 0; z < 16; ++z) {
                                        class_2338 blockPos = new class_2338(minPos.method_10263() + x, minPos.method_10264() + y, minPos.method_10260() + z);
                                        if (!SkyLight.this.shouldCastBlock(level, blockPos)) continue;
                                        class_2680 state = section.method_12254(x, y, z);
                                        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
                                        class_5819 random = class_5819.method_43047();
                                        class_243 offset = state.method_26226((class_1922)level, blockPos);
                                        for (class_2350 direction : class_2350.values()) {
                                            if (!(state.method_26204() instanceof class_2397 ? level.method_8320(blockPos.method_10093(direction)).method_26215() : class_2248.method_9607((class_2680)state, (class_1922)level, (class_2338)blockPos, (class_2350)direction, (class_2338)blockPos.method_10093(direction)))) continue;
                                            SkyLight.this.getQuads(model.method_4707(state, direction, random), blockPos, quads::add, offset, direction);
                                        }
                                        SkyLight.this.getQuads(model.method_4707(state, null, random), blockPos, quads::add, offset, null);
                                    }
                                }
                            }
                        }
                    }
                    return quads;
                });
            }
            class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
            LinkedList newQuads = new LinkedList();
            this.quads.removeIf(quad -> {
                if (quad.relative() != null && level.method_8314(class_1944.field_9284, quad.relative()) == 0) {
                    return true;
                }
                if (quad.direction() == null || Vibrancy.pointsToward(quad.direction(), SkyLight.this.direction)) {
                    quad.toVolumeSky(SkyLight.this.direction, SkyLight.this.distance).render((class_4588)builder);
                    newQuads.add(quad);
                }
                return false;
            });
            this.upload(builder, newQuads);
        }

        protected void renderMask(Matrix4f view) {
            if (this.shadowCount == 0 || !this.render) {
                return;
            }
            this.box = null;
            for (RaytracedLight.Quad quad : this.quads) {
                if (this.box == null) {
                    this.box = class_9380.method_58236((class_2338)quad.blockPos());
                    continue;
                }
                this.box = this.box.method_58241(quad.blockPos());
            }
            if (this.box == null) {
                return;
            }
            class_1921 type = VeilRenderType.get((class_2960)Vibrancy.id("sky_shadow"), (Object[])new Object[0]);
            type.method_23516();
            GL15.glEnable((int)2960);
            GL15.glStencilMask((int)255);
            GL15.glStencilFunc((int)514, (int)1, (int)1);
            GL15.glStencilOp((int)7680, (int)7680, (int)7680);
            GL30.glBindBufferBase((int)37074, (int)0, (int)this.ssbo);
            class_5944 shader = Objects.requireNonNull(RenderSystem.getShader());
            shader.method_35785("MaxLength").method_1251(SkyLight.this.distance);
            shader.method_35785("LightDirection").method_34413(SkyLight.this.direction);
            shader.method_34583("AtlasSampler", (Object)class_310.method_1551().method_1554().method_24153(class_1723.field_21668));
            this.vbo.method_1353();
            this.vbo.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            class_291.method_1354();
            GL30.glBindBufferBase((int)37074, (int)0, (int)0);
            type.method_23518();
            SkyLight.this.shadowCount += this.shadowCount;
        }
    }

    public static class Overworld
    extends SkyLight {
        @Override
        public Vector3f getDirection(class_638 level) {
            float sunAngle = level.method_8442(0.0f);
            float x = (float)(-Math.sin(sunAngle));
            float y = (float)Math.cos(sunAngle);
            if (y < 0.0f) {
                x = -x;
                y = -y;
            }
            return new Vector3f(x, y, 0.0f);
        }

        @Override
        public Vector3f getColor(class_638 level) {
            Color color = new Color(((LightTextureAccessor)class_310.method_1551().field_1773.method_22974()).getLightPixels().method_4315(0, 15));
            return new Vector3f((float)color.getRed() / 255.0f / 2.0f, (float)color.getGreen() / 255.0f / 2.0f, (float)color.getBlue() / 255.0f / 2.0f);
        }
    }
}

