package net.typho.vibrancy;

import foundry.veil.api.client.render.light.Light;
import org.lwjgl.system.NativeResource;

import java.util.Collection;
import java.util.Comparator;
import net.minecraft.class_310;

public abstract class RaytracedLightRenderer<T extends Light & RaytracedLight> implements NativeResource {
    public int numRaytraced = 0, numVisible = 0;

    public void render() {
        Vibrancy.blitViewPos();
        int[] cap = {0};
        numRaytraced = 0;
        numVisible = 0;

        getLights().stream()
                .sorted(Comparator.comparingDouble(light -> light.lazyDistance(class_310.method_1551().field_1773.method_19418().method_19326())))
                .filter(light -> {
                    boolean b = light.lazyDistance(class_310.method_1551().field_1773.method_19418().method_19326()) / 16 < Vibrancy.LIGHT_CULL_DISTANCE.method_41753() * Vibrancy.LIGHT_CULL_DISTANCE.method_41753();

                    if (b) {
                        numVisible++;
                    }

                    return b;
                })
                .forEachOrdered(light -> {
                    boolean b = cap[0]++ < Vibrancy.maxLights();

                    if (b) {
                        numRaytraced++;
                    }

                    light.render(b);
                });

        RaytracedPointLight.DIRTY.clear();
    }

    public abstract Collection<? extends T> getLights();
}
