package net.typho.vibrancy.mixin;

import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

@Mixin(class_5321.class)
public abstract class RegistryKeyMixin {
    @Shadow
    public abstract class_2960 getValue();

    @Shadow
    public abstract class_2960 getRegistry();

    @Unique
    @Intrinsic
    public boolean equals(Object o) {
        return o instanceof class_5321<?> key && key.method_29177().equals(getValue()) && key.method_41185().equals(getRegistry());
    }

    @Unique
    @Intrinsic
    public int hashCode() {
        return Objects.hash(getValue(), getRegistry());
    }
}
