/*
 * Decompiled with CFR 0.152.
 */
package net.typho.vibrancy;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.light.PointLight;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.typho.vibrancy.RaytracedLight;
import net.typho.vibrancy.Vibrancy;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;

public class RaytracedPointLight
extends PointLight
implements RaytracedLight {
    public static final class_291 SCREEN_VBO = new class_291(class_291.class_8555.field_44793);
    protected final class_291 geomVBO = new class_291(class_291.class_8555.field_44794);
    protected final int quadsSSBO = GL15.glGenBuffers();
    protected boolean remove = false;
    protected boolean anyShadows = false;
    protected float flicker = 0.0f;
    protected float flickerMin;
    protected float flickerMax;
    protected float flickerStart = (float)GLFW.glfwGetTime();

    public float getFlicker() {
        return this.flicker;
    }

    public RaytracedPointLight setFlicker(float flicker) {
        this.flicker = flicker;
        this.markDirty();
        return this;
    }

    @Override
    public double lazyDistance(class_243 vec) {
        return this.getPosition().distanceSquared(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    @Override
    public void render(boolean raytrace) {
        class_2338 lightBlockPos = new class_2338((int)Math.floor(this.getPosition().x), (int)Math.floor(this.getPosition().y), (int)Math.floor(this.getPosition().z));
        if (this.isDirty() && raytrace) {
            this.clean();
            class_638 world = class_310.method_1551().field_1687;
            if (world != null) {
                int numQuads = 0;
                Vector3f lightPos = new Vector3f((float)this.getPosition().x, (float)this.getPosition().y, (float)this.getPosition().z);
                int blockRadius = Vibrancy.capShadowDistance((int)Math.ceil(this.radius) - 4);
                if (blockRadius < 1) {
                    raytrace = false;
                } else {
                    PrintWriter out;
                    class_3341 box = new class_3341(lightBlockPos).method_35410(blockRadius);
                    class_4587 stack = new class_4587();
                    class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
                    LinkedList<RaytracedLight.Quad> quads = new LinkedList<RaytracedLight.Quad>();
                    try {
                        out = FabricLoader.getInstance().isDevelopmentEnvironment() && new File("mesh.obj").exists() ? null : new PrintWriter("mesh.obj");
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    for (int x = box.method_35415(); x <= box.method_35418(); ++x) {
                        for (int y = box.method_35416(); y <= box.method_35419(); ++y) {
                            for (int z = box.method_35417(); z <= box.method_35420(); ++z) {
                                class_2338 pos = new class_2338(x, y, z);
                                double sqDist = pos.method_10262((class_2382)lightBlockPos);
                                if (sqDist == 0.0 || !(sqDist < (double)(blockRadius * blockRadius))) continue;
                                class_2680 state = world.method_8320(pos);
                                stack.method_22903();
                                stack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                                final LinkedList flatVertices = new LinkedList();
                                final LinkedList normals = new LinkedList();
                                final LinkedList flatTexCoords = new LinkedList();
                                class_1921 layer = class_4696.method_23679((class_2680)state);
                                class_310.method_1551().method_1541().method_3355(state, pos, (class_1920)world, stack, new class_4588(){

                                    public class_4588 method_22912(float x, float y, float z) {
                                        flatVertices.add(new Vector3f(x, y, z));
                                        return this;
                                    }

                                    public class_4588 method_1336(int red, int green, int blue, int alpha) {
                                        return this;
                                    }

                                    public class_4588 method_22913(float u, float v) {
                                        flatTexCoords.add(new Vector2f(u, v));
                                        return this;
                                    }

                                    public class_4588 method_60796(int u, int v) {
                                        return this;
                                    }

                                    public class_4588 method_22921(int u, int v) {
                                        return this;
                                    }

                                    public class_4588 method_22914(float x, float y, float z) {
                                        normals.add(new Vector3f(x, y, z));
                                        return this;
                                    }
                                }, sqDist != 1.0, class_5819.method_43049((long)lightBlockPos.hashCode()));
                                if (flatVertices.size() % 4 != 0) {
                                    System.err.println("[Vibrancy] Block " + String.valueOf(state) + " doesn't use quads for rendering, skipping it for raytracing");
                                } else {
                                    block5: for (int j = 0; j < flatVertices.size(); j += 4) {
                                        for (int k = j; k < j + 4; ++k) {
                                            int i;
                                            if (!(((Vector3f)normals.get(k)).dot((Vector3fc)lightPos.sub((Vector3fc)flatVertices.get(k), new Vector3f())) > 0.0f) && !(((Vector3f)flatVertices.get(k)).distanceSquared((Vector3fc)lightPos) < 4.0f)) continue;
                                            Vector3f[] vertices = new Vector3f[]{(Vector3f)flatVertices.get(j), (Vector3f)flatVertices.get(j + 1), (Vector3f)flatVertices.get(j + 2), (Vector3f)flatVertices.get(j + 3), null, null, null, null};
                                            for (i = 0; i < 4; ++i) {
                                                Vector3f vertex = new Vector3f((Vector3fc)vertices[i]);
                                                Vector3f off = vertex.sub((Vector3fc)lightPos, new Vector3f());
                                                vertices[i + 4] = vertex.add((Vector3fc)off.normalize(this.radius - off.length() + 1.0f));
                                            }
                                            quads.add(new RaytracedLight.Quad(vertices[0], vertices[1], vertices[2], vertices[3], (Vector2f)flatTexCoords.get(j), (Vector2f)flatTexCoords.get(j + 1), (Vector2f)flatTexCoords.get(j + 2), (Vector2f)flatTexCoords.get(j + 3), layer.method_60894() || layer != class_1921.method_23577()));
                                            builder.method_60830(vertices[0]).method_60830(vertices[1]).method_60830(vertices[2]).method_60830(vertices[3]);
                                            builder.method_60830(vertices[1]).method_60830(vertices[5]).method_60830(vertices[6]).method_60830(vertices[2]);
                                            builder.method_60830(vertices[5]).method_60830(vertices[4]).method_60830(vertices[7]).method_60830(vertices[6]);
                                            builder.method_60830(vertices[4]).method_60830(vertices[0]).method_60830(vertices[3]).method_60830(vertices[7]);
                                            builder.method_60830(vertices[1]).method_60830(vertices[0]).method_60830(vertices[4]).method_60830(vertices[5]);
                                            builder.method_60830(vertices[3]).method_60830(vertices[2]).method_60830(vertices[6]).method_60830(vertices[7]);
                                            if (out != null) {
                                                i = numQuads * 4 + 1;
                                                out.println("v " + vertices[0].x + " " + vertices[0].y + " " + vertices[0].z);
                                                out.println("v " + vertices[1].x + " " + vertices[1].y + " " + vertices[1].z);
                                                out.println("v " + vertices[2].x + " " + vertices[2].y + " " + vertices[2].z);
                                                out.println("v " + vertices[3].x + " " + vertices[3].y + " " + vertices[3].z);
                                                out.println("v " + vertices[1].x + " " + vertices[1].y + " " + vertices[1].z);
                                                out.println("v " + vertices[5].x + " " + vertices[5].y + " " + vertices[5].z);
                                                out.println("v " + vertices[6].x + " " + vertices[6].y + " " + vertices[6].z);
                                                out.println("v " + vertices[2].x + " " + vertices[2].y + " " + vertices[2].z);
                                                out.println("v " + vertices[5].x + " " + vertices[5].y + " " + vertices[5].z);
                                                out.println("v " + vertices[4].x + " " + vertices[4].y + " " + vertices[4].z);
                                                out.println("v " + vertices[7].x + " " + vertices[7].y + " " + vertices[7].z);
                                                out.println("v " + vertices[6].x + " " + vertices[6].y + " " + vertices[6].z);
                                                out.println("v " + vertices[4].x + " " + vertices[4].y + " " + vertices[4].z);
                                                out.println("v " + vertices[0].x + " " + vertices[0].y + " " + vertices[0].z);
                                                out.println("v " + vertices[3].x + " " + vertices[3].y + " " + vertices[3].z);
                                                out.println("v " + vertices[7].x + " " + vertices[7].y + " " + vertices[7].z);
                                                out.println("v " + vertices[1].x + " " + vertices[1].y + " " + vertices[1].z);
                                                out.println("v " + vertices[0].x + " " + vertices[0].y + " " + vertices[0].z);
                                                out.println("v " + vertices[4].x + " " + vertices[4].y + " " + vertices[4].z);
                                                out.println("v " + vertices[5].x + " " + vertices[5].y + " " + vertices[5].z);
                                                out.println("v " + vertices[3].x + " " + vertices[3].y + " " + vertices[3].z);
                                                out.println("v " + vertices[2].x + " " + vertices[2].y + " " + vertices[2].z);
                                                out.println("v " + vertices[6].x + " " + vertices[6].y + " " + vertices[6].z);
                                                out.println("v " + vertices[7].x + " " + vertices[7].y + " " + vertices[7].z);
                                                out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                                out.println("f " + i++ + " " + i++ + " " + i++ + " " + i++);
                                            }
                                            numQuads += 6;
                                            continue block5;
                                        }
                                    }
                                }
                                stack.method_22909();
                            }
                        }
                    }
                    if (numQuads == 0) {
                        this.anyShadows = false;
                    } else {
                        this.anyShadows = true;
                        this.geomVBO.method_1353();
                        this.geomVBO.method_1352(builder.method_60800());
                        class_291.method_1354();
                        ByteBuffer buf = MemoryUtil.memAlloc((int)(quads.size() * 160));
                        for (RaytracedLight.Quad quad : quads) {
                            quad.put(buf);
                        }
                        GL15.glBindBuffer((int)37074, (int)this.quadsSSBO);
                        GL15.glBufferData((int)37074, (ByteBuffer)buf.flip(), (int)35048);
                        GL15.glBindBuffer((int)37074, (int)0);
                        MemoryUtil.memFree((Buffer)buf);
                    }
                }
            }
        }
        if (this.isVisible()) {
            class_5944 shader;
            class_4184 camera = class_310.method_1551().field_1773.method_19418();
            Matrix4f view = new Matrix4f().rotate((Quaternionfc)camera.method_23767().invert(new Quaternionf())).translate((float)(-camera.method_19326().field_1352), (float)(-camera.method_19326().field_1351), (float)(-camera.method_19326().field_1350));
            if (this.anyShadows && raytrace) {
                VeilRenderSystem.setShader((class_2960)class_2960.method_60655((String)"vibrancy", (String)"light/ray/mask"));
                shader = Objects.requireNonNull(RenderSystem.getShader());
                shader.method_35785("LightPos").method_1249((float)this.position.x, (float)this.position.y, (float)this.position.z);
                shader.method_35785("Detailed").method_35649(this.position.distanceSquared(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350) < (double)class_3532.method_34954((int)((Integer)Vibrancy.RAYTRACE_DISTANCE.method_41753() * 16)) ? 1 : 0);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
                GL30.glBindBufferBase((int)37074, (int)0, (int)this.quadsSSBO);
                GL15.glCullFace((int)1028);
                GL15.glDepthFunc((int)518);
                this.renderMask(class_2960.method_60655((String)"vibrancy", (String)"shadow_mask_back"), view, 0.0);
                GL15.glCullFace((int)1029);
                GL15.glDepthFunc((int)515);
                this.renderMask(class_2960.method_60655((String)"vibrancy", (String)"shadow_mask_front"), view, 1.0);
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                GL30.glBindBufferBase((int)37074, (int)0, (int)0);
            }
            Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(VeilFramebuffers.LIGHT)).bind(true);
            VeilRenderSystem.setShader((class_2960)class_2960.method_60655((String)"vibrancy", (String)"light/ray/point"));
            shader = Objects.requireNonNull(RenderSystem.getShader());
            float time = (float)GLFW.glfwGetTime();
            while ((double)(time - this.flickerStart) > 0.25) {
                this.flickerStart += 0.25f;
                this.flickerMin = this.flickerMax;
                this.flickerMax = new Random().nextFloat(-1.0f, 1.0f);
            }
            float brightness = this.getBrightness() * (1.0f + this.flicker * class_3532.method_16439((float)((time - this.flickerStart) * 4.0f), (float)this.flickerMin, (float)this.flickerMax));
            shader.method_35785("LightPos").method_1249((float)this.position.x, (float)this.position.y, (float)this.position.z);
            shader.method_35785("LightColor").method_1249(this.color.x * brightness, this.color.y * brightness, this.color.z * brightness);
            shader.method_35785("LightRadius").method_1251(this.radius);
            shader.method_35785("AnyShadows").method_35649(this.anyShadows ? 1 : 0);
            SCREEN_VBO.method_1353();
            SCREEN_VBO.method_34427(view, RenderSystem.getProjectionMatrix(), shader);
            class_291.method_1354();
        }
    }

    protected void renderMask(class_2960 fbo, Matrix4f view, double depthClear) {
        Objects.requireNonNull(VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(fbo)).bind(true);
        GL15.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL15.glClearDepth((double)depthClear);
        GL15.glClear((int)16640);
        this.geomVBO.method_1353();
        this.geomVBO.method_34427(view, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        class_291.method_1354();
    }

    public void free() {
        this.geomVBO.close();
        GL15.glDeleteBuffers((int)this.quadsSSBO);
    }

    static {
        class_287 bufferBuilder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27380, class_290.field_1592);
        bufferBuilder.method_22912(-1.0f, 1.0f, 0.0f);
        bufferBuilder.method_22912(-1.0f, -1.0f, 0.0f);
        bufferBuilder.method_22912(1.0f, 1.0f, 0.0f);
        bufferBuilder.method_22912(1.0f, -1.0f, 0.0f);
        SCREEN_VBO.method_1353();
        SCREEN_VBO.method_1352(bufferBuilder.method_60800());
        class_291.method_1354();
    }
}

