package xyz.verarr.synchrono.external_apis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URI;

public class HTTPHelper {
    public static String get(URI uri) {
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection) uri.toURL().openConnection();
        } catch (IOException e) { throw new RuntimeException(e); }
        try {
            conn.setRequestMethod("GET");
        } catch (ProtocolException e) { throw new RuntimeException(e); }

        StringBuilder result = new StringBuilder();
        try (BufferedReader reader =
                 new BufferedReader(new InputStreamReader(conn.getInputStream()))) {
            for (String line; (line = reader.readLine()) != null;) {
                result.append(line);
            }
        } catch (IOException e) { throw new RuntimeException(e); }

        return result.toString();
    }
}
