package xyz.verarr.synchrono.mixin;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.eclipseisoffline.customtimecycle.TimeManager;
import xyz.verarr.synchrono.IRLTimeManager;
import xyz.verarr.synchrono.Synchrono;
import xyz.verarr.synchrono.config.SynchronoConfig;

@Mixin(class_3218.class)
public class ServerLevelTimeMixin {
    @Shadow @Final private class_5268 worldProperties;
    @Unique private IRLTimeManager               irlTimeManager;

    @Unique private Instant lastUpdateTime;
    @Unique private long    lastUpdateTimeTicks;

    @Inject(method = "<init>", at = @At("TAIL"))
    public void
    initializeIRLTimeManager(MinecraftServer                 server,
                             Executor                        workerExecutor,
                             class_32.class_5143            session,
                             class_5268           properties,
                             class_5321<class_1937>              worldKey,
                             class_5363                dimensionOptions,
                             class_3949 worldGenerationProgressListener,
                             boolean                         debugWorld,
                             long                            seed,
                             List<class_5304>            spawners,
                             boolean                         shouldTickTime,
                             class_8565            randomSequencesState,
                             CallbackInfo                    ci) {
        irlTimeManager = IRLTimeManager.getInstance((class_3218) (Object) this);
        irlTimeManager.method_80();
    }

    @Unique
    public void updateTime() {
        if (!SynchronoConfig.gametimeEnabled) return;

        lastUpdateTime      = Instant.now();
        lastUpdateTimeTicks = worldProperties.method_188();

        TimeManager   timeManager = TimeManager.getInstance((class_3218) (Object) this);
        LocalDateTime now         = LocalDateTime.now(SynchronoConfig.timezone());
        int           daytime     = irlTimeManager.daytimeTicksAt(now);
        int           nighttime   = irlTimeManager.nighttimeTicksAt(now);
        if (SynchronoConfig.setRate) {
            Synchrono.LOGGER.info("Setting time rate: {} {}", daytime, nighttime);
            timeManager.setTimeRate(daytime, nighttime);
        }

        long ticks = irlTimeManager.tickAt(LocalDateTime.now(SynchronoConfig.timezone()));
        if (SynchronoConfig.setTime) {
            Synchrono.LOGGER.info("Time is: {}", ticks);
            this.worldProperties.method_29035(ticks);
        }
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    public void initialUpdateTime(MinecraftServer                 server,
                                  Executor                        workerExecutor,
                                  class_32.class_5143            session,
                                  class_5268           properties,
                                  class_5321<class_1937>              worldKey,
                                  class_5363                dimensionOptions,
                                  class_3949 worldGenerationProgressListener,
                                  boolean                         debugWorld,
                                  long                            seed,
                                  List<class_5304>            spawners,
                                  boolean                         shouldTickTime,
                                  class_8565            randomSequencesState,
                                  CallbackInfo                    ci) {
        updateTime();
    }

    @Inject(method = "tickTime", at = @At("TAIL"))
    public void periodicallyUpdateTime(CallbackInfo ci) {
        String reason;

        long minutesSinceLastUpdate     = ChronoUnit.MINUTES.between(lastUpdateTime, Instant.now());
        long serverTicksSinceLastUpdate = worldProperties.method_188() - lastUpdateTimeTicks;
        long wallClockTicksSinceLastUpdate =
            (ChronoUnit.MILLIS.between(lastUpdateTime, Instant.now()) * 20) / 1000;

        if (minutesSinceLastUpdate >= 30)
            reason = "30 wall clock minutes have passed since last update";
        else if (wallClockTicksSinceLastUpdate >= serverTicksSinceLastUpdate + 200)
            reason = "Time out of sync (" + wallClockTicksSinceLastUpdate
                   + " >= " + serverTicksSinceLastUpdate + " + 200)";
        else if (SynchronoConfig.bruteForce) reason = "Brute-force mode enabled";
        else return;

        updateTime();
        Synchrono.LOGGER.info("Time update triggered because: {}", reason);
    }
}
