package xyz.verarr.synchrono.mixin;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.verarr.synchrono.Synchrono;
import xyz.verarr.synchrono.config.SynchronoConfig;
import xyz.verarr.synchrono.external_apis.OpenMeteoAPI;
import xyz.verarr.synchrono.weather_models.VanillaWeatherModel;
import xyz.verarr.synchrono.weather_models.WeatherModel;

@Mixin(class_3218.class)
public class ServerLevelWeatherMixin {
    @Shadow @Final private class_5268 worldProperties;
    @Unique private Instant                      lastUpdateWeather = Instant.MIN;

    @Unique
    public void updateWeather() {
        lastUpdateWeather = Instant.now();

        OpenMeteoAPI.WeatherCode weatherCode =
            OpenMeteoAPI.queryCurrent(SynchronoConfig.latitude, SynchronoConfig.longitude);

        // TODO: more weather models (with mods)
        WeatherModel weatherModel = switch (SynchronoConfig.weatherModel) {
            case VANILLA -> VanillaWeatherModel.getInstance();
        };
        weatherModel.apply(weatherCode, (class_3218) (Object) this);

        Synchrono.LOGGER.info("Weather code is: {}", weatherCode.getRawValue());
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    public void
    initialUpdateWeather(MinecraftServer                 server,
                         Executor                        workerExecutor,
                         class_32.class_5143            session,
                         class_5268           properties,
                         class_5321<class_1937>              worldKey,
                         class_5363                dimensionOptions,
                         class_3949 worldGenerationProgressListener,
                         boolean                         debugWorld,
                         long                            seed,
                         List<class_5304>            spawners,
                         boolean                         shouldTickTime,
                         class_8565            randomSequencesState,
                         CallbackInfo                    ci) {
        if (SynchronoConfig.weatherEnabled) updateWeather();
    }

    @Inject(
        method = "tickWeather",
        at     = @At(
            value = "INVOKE",
            shift = At.Shift.AFTER,
            target =
                "Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$Key;)Z"))
    public void
    periodicallyUpdateWeather(CallbackInfo ci) {
        if (!SynchronoConfig.weatherEnabled) {
            lastUpdateWeather = Instant.MIN;
            return;
        };

        String reason;

        long minutesSinceLastUpdate = ChronoUnit.MINUTES.between(lastUpdateWeather, Instant.now());

        if (minutesSinceLastUpdate >= 5)
            reason = "5 wall clock minutes have passed since last update";
        else return;

        updateWeather();
        Synchrono.LOGGER.info("Weather update triggered because: {}", reason);
    }

    @ModifyExpressionValue(
        method = "tickWeather",
        at     = @At(
            value = "INVOKE",
            target =
                "Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$Key;)Z"))
    public boolean
    doDaylightCycle(boolean original) {
        return SynchronoConfig.weatherEnabled ? false : original;
    }
}
