/*
 * Decompiled with CFR 0.152.
 */
package xyz.verarr.synchrono;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_3218;
import xyz.verarr.synchrono.config.SynchronoConfig;
import xyz.verarr.synchrono.external_apis.SunriseSunsetAPI;

public class IRLTimeManager
extends class_18 {
    private static final String FIRST_START_DATE_NBT_TAG = "first_start_date";
    private static final int TICKS_PER_DAY = 24000;
    private static final int TICKS_PER_HALF_DAY = 12000;
    private static final int SERVER_TICKS_PER_SECOND = 20;
    public LocalDate firstStartDate;

    public IRLTimeManager() {
        this.firstStartDate = LocalDate.now(ZoneId.of("UTC"));
    }

    public IRLTimeManager(long firstStartDate) {
        this.firstStartDate = LocalDate.ofEpochDay(firstStartDate);
    }

    private static class_10741<IRLTimeManager> type(class_3218 world) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf(FIRST_START_DATE_NBT_TAG).forGetter(manager -> manager.firstStartDate.toEpochDay())).apply((Applicative)instance, IRLTimeManager::new));
        return new class_10741("synchrono", IRLTimeManager::new, codec, null);
    }

    public static IRLTimeManager getInstance(class_3218 world) {
        return (IRLTimeManager)world.method_17983().method_17924(IRLTimeManager.type(world));
    }

    private SunriseSunsetAPI.SunriseSunsetData querySunriseSunsetAPI(LocalDate localDate) {
        return SunriseSunsetAPI.query(localDate, SynchronoConfig.latitude, SynchronoConfig.longitude);
    }

    public long tickAt(Instant instant) {
        long days = ChronoUnit.DAYS.between(this.firstStartDate, instant.atZone(ZoneId.of("UTC")).toLocalDate());
        long ticks = days * 24000L;
        LocalDate yesterday = instant.minus(Duration.ofDays(1L)).atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate today = instant.atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate tomorrow = instant.plus(Duration.ofDays(1L)).atZone(ZoneId.of("UTC")).toLocalDate();
        SunriseSunsetAPI.SunriseSunsetData yesterday_data = this.querySunriseSunsetAPI(yesterday);
        SunriseSunsetAPI.SunriseSunsetData today_data = this.querySunriseSunsetAPI(today);
        SunriseSunsetAPI.SunriseSunsetData tomorrow_data = this.querySunriseSunsetAPI(tomorrow);
        if (instant.isBefore(today_data.sunrise)) {
            Duration night_length = Duration.between(yesterday_data.sunset, today_data.sunrise);
            Duration since_sunset = Duration.between(yesterday_data.sunset, instant);
            double tick_scalar = (double)since_sunset.toMillis() / (double)night_length.toMillis();
            ticks -= 12000L - (long)(12000.0 * tick_scalar);
        } else if (instant.isAfter(today_data.sunset)) {
            Duration night_length = Duration.between(today_data.sunset, tomorrow_data.sunrise);
            Duration since_sunset = Duration.between(today_data.sunset, instant);
            double tick_scalar = (double)since_sunset.toMillis() / (double)night_length.toMillis();
            ticks += 12000L + (long)(12000.0 * tick_scalar);
        } else {
            Duration day_length = Duration.between(today_data.sunrise, today_data.sunset);
            Duration since_sunrise = Duration.between(today_data.sunrise, instant);
            double tick_scalar = (double)since_sunrise.toMillis() / (double)day_length.toMillis();
            ticks += (long)(12000.0 * tick_scalar);
        }
        if (SynchronoConfig.invert) {
            ticks += 12000L;
        }
        ticks = Math.round((double)ticks * SynchronoConfig.scalar);
        if ((ticks += (long)SynchronoConfig.offsetTicks) < 0L) {
            ticks = (ticks % 24000L + 24000L) % 24000L;
        }
        return ticks;
    }

    public int daytimeTicksAt(Instant instant) {
        int daytimeTicks = !SynchronoConfig.invert ? this.hardDaytimeTicksAt(instant) : this.hardNighttimeTicksAt(instant) + 12000;
        daytimeTicks = (int)Math.round((double)daytimeTicks / SynchronoConfig.scalar);
        return daytimeTicks;
    }

    public int nighttimeTicksAt(Instant instant) {
        int nighttimeTicks = !SynchronoConfig.invert ? this.hardNighttimeTicksAt(instant) : this.hardDaytimeTicksAt(instant) + 12000;
        nighttimeTicks = (int)Math.round((double)nighttimeTicks / SynchronoConfig.scalar);
        return nighttimeTicks;
    }

    private int hardDaytimeTicksAt(Instant instant) {
        LocalDate yesterday = instant.minus(Duration.ofDays(1L)).atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate today = instant.atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate tomorrow = instant.plus(Duration.ofDays(1L)).atZone(ZoneId.of("UTC")).toLocalDate();
        SunriseSunsetAPI.SunriseSunsetData yesterdayData = this.querySunriseSunsetAPI(yesterday);
        SunriseSunsetAPI.SunriseSunsetData todayData = this.querySunriseSunsetAPI(today);
        SunriseSunsetAPI.SunriseSunsetData tomorrowData = this.querySunriseSunsetAPI(tomorrow);
        if (instant.isBefore(todayData.sunrise)) {
            return (int)(Duration.between(todayData.sunrise, todayData.sunset).toSeconds() * 20L);
        }
        if (instant.isAfter(todayData.sunset)) {
            return (int)(Duration.between(tomorrowData.sunrise, tomorrowData.sunset).toSeconds() * 20L);
        }
        return (int)(Duration.between(todayData.sunrise, todayData.sunset).toSeconds() * 20L);
    }

    private int hardNighttimeTicksAt(Instant instant) {
        LocalDate yesterday = instant.minus(Duration.ofDays(1L)).atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate today = instant.atZone(ZoneId.of("UTC")).toLocalDate();
        LocalDate tomorrow = instant.plus(Duration.ofDays(1L)).atZone(ZoneId.of("UTC")).toLocalDate();
        SunriseSunsetAPI.SunriseSunsetData yesterdayData = this.querySunriseSunsetAPI(yesterday);
        SunriseSunsetAPI.SunriseSunsetData todayData = this.querySunriseSunsetAPI(today);
        SunriseSunsetAPI.SunriseSunsetData tomorrowData = this.querySunriseSunsetAPI(tomorrow);
        if (instant.isBefore(todayData.sunrise)) {
            return (int)(Duration.between(yesterdayData.sunset, todayData.sunrise).toSeconds() * 20L);
        }
        if (instant.isAfter(todayData.sunset)) {
            return (int)(Duration.between(todayData.sunset, tomorrowData.sunrise).toSeconds() * 20L);
        }
        return (int)(Duration.between(todayData.sunset, tomorrowData.sunrise).toSeconds() * 20L);
    }
}

