/*
 * Decompiled with CFR 0.152.
 */
package xyz.verarr.synchrono.external_apis;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.verarr.synchrono.external_apis.HTTPHelper;

public class OpenMeteoAPI {
    private static final String API_URL = "https://api.open-meteo.com/v1/forecast";

    @NotNull
    public static WeatherCode queryCurrent(double latitude, double longitude) throws RuntimeException {
        JsonObject jsonObject;
        URI uri;
        try {
            Formatter formatter = new Formatter(Locale.ROOT);
            uri = new URI(API_URL + String.valueOf(formatter.format("?latitude=%f&longitude=%f&current=weather_code", latitude, longitude)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String result = HTTPHelper.get(uri);
        try {
            jsonObject = JsonParser.parseString((String)result).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new RuntimeException(String.valueOf((Object)e) + " URL: " + String.valueOf(uri) + " JSON: " + result);
        }
        JsonObject results = jsonObject.getAsJsonObject("current");
        JsonObject units = jsonObject.getAsJsonObject("current_units");
        if (!Objects.equals(units.get("weather_code").getAsString(), "wmo code")) {
            throw new RuntimeException("URL: " + String.valueOf(uri) + " JSON: " + result);
        }
        return new WeatherCode(results.get("weather_code").getAsInt());
    }

    public static class WeatherCode {
        private static final Map<Integer, Float> RAIN_VALUES = ImmutableMap.of((Object)51, (Object)Float.valueOf(1.0f), (Object)53, (Object)Float.valueOf(1.33f), (Object)55, (Object)Float.valueOf(1.67f), (Object)61, (Object)Float.valueOf(2.0f), (Object)63, (Object)Float.valueOf(2.33f), (Object)65, (Object)Float.valueOf(2.67f), (Object)80, (Object)Float.valueOf(3.0f), (Object)81, (Object)Float.valueOf(3.33f), (Object)82, (Object)Float.valueOf(3.67f));
        private static final Map<Integer, Float> SLEET_VALUES = ImmutableMap.of((Object)56, (Object)Float.valueOf(1.0f), (Object)57, (Object)Float.valueOf(1.5f), (Object)66, (Object)Float.valueOf(2.0f), (Object)67, (Object)Float.valueOf(2.5f));
        private static final Map<Integer, Float> SNOW_VALUES = ImmutableMap.of((Object)71, (Object)Float.valueOf(1.0f), (Object)73, (Object)Float.valueOf(1.33f), (Object)75, (Object)Float.valueOf(1.67f), (Object)77, (Object)Float.valueOf(0.5f), (Object)85, (Object)Float.valueOf(2.0f), (Object)86, (Object)Float.valueOf(2.5f));
        private static final Map<Integer, Float> THUNDERSTORM_VALUES = ImmutableMap.of((Object)95, (Object)Float.valueOf(1.0f), (Object)96, (Object)Float.valueOf(2.0f), (Object)99, (Object)Float.valueOf(2.5f));
        private static final Map<Integer, Float> HAIL_VALUES = ImmutableMap.of((Object)96, (Object)Float.valueOf(1.0f), (Object)99, (Object)Float.valueOf(2.0f));
        private static final Map<Integer, Float> FOG_VALUES = ImmutableMap.of((Object)45, (Object)Float.valueOf(1.0f), (Object)48, (Object)Float.valueOf(2.0f));
        private static final Map<Integer, Float> CLOUDY_VALUES = ImmutableMap.of((Object)1, (Object)Float.valueOf(1.0f), (Object)2, (Object)Float.valueOf(2.0f), (Object)3, (Object)Float.valueOf(3.0f));
        private final int value;

        public WeatherCode(int value) {
            this.value = value;
        }

        private float getStrength(Map<Integer, Float> map) {
            return map.getOrDefault(this.value, Float.valueOf(0.0f)).floatValue();
        }

        public float rainStrength() {
            return this.getStrength(RAIN_VALUES);
        }

        public float sleetStrength() {
            return this.getStrength(SLEET_VALUES);
        }

        public float snowStrength() {
            return this.getStrength(SNOW_VALUES);
        }

        public float thunderstormStrength() {
            return this.getStrength(THUNDERSTORM_VALUES);
        }

        public float hailStrength() {
            return this.getStrength(HAIL_VALUES);
        }

        public float fogStrength() {
            return this.getStrength(FOG_VALUES);
        }

        public float cloudStrength() {
            return this.getStrength(CLOUDY_VALUES);
        }

        public int getRawValue() {
            return this.value;
        }
    }
}

