/*
 * Decompiled with CFR 0.152.
 */
package xyz.verarr.synchrono.external_apis;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xyz.verarr.synchrono.config.SynchronoConfig;
import xyz.verarr.synchrono.external_apis.HTTPHelper;

public class SunriseSunsetAPI {
    private static final String API_URL = "https://api.sunrisesunset.io/json";
    private static Map<SunriseSunsetAPIQuery, SunriseSunsetData> cache = new HashMap<SunriseSunsetAPIQuery, SunriseSunsetData>();

    @NotNull
    public static SunriseSunsetData query(LocalDate date, double latitude, double longitude) {
        return cache.computeIfAbsent(new SunriseSunsetAPIQuery(date, latitude, longitude), SunriseSunsetAPI::query);
    }

    @NotNull
    private static SunriseSunsetData query(SunriseSunsetAPIQuery details) {
        Instant sunset;
        Instant sunrise;
        JsonObject jsonObject;
        URI uri;
        SunriseSunsetData data = new SunriseSunsetData();
        try {
            Formatter formatter = new Formatter(Locale.ROOT);
            uri = new URI(API_URL + String.valueOf(formatter.format("?date=%s&lat=%f&lng=%f&timezone=UTC&time_format=unix", details.date.format(DateTimeFormatter.ISO_LOCAL_DATE), details.latitude, details.longitude)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String result = HTTPHelper.get(uri);
        try {
            jsonObject = JsonParser.parseString((String)result).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new RuntimeException(String.valueOf((Object)e) + " URL: " + String.valueOf(uri) + " JSON: " + result);
        }
        if (!jsonObject.get("status").getAsString().equals("OK")) {
            throw new RuntimeException("Not OK Json from API: " + String.valueOf(jsonObject));
        }
        JsonObject results = jsonObject.get("results").getAsJsonObject();
        try {
            sunrise = Instant.ofEpochSecond(Long.parseLong(results.get(SynchronoConfig.sunriseProperty).getAsString()));
            sunset = Instant.ofEpochSecond(Long.parseLong(results.get(SynchronoConfig.sunsetProperty).getAsString()));
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException(String.valueOf(e) + " JSON: " + result);
        }
        data.sunrise = sunrise;
        data.sunset = sunset;
        return data;
    }

    private static class SunriseSunsetAPIQuery {
        LocalDate date;
        double latitude;
        double longitude;
        ZoneId timezone;

        public SunriseSunsetAPIQuery(LocalDate date, double latitude, double longitude) {
            this.date = date;
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SunriseSunsetAPIQuery that = (SunriseSunsetAPIQuery)o;
            return this.date.isEqual(that.date) && Double.compare(that.latitude, this.latitude) == 0 && Double.compare(that.longitude, this.longitude) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.date, this.latitude, this.longitude, this.timezone);
        }
    }

    public static class SunriseSunsetData {
        public Instant sunrise;
        public Instant sunset;
    }
}

