/*
 * Decompiled with CFR 0.152.
 */
package xyz.verarr.synchrono.mixin;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.Executor;
import net.minecraft.class_1937;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.eclipseisoffline.customtimecycle.TimeManager;
import xyz.verarr.synchrono.IRLTimeManager;
import xyz.verarr.synchrono.Synchrono;
import xyz.verarr.synchrono.config.SynchronoConfig;

@Mixin(value={class_3218.class})
public class ServerLevelTimeMixin {
    @Shadow
    @Final
    private class_5268 field_24456;
    @Unique
    private IRLTimeManager irlTimeManager;
    @Unique
    private Instant lastUpdateTime;
    @Unique
    private long lastUpdateTimeTicks;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initializeIRLTimeManager(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> worldKey, class_5363 dimensionOptions, boolean debugWorld, long seed, List<class_5304> spawners, boolean shouldTickTime, class_8565 randomSequencesState, CallbackInfo ci) {
        this.irlTimeManager = IRLTimeManager.getInstance((class_3218)this);
        this.irlTimeManager.method_80();
    }

    @Unique
    public void updateTime() {
        if (!SynchronoConfig.gametimeEnabled) {
            return;
        }
        this.lastUpdateTime = Instant.now();
        this.lastUpdateTimeTicks = this.field_24456.method_188();
        TimeManager timeManager = TimeManager.getInstance((class_3218)((class_3218)this));
        Instant now = Instant.now();
        int daytime = this.irlTimeManager.daytimeTicksAt(now);
        int nighttime = this.irlTimeManager.nighttimeTicksAt(now);
        if (SynchronoConfig.setRate) {
            Synchrono.LOGGER.info("Setting time rate: {} {}", (Object)daytime, (Object)nighttime);
            timeManager.setTimeRate((long)daytime, (long)nighttime);
        }
        long ticks = this.irlTimeManager.tickAt(Instant.now());
        if (SynchronoConfig.setTime) {
            Synchrono.LOGGER.info("Time is: {}", (Object)ticks);
            this.field_24456.method_29035(ticks);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initialUpdateTime(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<class_1937> worldKey, class_5363 dimensionOptions, boolean debugWorld, long seed, List<class_5304> spawners, boolean shouldTickTime, class_8565 randomSequencesState, CallbackInfo ci) {
        this.updateTime();
    }

    @Inject(method={"tickTime"}, at={@At(value="TAIL")})
    public void periodicallyUpdateTime(CallbackInfo ci) {
        Object reason;
        long minutesSinceLastUpdate = ChronoUnit.MINUTES.between(this.lastUpdateTime, Instant.now());
        long serverTicksSinceLastUpdate = this.field_24456.method_188() - this.lastUpdateTimeTicks;
        long wallClockTicksSinceLastUpdate = ChronoUnit.MILLIS.between(this.lastUpdateTime, Instant.now()) * 20L / 1000L;
        if (minutesSinceLastUpdate >= 30L) {
            reason = "30 wall clock minutes have passed since last update";
        } else if (wallClockTicksSinceLastUpdate >= serverTicksSinceLastUpdate + 200L) {
            reason = "Time out of sync (" + wallClockTicksSinceLastUpdate + " >= " + serverTicksSinceLastUpdate + " + 200)";
        } else if (SynchronoConfig.bruteForce) {
            reason = "Brute-force mode enabled";
        } else {
            return;
        }
        this.updateTime();
        Synchrono.LOGGER.info("Time update triggered because: {}", reason);
    }
}

