/*
 * Decompiled with CFR 0.152.
 */
package org.test.weatherdisplay.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class ConfigManager {
    private static final Path CONFIG_PATH = Paths.get("config", "weatherdisplay.properties");
    private static final String IS_ENABLED = "IsEnabled";
    private static final String IS_CLEAR = "IsShowingClear";
    private static final String SHOWING_IMAGE = "ShowingImage";
    private static final String LOCATION_STATE = "LocationState";
    private static final String SELECTED_COLOUR = "SelectedColour";
    private static final String DEFAULT_ENABLED = "true";
    private static final String DEFAULT_CLEAR = "false";
    private static final String DEFAULT_IMAGE = "true";
    private static final String DEFAULT_LOCATION_STATE = "0";
    private static final String DEFAULT_COLOUR = "15";
    private static final Properties properties = new Properties();

    public static void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                properties.load(Files.newBufferedReader(CONFIG_PATH));
            } else {
                ConfigManager.saveDefaultConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            properties.store(Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]), "Weather Display Configuration");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveDefaultConfig() {
        properties.setProperty(IS_ENABLED, "true");
        properties.setProperty(IS_CLEAR, DEFAULT_CLEAR);
        properties.setProperty(SHOWING_IMAGE, "true");
        properties.setProperty(LOCATION_STATE, DEFAULT_LOCATION_STATE);
        properties.setProperty(SELECTED_COLOUR, DEFAULT_COLOUR);
        ConfigManager.saveConfig();
    }

    private static void updateProperty(String key, String value) {
        properties.setProperty(key, value);
        ConfigManager.saveConfig();
    }

    public static void setIsDisabled(boolean value) {
        ConfigManager.updateProperty(IS_ENABLED, Boolean.toString(value));
    }

    public static void setShowingClear(boolean value) {
        ConfigManager.updateProperty(IS_CLEAR, Boolean.toString(value));
    }

    public static void setShowingImage(boolean value) {
        ConfigManager.updateProperty(SHOWING_IMAGE, Boolean.toString(value));
    }

    public static void setLocationState(int value) {
        ConfigManager.updateProperty(LOCATION_STATE, Integer.toString(value));
    }

    public static void setColour(int value) {
        ConfigManager.updateProperty(SELECTED_COLOUR, Integer.toString(value));
    }

    public static boolean getIsDisabled() {
        return Boolean.parseBoolean(properties.getProperty(IS_ENABLED, "true"));
    }

    public static boolean getShowingClear() {
        return Boolean.parseBoolean(properties.getProperty(IS_CLEAR, DEFAULT_CLEAR));
    }

    public static boolean getImageStatus() {
        return Boolean.parseBoolean(properties.getProperty(SHOWING_IMAGE, "true"));
    }

    public static int getLocationState() {
        return Integer.parseInt(properties.getProperty(LOCATION_STATE, DEFAULT_LOCATION_STATE));
    }

    public static String getColour() {
        return properties.getProperty(SELECTED_COLOUR, DEFAULT_COLOUR);
    }
}

