/*
 * Decompiled with CFR 0.152.
 */
package org.test.weatherdisplay.client;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.test.weatherdisplay.client.ConfigManager;
import org.test.weatherdisplay.client.WeatherHandler;

public class WeatherDisplayClient
implements ClientModInitializer {
    public static class_310 mc;
    public static int state;
    public static boolean notDisabled;
    public static boolean clearDisabled;
    public static String selectedColour;
    public static boolean showImage;
    private static final Map<String, class_304> keyBindings;

    public void onInitializeClient() {
        mc = class_310.method_1551();
        notDisabled = true;
        clearDisabled = false;
        this.registerKeyBindings();
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.handleKeyBindings());
        this.loadConfigSettings();
        WeatherHandler.register();
    }

    private void registerKeyBindings() {
        keyBindings.put("ChangePosition", KeyBindingHelper.registerKeyBinding((class_304)new class_304("Change status position", class_3675.class_307.field_1668, 79, "Weather Display")));
        keyBindings.put("HideDisplay", KeyBindingHelper.registerKeyBinding((class_304)new class_304("Hide weather status", class_3675.class_307.field_1668, -1, "Weather Display")));
        keyBindings.put("DisableClear", KeyBindingHelper.registerKeyBinding((class_304)new class_304("Hide sunny/clear weather", class_3675.class_307.field_1668, -1, "Weather Display")));
        keyBindings.put("ChangeTextColor", KeyBindingHelper.registerKeyBinding((class_304)new class_304("Change weather status text color", class_3675.class_307.field_1668, 89, "Weather Display")));
        keyBindings.put("ToggleImageText", KeyBindingHelper.registerKeyBinding((class_304)new class_304("Toggle between image/text weather status", class_3675.class_307.field_1668, 73, "Weather Display")));
    }

    private void handleKeyBindings() {
        if (keyBindings.get("ChangePosition").method_1436()) {
            if (notDisabled) {
                state = (state + 1) % 5;
            }
            ConfigManager.setLocationState(state);
        }
        if (keyBindings.get("HideDisplay").method_1436()) {
            notDisabled = !notDisabled;
            WeatherDisplayClient.mc.field_1724.method_7353(class_2561.method_30163((String)(notDisabled ? "Weatherdisplay enabled." : "Weatherdisplay disabled.")), true);
            ConfigManager.setIsDisabled(notDisabled);
        }
        if (keyBindings.get("DisableClear").method_1436()) {
            clearDisabled = !clearDisabled;
            WeatherDisplayClient.mc.field_1724.method_7353(class_2561.method_30163((String)(clearDisabled ? "Sunny weather disabled." : "Sunny weather enabled.")), true);
            ConfigManager.setShowingClear(clearDisabled);
        }
        if (keyBindings.get("ChangeTextColor").method_1436()) {
            int colorSelected = (Integer.parseInt(ConfigManager.getColour()) + 1) % 16;
            ConfigManager.setColour(colorSelected);
            selectedColour = String.valueOf(colorSelected);
        }
        if (keyBindings.get("ToggleImageText").method_1436()) {
            showImage = !showImage;
            WeatherDisplayClient.mc.field_1724.method_7353(class_2561.method_30163((String)(showImage ? "Showing weather image." : "Showing weather text.")), true);
            ConfigManager.setShowingImage(showImage);
        }
    }

    private void loadConfigSettings() {
        state = ConfigManager.getLocationState();
        notDisabled = ConfigManager.getIsDisabled();
        clearDisabled = ConfigManager.getShowingClear();
        selectedColour = ConfigManager.getColour();
        showImage = ConfigManager.getImageStatus();
    }

    static {
        keyBindings = new HashMap<String, class_304>();
    }
}

