/*
 * Decompiled with CFR 0.152.
 */
package org.test.weatherdisplay.client;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_918;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.test.weatherdisplay.client.WeatherDisplayClient;

public class WeatherHandler {
    private static final class_2960 THUNDER_WEATHER_TEXTURE = class_2960.method_60655((String)"weatherdisplay", (String)"textures/thunder.png");
    private static final class_2960 RAIN_WEATHER_TEXTURE = class_2960.method_60655((String)"weatherdisplay", (String)"textures/rain.png");
    private static final class_2960 SUN_WEATHER_TEXTURE = class_2960.method_60655((String)"weatherdisplay", (String)"textures/sun.png");
    private static final class_2960 NONE_WEATHER_TEXTURE = class_2960.method_60655((String)"weatherdisplay", (String)"textures/none.png");

    public static void register() {
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerBefore(IdentifiedLayer.CHAT, class_2960.method_60655((String)"weatherdisplay", (String)"hud-layer"), WeatherHandler::renderHudLayer));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {});
    }

    private static void renderHudLayer(class_332 drawContext, class_9779 tickCounter) {
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            if (WeatherDisplayClient.showImage) {
                WeatherHandler.renderWeatherImage(drawContext, (class_1937)world);
            } else {
                WeatherHandler.renderWeatherText(drawContext, (class_1937)world);
            }
        }
    }

    private static void renderWeatherImage(class_332 drawContext, class_1937 world) {
        class_2960 textureToDraw = WeatherHandler.getWeatherTexture(world);
        int[] position = WeatherHandler.getImagePosition(class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
        drawContext.method_25290(class_1921::method_62277, textureToDraw, position[0], position[1], 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private static class_2960 getWeatherTexture(class_1937 world) {
        if (WeatherDisplayClient.mc.field_1687.method_8597().comp_648() && WeatherDisplayClient.notDisabled) {
            if (world.method_8546()) {
                return THUNDER_WEATHER_TEXTURE;
            }
            if (world.method_8419()) {
                return RAIN_WEATHER_TEXTURE;
            }
            if (!WeatherDisplayClient.clearDisabled) {
                return SUN_WEATHER_TEXTURE;
            }
        }
        return NONE_WEATHER_TEXTURE;
    }

    private static int[] getImagePosition(int width, int height) {
        int[] nArray;
        switch (WeatherDisplayClient.state) {
            case 0: {
                int[] nArray2 = new int[2];
                nArray2[0] = width / 2 + 94;
                nArray = nArray2;
                nArray2[1] = height - 18;
                break;
            }
            case 1: {
                int[] nArray3 = new int[2];
                nArray3[0] = width - 20;
                nArray = nArray3;
                nArray3[1] = 5;
                break;
            }
            case 2: {
                int[] nArray4 = new int[2];
                nArray4[0] = 5;
                nArray = nArray4;
                nArray4[1] = 5;
                break;
            }
            case 3: {
                int[] nArray5 = new int[2];
                nArray5[0] = 5;
                nArray = nArray5;
                nArray5[1] = height - 18;
                break;
            }
            case 4: {
                int[] nArray6 = new int[2];
                nArray6[0] = width - 20;
                nArray = nArray6;
                nArray6[1] = height - 18;
                break;
            }
            default: {
                int[] nArray7 = new int[2];
                nArray7[0] = width / 2 + 94;
                nArray = nArray7;
                nArray7[1] = height - 18;
            }
        }
        return nArray;
    }

    private static void renderWeatherText(class_332 drawContext, class_1937 world) {
        class_327 textRenderer = WeatherDisplayClient.mc.field_1772;
        String weatherText = WeatherHandler.getWeatherText(world);
        int correction = WeatherHandler.getTextCorrection(weatherText);
        class_5481 orderedText = class_2561.method_43470((String)weatherText).method_30937();
        int[] position = WeatherHandler.getPosition(WeatherDisplayClient.mc.method_22683().method_4486(), WeatherDisplayClient.mc.method_22683().method_4502(), correction);
        int color = WeatherHandler.getColorFromSelection(WeatherDisplayClient.selectedColour);
        int outlineColor = WeatherDisplayClient.selectedColour.equals("0") ? 0xFFFFFF : 0;
        WeatherHandler.drawTextWithOutline(drawContext, textRenderer, orderedText, position[0], position[1], color, outlineColor);
    }

    private static String getWeatherText(class_1937 world) {
        if (WeatherDisplayClient.mc.field_1687.method_8597().comp_648() && WeatherDisplayClient.notDisabled) {
            if (world.method_8546()) {
                return "Thundering";
            }
            if (world.method_8419()) {
                return "Raining";
            }
            if (!WeatherDisplayClient.clearDisabled) {
                return "Sunny";
            }
        }
        return "";
    }

    private static int getTextCorrection(String weatherText) {
        return switch (weatherText) {
            case "Thundering" -> 20;
            case "Sunny" -> -5;
            default -> 0;
        };
    }

    private static int[] getPosition(int width, int height, int correction) {
        int[] nArray;
        switch (WeatherDisplayClient.state) {
            case 0: {
                int[] nArray2 = new int[2];
                nArray2[0] = width / 2 + 96;
                nArray = nArray2;
                nArray2[1] = height - 14;
                break;
            }
            case 1: {
                int[] nArray3 = new int[2];
                nArray3[0] = width - 40 - correction;
                nArray = nArray3;
                nArray3[1] = 5;
                break;
            }
            case 2: {
                int[] nArray4 = new int[2];
                nArray4[0] = 5;
                nArray = nArray4;
                nArray4[1] = 5;
                break;
            }
            case 3: {
                int[] nArray5 = new int[2];
                nArray5[0] = 5;
                nArray = nArray5;
                nArray5[1] = height - 14;
                break;
            }
            case 4: {
                int[] nArray6 = new int[2];
                nArray6[0] = width - 40 - correction;
                nArray = nArray6;
                nArray6[1] = height - 14;
                break;
            }
            default: {
                int[] nArray7 = new int[2];
                nArray7[0] = width / 2 + 96;
                nArray = nArray7;
                nArray7[1] = height - 14;
            }
        }
        return nArray;
    }

    private static int getColorFromSelection(String selectedColour) {
        return switch (selectedColour) {
            case "0" -> 0;
            case "1" -> 170;
            case "2" -> 43520;
            case "3" -> 43690;
            case "4" -> 0xAA0000;
            case "5" -> 0xAA00AA;
            case "6" -> 0xFFAA00;
            case "7" -> 0xAAAAAA;
            case "8" -> 0x555555;
            case "9" -> 0x5555FF;
            case "10" -> 0x55FF55;
            case "11" -> 0x55FFFF;
            case "12" -> 0xFF5555;
            case "13" -> 0xFF55FF;
            case "14" -> 0xFFFF55;
            case "15" -> 0xFFFFFF;
            default -> 0xFFFFFF;
        };
    }

    private static void drawTextWithOutline(class_332 drawContext, class_327 textRenderer, class_5481 orderedText, int x, int y, int color, int outlineColor) {
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_4597.class_4598 vertexConsumers = WeatherDisplayClient.mc.method_22940().method_23000();
        int light = WeatherDisplayClient.mc.method_1561().method_23839((class_1297)WeatherDisplayClient.mc.field_1724, 0.0f);
        textRenderer.method_37296(orderedText, (float)x, (float)y, color, outlineColor, matrix, (class_4597)vertexConsumers, light);
        vertexConsumers.method_22993();
    }

    private static void renderBlockInHud(class_332 drawContext) {
        class_310 client = class_310.method_1551();
        class_918 itemRenderer = client.method_1480();
        class_1799 blockStack = new class_1799((class_1935)class_1802.field_20412);
        int x = 10;
        int y = 10;
        drawContext.method_51427(blockStack, x, y);
    }
}

